/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.nquads;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.rdf.io.ntriple.NTriplesSerializer;
import org.xbib.content.rdf.io.sink.CharSink;
import org.xbib.content.rdf.io.sink.QuadSink;

public class NQuadsSerializer
extends NTriplesSerializer
implements QuadSink {
    private static final Logger logger = Logger.getLogger(NQuadsSerializer.class.getName());
    private final CharSink sink;

    private NQuadsSerializer(CharSink sink) {
        super(sink);
        this.sink = sink;
    }

    public static QuadSink connect(CharSink sink) {
        return new NQuadsSerializer(sink);
    }

    @Override
    public void addNonLiteral(String subj, String pred, String obj, String graph) {
        try {
            this.startTriple(subj, pred);
            this.serializeBnodeOrUri(obj);
            if (graph != null) {
                this.serializeBnodeOrUri(graph);
            }
            this.sink.process(".\n");
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
    }

    @Override
    public void addPlainLiteral(String subj, String pred, String content, String lang, String graph) {
        try {
            this.startTriple(subj, pred);
            this.addContent(content);
            if (lang != null) {
                this.sink.process('@').process(lang);
            }
            this.sink.process(' ');
            if (graph != null) {
                this.serializeBnodeOrUri(graph);
            }
            this.sink.process(".\n");
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
    }

    @Override
    public void addTypedLiteral(String subj, String pred, String content, String type, String graph) {
        try {
            this.startTriple(subj, pred);
            this.addContent(content);
            this.sink.process("^^");
            this.serializeUri(type);
            if (graph != null) {
                this.serializeBnodeOrUri(graph);
            }
            this.sink.process(".\n");
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
    }
}

