/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.ntriple;

import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.RdfContentGenerator;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.Triple;
import org.xbib.content.rdf.io.ntriple.NTripleContentParams;
import org.xbib.content.resource.IRI;
import org.xbib.content.resource.Node;

public class NTripleContentGenerator
implements RdfContentGenerator<NTripleContentParams>,
Flushable {
    private static final Logger logger = Logger.getLogger(NTripleContentGenerator.class.getName());
    private static final char LF = '\n';
    private final Writer writer;
    private NTripleContentParams params = NTripleContentParams.N_TRIPLE_CONTENT_PARAMS;

    NTripleContentGenerator(OutputStream out) throws IOException {
        this(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    NTripleContentGenerator(Writer writer) throws IOException {
        this.writer = writer;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public NTripleContentGenerator receive(IRI iri) throws IOException {
        return this;
    }

    @Override
    public RdfContentGenerator<NTripleContentParams> setParams(NTripleContentParams rdfContentParams) {
        this.params = rdfContentParams;
        return this;
    }

    @Override
    public NTripleContentParams getParams() {
        return this.params;
    }

    public NTripleContentGenerator startStream() {
        return this;
    }

    @Override
    public RdfContentGenerator<NTripleContentParams> setBaseUri(String baseUri) {
        this.startPrefixMapping("", baseUri);
        return this;
    }

    public NTripleContentGenerator receive(Triple triple) throws IOException {
        this.writer.write(this.writeStatement(triple));
        return this;
    }

    public NTripleContentGenerator endStream() {
        return this;
    }

    public NTripleContentGenerator startPrefixMapping(String prefix, String uri) {
        this.params.getNamespaceContext().addNamespace(prefix, uri);
        return this;
    }

    public NTripleContentGenerator endPrefixMapping(String prefix) {
        return this;
    }

    public NTripleContentGenerator receive(Resource resource) throws IOException {
        resource.triples().forEach(t -> {
            try {
                this.writer.write(this.writeStatement((Triple)t));
            }
            catch (IOException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
        });
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    public String writeStatement(Triple stmt) throws IOException {
        Resource subj = stmt.subject();
        IRI pred = stmt.predicate();
        Node obj = stmt.object();
        return this.writeSubject(subj) + " " + this.writePredicate(pred) + " " + this.writeObject(obj) + " ." + '\n';
    }

    public String writeSubject(Resource subject) {
        return subject.isEmbedded() ? subject.toString() : "<" + this.escape(subject.toString()) + ">";
    }

    public String writePredicate(IRI predicate) {
        return "<" + this.escape(predicate.toString()) + ">";
    }

    public String writeObject(Node object) {
        if (object instanceof Resource) {
            Resource subject = (Resource)object;
            return this.writeSubject(subject);
        }
        if (object instanceof Literal) {
            Literal value = (Literal)object;
            String s = "\"" + this.escape(value.object().toString()) + "\"";
            String lang = value.lang();
            IRI type = value.type();
            if (lang != null) {
                return s + "@" + lang;
            }
            if (type != null) {
                return s + "^^<" + this.escape(type.toString()) + ">";
            }
            return s;
        }
        if (object instanceof IRI) {
            return "<" + this.escape(object.toString()) + ">";
        }
        return "<class?>^^" + object.getClass();
    }

    private String escape(String buffer) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < buffer.length(); ++i) {
            char ch = buffer.charAt(i);
            switch (ch) {
                case '\\': {
                    sb.append("\\\\");
                    continue block7;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block7;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block7;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                default: {
                    if (ch >= ' ' && ch <= '~') {
                        sb.append(ch);
                        continue block7;
                    }
                    sb.append("\\u");
                    String hexstr = Integer.toHexString(ch).toUpperCase();
                    for (int pad = 4 - hexstr.length(); pad > 0; --pad) {
                        sb.append("0");
                    }
                    sb.append(hexstr);
                }
            }
        }
        return sb.toString();
    }

    private Literal translateLanguage(Literal literal, String langTag) {
        if (literal == null) {
            return null;
        }
        String value = literal.object().toString();
        int pos = value.indexOf(" @");
        if (pos == 0) {
            literal.object(value.substring(1));
        } else if (pos > 0) {
            literal.object('\u0098' + value.substring(0, pos + 1) + '\u009c' + value.substring(pos + 2)).lang(langTag);
        }
        return literal;
    }
}

