/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.ntriple;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.xbib.content.rdf.RdfContentBuilder;
import org.xbib.content.rdf.RdfContentParams;
import org.xbib.content.rdf.RdfContentParser;
import org.xbib.content.rdf.RdfContentType;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.StandardRdfContentType;
import org.xbib.content.rdf.XSDResourceIdentifiers;
import org.xbib.content.rdf.internal.DefaultAnonymousResource;
import org.xbib.content.rdf.internal.DefaultTriple;
import org.xbib.content.resource.IRI;
import org.xbib.content.resource.Node;

public class NTripleContentParser<R extends RdfContentParams>
implements RdfContentParser<R> {
    private static final Resource resource = new DefaultAnonymousResource();
    private static final String RESOURCE_EXPRESSION = "(<[^<]+?>)";
    private static final String LITERAL_VALUE_EXPRESSION = "(\"([^\"]|\\\")*\")";
    private static final String ANONYMOUS_EXPRESSION = "(_:[^\\s]+?)";
    private static final String DATATYPE_EXPRESSION = "(\\^\\^(<[^<]+?>))";
    private static final String LANGUAGE_EXPRESSION = "(@([a-z]{2}?))";
    private static final String LITERAL_EXPRESSION = "((\"([^\"]|\\\")*\")((\\^\\^(<[^<]+?>))|(@([a-z]{2}?)))??)";
    private static final String SUBJECT_EXPRESSION = "((_:[^\\s]+?)|(<[^<]+?>))";
    private static final String PREDICATE_EXPRESSION = "((<[^<]+?>))";
    private static final String OBJECT_EXPRESSION = "((_:[^\\s]+?)|(<[^<]+?>)|((\"([^\"]|\\\")*\")((\\^\\^(<[^<]+?>))|(@([a-z]{2}?)))??))";
    private static final String TRIPLE_EXPRESSION = "((_:[^\\s]+?)|(<[^<]+?>))\\s+((<[^<]+?>))\\s+((_:[^\\s]+?)|(<[^<]+?>)|((\"([^\"]|\\\")*\")((\\^\\^(<[^<]+?>))|(@([a-z]{2}?)))??))\\s*\\.";
    private static final Pattern NTRIPLE_PATTERN = Pattern.compile("((_:[^\\s]+?)|(<[^<]+?>))\\s+((<[^<]+?>))\\s+((_:[^\\s]+?)|(<[^<]+?>)|((\"([^\"]|\\\")*\")((\\^\\^(<[^<]+?>))|(@([a-z]{2}?)))??))\\s*\\.");
    private final Reader reader;
    private boolean eof;
    private RdfContentBuilder<R> builder;

    public NTripleContentParser(InputStream in) throws IOException {
        this(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public NTripleContentParser(Reader reader) {
        this.reader = reader;
    }

    @Override
    public RdfContentType contentType() {
        return StandardRdfContentType.NTRIPLE;
    }

    public NTripleContentParser<R> setBuilder(RdfContentBuilder<R> builder) {
        this.builder = builder;
        return this;
    }

    @Override
    public NTripleContentParser<R> parse() throws IOException {
        this.eof = false;
        try (BufferedReader br = new BufferedReader(this.reader);){
            while (!this.eof) {
                this.parseLine(br.readLine());
                if (!this.eof) continue;
                break;
            }
        }
        return this;
    }

    private void parseLine(String line) throws IOException {
        XSDResourceIdentifiers object;
        Resource subject;
        if (line == null) {
            this.eof = true;
            return;
        }
        String s = line.trim();
        if (s.length() == 0 || s.startsWith("#")) {
            return;
        }
        Matcher matcher = NTRIPLE_PATTERN.matcher(s);
        if (!matcher.matches()) {
            throw new PatternSyntaxException("the given pattern ((_:[^\\s]+?)|(<[^<]+?>))\\s+((<[^<]+?>))\\s+((_:[^\\s]+?)|(<[^<]+?>)|((\"([^\"]|\\\")*\")((\\^\\^(<[^<]+?>))|(@([a-z]{2}?)))??))\\s*\\. doesn't match the expression:", s, -1);
        }
        if (matcher.group(2) != null) {
            subject = new DefaultAnonymousResource(matcher.group(1));
        } else {
            String subj = matcher.group(1);
            IRI subjURI = IRI.create((String)subj.substring(1, subj.length() - 1));
            subject = resource.newSubject(subjURI);
        }
        String p = matcher.group(4);
        IRI predicate = resource.newPredicate(IRI.create((String)p.substring(1, p.length() - 1)));
        if (matcher.group(7) != null) {
            object = new DefaultAnonymousResource(matcher.group(6));
        } else if (matcher.group(8) != null) {
            String obj = matcher.group(6);
            object = resource.newObject(IRI.builder().curie(obj.substring(1, obj.length() - 1)).build());
        } else {
            String literal = matcher.group(10);
            literal = literal.length() > 2 ? literal.substring(1, literal.length() - 1) : literal;
            object = matcher.groupCount() > 15 ? resource.newLiteral(literal).lang(matcher.group(16)) : resource.newLiteral(literal);
        }
        if (this.builder != null) {
            this.builder.receive(new DefaultTriple(subject, predicate, (Node)object));
        }
    }
}

