/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.ntriple;

import java.io.IOException;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.rdf.io.sink.CharSink;
import org.xbib.content.rdf.io.sink.TripleSink;

public final class NTriplesParser
implements CharSink {
    private static final Logger logger = Logger.getLogger(NTriplesParser.class.getName());
    private static final short PARSING_OUTSIDE = 0;
    private static final short PARSING_URI = 1;
    private static final short PARSING_BNODE = 2;
    private static final short PARSING_LITERAL = 3;
    private static final short PARSING_AFTER_LITERAL = 4;
    private static final short PARSING_LITERAL_TYPE = 5;
    private static final short PARSING_COMMENT = 6;
    private static final char SENTENCE_END = '.';
    private static final BitSet WHITESPACE = new BitSet(){
        private static final long serialVersionUID = 2369480497714252078L;
        {
            this.set(9);
            this.set(32);
            this.set(13);
            this.set(10);
        }
    };
    private final TripleSink sink;
    private String subj = null;
    private String pred = null;
    private String literalObj = null;
    private boolean skipSentence = false;
    private short parsingState;
    private int tokenStartPos;
    private short charsToEscape = 0;
    private boolean waitingForSentenceEnd = false;
    private StringBuilder addBuffer = null;

    private NTriplesParser(TripleSink sink) {
        this.sink = sink;
    }

    public static CharSink connect(TripleSink sink) {
        return new NTriplesParser(sink);
    }

    @Override
    public NTriplesParser process(String str) throws IOException {
        return this.process(str.toCharArray(), 0, str.length());
    }

    @Override
    public NTriplesParser process(char ch) throws IOException {
        char[] buffer = new char[]{ch};
        return this.process(buffer, 0, 1);
    }

    @Override
    public NTriplesParser process(char[] buffer, int start, int count) throws IOException {
        if (this.tokenStartPos != -1) {
            this.tokenStartPos = start;
        }
        int end = start + count;
        for (int pos = start; pos < end; ++pos) {
            if (this.skipSentence && buffer[pos] != '.') continue;
            this.skipSentence = false;
            if (this.parsingState == 0) {
                this.processOutsideChar(buffer, pos);
                continue;
            }
            if (this.parsingState == 6) {
                if (buffer[pos] != '\n' && buffer[pos] != '\r') continue;
                this.parsingState = 0;
                continue;
            }
            if (this.parsingState == 1) {
                if (buffer[pos] != '>') continue;
                this.onNonLiteral(this.unescape(this.extractToken(buffer, pos, 1)));
                this.parsingState = 0;
                continue;
            }
            if (this.parsingState == 2) {
                if (!WHITESPACE.get(buffer[pos]) && buffer[pos] != '.') continue;
                this.onNonLiteral(this.extractToken(buffer, pos - 1, 0));
                this.parsingState = 0;
                continue;
            }
            if (this.parsingState == 3) {
                this.processLiteralChar(buffer, pos);
                continue;
            }
            if (this.parsingState == 4) {
                if (buffer[pos] == '@' || buffer[pos] == '^') {
                    this.tokenStartPos = pos;
                    this.parsingState = (short)5;
                    continue;
                }
                if (WHITESPACE.get(buffer[pos]) || buffer[pos] == '.') {
                    this.onPlainLiteral(this.literalObj, null);
                    this.parsingState = 0;
                    this.processOutsideChar(buffer, pos);
                    continue;
                }
                logger.log(Level.SEVERE, "unexpected character '" + buffer[pos] + "' after literal");
                continue;
            }
            if (this.parsingState != 5) continue;
            this.processLiteralTypeChar(buffer, pos);
        }
        if (this.tokenStartPos != -1) {
            if (this.addBuffer == null) {
                this.addBuffer = new StringBuilder();
            }
            this.addBuffer.append(buffer, this.tokenStartPos, end - this.tokenStartPos);
        }
        return this;
    }

    private void processLiteralChar(char[] buffer, int pos) throws IOException {
        if (this.charsToEscape == 9 && buffer[pos] == 'u') {
            this.charsToEscape = (short)(this.charsToEscape - 5);
        } else if (this.charsToEscape == 9 && buffer[pos] != 'U') {
            this.charsToEscape = 0;
        } else if (this.charsToEscape > 0) {
            this.charsToEscape = (short)(this.charsToEscape - 1);
        } else if (buffer[pos] == '\"') {
            this.literalObj = this.unescape(this.extractToken(buffer, pos, 1));
            this.parsingState = (short)4;
        } else if (buffer[pos] == '\\') {
            this.charsToEscape = (short)9;
        }
    }

    private void processLiteralTypeChar(char[] buffer, int pos) throws IOException {
        if (WHITESPACE.get(buffer[pos])) {
            int trimSize;
            String type = this.extractToken(buffer, pos, 0);
            int n = trimSize = type.charAt(type.length() - 1) == '.' ? 1 : 0;
            if (type.charAt(0) == '@') {
                this.onPlainLiteral(this.literalObj, type.substring(1, type.length() - 1 - trimSize));
            } else if (type.startsWith("^^<") && type.charAt(type.length() - 2) == '>') {
                this.onTypedLiteral(this.literalObj, type.substring(3, type.length() - 2 - trimSize));
            } else {
                logger.log(Level.SEVERE, "literal type '" + type + "' can not be parsed");
            }
            this.parsingState = 0;
            if (trimSize > 0) {
                this.finishSentence();
            }
        }
    }

    private void processOutsideChar(char[] buffer, int pos) throws IOException {
        switch (buffer[pos]) {
            case '\"': {
                this.parsingState = (short)3;
                this.tokenStartPos = pos;
                break;
            }
            case '<': {
                this.parsingState = 1;
                this.tokenStartPos = pos;
                break;
            }
            case '_': {
                this.parsingState = (short)2;
                this.tokenStartPos = pos;
                break;
            }
            case '#': {
                this.parsingState = (short)6;
                break;
            }
            case '.': {
                this.finishSentence();
                break;
            }
            default: {
                if (WHITESPACE.get(buffer[pos])) break;
                logger.log(Level.SEVERE, "unexpected character '" + buffer[pos] + "'");
            }
        }
    }

    private void finishSentence() throws IOException {
        if (this.waitingForSentenceEnd) {
            this.waitingForSentenceEnd = false;
        } else {
            logger.log(Level.SEVERE, "unexpected end of sentence");
        }
    }

    private void onNonLiteral(String uri) throws IOException {
        if (this.waitingForSentenceEnd) {
            logger.log(Level.SEVERE, "endStream of sentence expected");
        }
        if (this.subj == null) {
            this.subj = uri;
        } else if (this.pred == null) {
            this.pred = uri;
        } else {
            this.sink.addNonLiteral(this.subj, this.pred, uri);
            this.resetTriple();
        }
    }

    private void onPlainLiteral(String value, String lang) throws IOException {
        if (this.subj == null || this.pred == null) {
            if (this.waitingForSentenceEnd) {
                logger.log(Level.SEVERE, "end of sentence expected");
            } else {
                logger.log(Level.SEVERE, "literal is not an object");
            }
        }
        this.sink.addPlainLiteral(this.subj, this.pred, value, lang);
        this.resetTriple();
    }

    private void onTypedLiteral(String value, String type) throws IOException {
        if (this.subj == null || this.pred == null) {
            if (this.waitingForSentenceEnd) {
                logger.log(Level.SEVERE, "end of sentence expected");
            } else {
                logger.log(Level.SEVERE, "literal is not an object");
            }
        }
        this.sink.addTypedLiteral(this.subj, this.pred, value, type);
        this.resetTriple();
    }

    @Override
    public void setBaseUri(String baseUri) {
    }

    private String extractToken(char[] buffer, int tokenEndPos, int trimSize) throws IOException {
        String saved;
        if (this.addBuffer != null) {
            if (tokenEndPos - trimSize >= this.tokenStartPos) {
                this.addBuffer.append(buffer, this.tokenStartPos, tokenEndPos - this.tokenStartPos - trimSize + 1);
            }
            this.addBuffer.delete(0, trimSize);
            saved = this.addBuffer.toString();
            this.addBuffer = null;
        } else {
            saved = String.valueOf(buffer, this.tokenStartPos + trimSize, tokenEndPos - this.tokenStartPos + 1 - 2 * trimSize);
        }
        this.tokenStartPos = -1;
        return saved;
    }

    @Override
    public void startStream() throws IOException {
        this.sink.startStream();
        this.resetTriple();
        this.waitingForSentenceEnd = false;
        this.parsingState = 0;
    }

    private void resetTriple() {
        this.addBuffer = null;
        this.tokenStartPos = -1;
        this.subj = null;
        this.pred = null;
        this.waitingForSentenceEnd = true;
    }

    @Override
    public void endStream() throws IOException {
        if (this.tokenStartPos != -1 || this.waitingForSentenceEnd) {
            logger.log(Level.SEVERE, "unexpected end of stream");
        }
        this.sink.endStream();
    }

    @Override
    public void beginDocument(String id) throws IOException {
        this.sink.beginDocument(id);
    }

    @Override
    public void endDocument(String id) throws IOException {
        this.sink.endDocument(id);
    }

    private String unescape(String str) throws IOException {
        int limit = str.length();
        StringBuilder result = new StringBuilder(limit);
        block10: for (int i = 0; i < limit; ++i) {
            char ch = str.charAt(i);
            if (ch != '\\') {
                result.append(ch);
                continue;
            }
            if (++i == limit) break;
            ch = str.charAt(i);
            switch (ch) {
                case 'b': {
                    result.append('\b');
                    continue block10;
                }
                case 'f': {
                    result.append('\f');
                    continue block10;
                }
                case 'n': {
                    result.append('\n');
                    continue block10;
                }
                case 'r': {
                    result.append('\r');
                    continue block10;
                }
                case 't': {
                    result.append('\t');
                    continue block10;
                }
                case 'U': 
                case 'u': {
                    int sequenceLength;
                    int n = sequenceLength = ch == 'u' ? 4 : 8;
                    if (i + sequenceLength >= limit) {
                        logger.log(Level.SEVERE, "error parsing escape sequence '\\" + ch + "'");
                    }
                    String code = str.substring(i + 1, i + 1 + sequenceLength);
                    i += sequenceLength;
                    try {
                        int value = Integer.parseInt(code, 16);
                        result.append((char)value);
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "error parsing escape sequence '\\" + ch + "'");
                    }
                    continue block10;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }
}

