/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.ntriple;

import java.io.IOException;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.rdf.RDF;
import org.xbib.content.rdf.io.sink.CharSink;
import org.xbib.content.rdf.io.sink.TripleSink;

public class NTriplesSerializer
implements TripleSink,
RDF {
    protected static final String DOT_EOL = ".\n";
    protected static final char SPACE = ' ';
    private static final Logger logger = Logger.getLogger(NTriplesSerializer.class.getName());
    private static final char QUOTE = '\"';
    private static final char URI_START = '<';
    private static final char URI_END = '>';
    private static final BitSet ESCAPABLE_CONTENT_CHARS = new BitSet();
    private static final BitSet ESCAPABLE_URI_CHARS = new BitSet();
    private final CharSink sink;

    protected NTriplesSerializer(CharSink sink) {
        this.sink = sink;
    }

    public static TripleSink connect(CharSink sink) {
        return new NTriplesSerializer(sink);
    }

    private static String escapeContent(String str) {
        char ch;
        int pos;
        int limit = str.length();
        for (pos = 0; pos < limit && (ch = str.charAt(pos)) <= '\u0080' && !ESCAPABLE_CONTENT_CHARS.get(ch); ++pos) {
        }
        if (pos == limit) {
            return str;
        }
        StringBuilder result = new StringBuilder(limit);
        result.append(str.substring(0, pos));
        while (pos < limit) {
            char ch2 = str.charAt(pos);
            if (ch2 < '\u0080') {
                switch (ch2) {
                    case '\"': 
                    case '\\': {
                        result.append('\\').append(ch2);
                        break;
                    }
                    case '\b': {
                        result.append("\\b");
                        break;
                    }
                    case '\f': {
                        result.append("\\f");
                        break;
                    }
                    case '\n': {
                        result.append("\\n");
                        break;
                    }
                    case '\r': {
                        result.append("\\r");
                        break;
                    }
                    case '\t': {
                        result.append("\\t");
                        break;
                    }
                    default: {
                        result.append(ch2);
                        break;
                    }
                }
            } else {
                result.append("\\u").append(String.format("%04X", ch2));
            }
            ++pos;
        }
        return result.toString();
    }

    private static String escapeUri(String str) {
        char ch;
        int pos;
        int limit = str.length();
        for (pos = 0; pos < limit && (ch = str.charAt(pos)) <= '\u0080' && !ESCAPABLE_URI_CHARS.get(ch); ++pos) {
        }
        if (pos == limit) {
            return str;
        }
        StringBuilder result = new StringBuilder(limit);
        result.append(str.substring(0, pos));
        while (pos < limit) {
            char ch2 = str.charAt(pos);
            if (ch2 < '\u0080') {
                result.append(ch2);
            } else {
                result.append("\\u").append(String.format("%04X", ch2));
            }
            ++pos;
        }
        return result.toString();
    }

    @Override
    public void startStream() throws IOException {
        this.sink.startStream();
    }

    @Override
    public void endStream() throws IOException {
        this.sink.endStream();
    }

    @Override
    public void beginDocument(String id) {
    }

    @Override
    public void endDocument(String id) {
    }

    @Override
    public void addNonLiteral(String subj, String pred, String obj) {
        try {
            this.startTriple(subj, pred);
            this.serializeBnodeOrUri(obj);
            this.sink.process(DOT_EOL);
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
    }

    @Override
    public void addPlainLiteral(String subj, String pred, String content, String lang) {
        try {
            this.startTriple(subj, pred);
            this.addContent(content);
            if (lang != null) {
                this.sink.process('@').process(lang);
            }
            this.sink.process(' ').process(DOT_EOL);
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
    }

    @Override
    public void addTypedLiteral(String subj, String pred, String content, String type) {
        try {
            this.startTriple(subj, pred);
            this.addContent(content);
            this.sink.process("^^");
            this.serializeUri(type);
            this.sink.process(DOT_EOL);
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
    }

    @Override
    public void setBaseUri(String baseUri) {
    }

    protected void startTriple(String subj, String pred) throws IOException {
        this.serializeBnodeOrUri(subj);
        this.serializeBnodeOrUri(pred);
    }

    protected void serializeBnodeOrUri(String value) throws IOException {
        if (value.startsWith("_:")) {
            this.sink.process(value).process(' ');
        } else {
            this.serializeUri(value);
        }
    }

    protected void serializeUri(String uri) throws IOException {
        String escapedUri = NTriplesSerializer.escapeUri(uri);
        this.sink.process('<').process(escapedUri).process('>').process(' ');
    }

    protected void addContent(String content) throws IOException {
        String escapedContent = NTriplesSerializer.escapeContent(content);
        this.sink.process('\"').process(escapedContent).process('\"');
    }

    static {
        ESCAPABLE_CONTENT_CHARS.set(92);
        ESCAPABLE_CONTENT_CHARS.set(34);
        ESCAPABLE_CONTENT_CHARS.set(8);
        ESCAPABLE_CONTENT_CHARS.set(12);
        ESCAPABLE_CONTENT_CHARS.set(10);
        ESCAPABLE_CONTENT_CHARS.set(13);
        ESCAPABLE_CONTENT_CHARS.set(9);
        for (int ch = 0; ch <= 32; ch = (int)((char)(ch + 1))) {
            ESCAPABLE_URI_CHARS.set(ch);
        }
        ESCAPABLE_URI_CHARS.set(92);
        ESCAPABLE_URI_CHARS.set(60);
        ESCAPABLE_URI_CHARS.set(62);
        ESCAPABLE_URI_CHARS.set(123);
        ESCAPABLE_URI_CHARS.set(125);
        ESCAPABLE_URI_CHARS.set(34);
        ESCAPABLE_URI_CHARS.set(96);
        ESCAPABLE_URI_CHARS.set(124);
        ESCAPABLE_URI_CHARS.set(94);
    }
}

