/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.rdfxml;

import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.RdfConstants;
import org.xbib.content.rdf.RdfContentGenerator;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.Triple;
import org.xbib.content.rdf.internal.DefaultAnonymousResource;
import org.xbib.content.rdf.internal.DefaultResource;
import org.xbib.content.rdf.io.rdfxml.RdfXmlContentParams;
import org.xbib.content.resource.IRI;
import org.xbib.content.resource.Node;
import org.xbib.content.xml.util.XMLUtil;

public class RdfXmlContentGenerator
implements RdfContentGenerator<RdfXmlContentParams>,
Flushable,
RdfConstants {
    private static final Logger logger = Logger.getLogger(RdfXmlContentGenerator.class.getName());
    private final Writer writer;
    private boolean writingStarted;
    private boolean headerWritten;
    private Resource lastWrittenSubject;
    private Resource resource;
    private RdfXmlContentParams params = RdfXmlContentParams.RDF_XML_CONTENT_PARAMS;

    public RdfXmlContentGenerator(OutputStream out) throws IOException {
        this(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    public RdfXmlContentGenerator(Writer writer) throws IOException {
        this.writer = writer;
        this.resource = new DefaultAnonymousResource();
    }

    @Override
    public void close() throws IOException {
        this.receive(this.resource);
    }

    public RdfXmlContentGenerator receive(IRI iri) throws IOException {
        if (!iri.equals((Object)this.resource.id())) {
            this.receive(this.resource);
            this.resource = new DefaultResource(iri);
        }
        return this;
    }

    @Override
    public RdfContentGenerator<RdfXmlContentParams> setParams(RdfXmlContentParams rdfContentParams) {
        this.params = rdfContentParams;
        return this;
    }

    @Override
    public RdfXmlContentParams getParams() {
        return this.params;
    }

    public RdfXmlContentGenerator startStream() {
        return this;
    }

    @Override
    public RdfContentGenerator<RdfXmlContentParams> setBaseUri(String baseUri) {
        this.startPrefixMapping("", baseUri);
        return this;
    }

    public RdfXmlContentGenerator receive(Triple triple) {
        this.resource.add(triple);
        return this;
    }

    public RdfXmlContentGenerator endStream() {
        return this;
    }

    public RdfXmlContentGenerator startPrefixMapping(String prefix, String uri) {
        this.params.getNamespaceContext().addNamespace(prefix, uri);
        return this;
    }

    public RdfXmlContentGenerator endPrefixMapping(String prefix) {
        return this;
    }

    public RdfXmlContentGenerator receive(Resource resource) throws IOException {
        this.writingStarted = false;
        this.headerWritten = false;
        this.lastWrittenSubject = null;
        for (Map.Entry entry : this.params.getNamespaceContext().getNamespaces().entrySet()) {
            this.handleNamespace((String)entry.getKey(), (String)entry.getValue());
        }
        this.startRDF();
        this.writeHeader();
        resource.triples().forEach(this::writeTriple);
        this.endRDF();
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    private void startRDF() throws IOException {
        if (this.writingStarted) {
            throw new IOException("writing has already started");
        }
        this.writingStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeader() throws IOException {
        try {
            this.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", false);
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
            for (Map.Entry entry : this.params.getNamespaceContext().getNamespaces().entrySet()) {
                String prefix = (String)entry.getKey();
                String name = (String)entry.getValue();
                this.writeNewLine();
                this.writer.write("\t");
                this.writer.write("xmlns");
                if (prefix.length() > 0) {
                    this.writer.write(58);
                    this.writer.write(prefix);
                }
                this.writer.write("=\"");
                this.writer.write(this.escapeDoubleQuotedAttValue(name));
                this.writer.write("\"");
            }
            this.writer.write(">");
            this.writeNewLine();
        }
        finally {
            this.headerWritten = true;
        }
    }

    private void endRDF() throws IOException {
        if (!this.writingStarted) {
            throw new IOException("Document writing has not yet started");
        }
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            this.flushPendingStatements();
            this.writeNewLine();
            this.writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
            this.writer.flush();
        }
        finally {
            this.writingStarted = false;
            this.headerWritten = false;
        }
    }

    private void handleNamespace(String prefix, String name) {
        this.setNamespace(prefix, name, false);
    }

    private void setNamespace(String prefix, String name, boolean fixedPrefix) {
        if (this.headerWritten) {
            return;
        }
        SortedMap map = this.params.getNamespaceContext().getNamespaces();
        if (!map.containsKey(name)) {
            boolean isLegalPrefix;
            String p = prefix;
            boolean bl = isLegalPrefix = p.length() == 0 || XMLUtil.isNCName((CharSequence)p);
            if (!isLegalPrefix || map.containsValue(p)) {
                if (fixedPrefix) {
                    if (isLegalPrefix) {
                        throw new IllegalArgumentException("Prefix is already in use: " + prefix);
                    }
                    throw new IllegalArgumentException("Prefix is not a valid XML namespace prefix: " + prefix);
                }
                if (p.length() == 0 || !isLegalPrefix) {
                    p = "ns";
                }
                int number = 1;
                while (map.containsValue(p + number)) {
                    ++number;
                }
                p = p + Integer.toString(number);
            }
            this.params.getNamespaceContext().addNamespace(p, name);
        }
    }

    private RdfXmlContentGenerator writeTriple(Triple triple) {
        try {
            if (!this.writingStarted) {
                throw new IOException("document writing has not yet been started");
            }
            Resource subj = triple.subject();
            IRI pred = triple.predicate();
            Node obj = triple.object();
            String predString = pred.toString();
            int predSplitIdx = this.findURISplitIndex(predString);
            if (predSplitIdx == -1) {
                throw new IOException("unable to create XML namespace-qualified name for predicate: " + predString);
            }
            String predNamespace = predString.substring(0, predSplitIdx);
            String predLocalName = predString.substring(predSplitIdx);
            if (!this.headerWritten) {
                this.writeHeader();
            }
            if (!subj.equals(this.lastWrittenSubject)) {
                this.flushPendingStatements();
                this.writeNewLine();
                this.writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
                if (subj.isEmbedded()) {
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", subj.toString());
                } else {
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", subj.toString());
                }
                this.writer.write(">");
                this.writeNewLine();
                this.lastWrittenSubject = subj;
            }
            this.writer.write("\t");
            this.writeStartOfStartTag(predNamespace, predLocalName);
            if (obj instanceof Resource) {
                Resource objRes = (Resource)obj;
                if (objRes.isEmbedded()) {
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", objRes.id().toString());
                } else {
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", objRes.id().toString());
                }
                this.writer.write("/>");
            } else if (obj instanceof Literal) {
                Literal l = (Literal)obj;
                if (l.lang() != null) {
                    this.writeAttribute("xml:lang", l.lang());
                }
                boolean isXMLLiteral = false;
                IRI datatype = l.type();
                if (datatype != null) {
                    isXMLLiteral = datatype.equals((Object)RDF_XMLLITERAL);
                    if (isXMLLiteral) {
                        this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", "Literal");
                    } else {
                        this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype", datatype.toString());
                    }
                }
                this.writer.write(">");
                if (isXMLLiteral) {
                    this.writer.write(obj.toString());
                } else {
                    this.writer.write(this.escapeCharacterData(obj.toString()));
                }
                this.writeEndTag(predNamespace, predLocalName);
            }
            this.writeNewLine();
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
        return this;
    }

    private void flushPendingStatements() throws IOException {
        if (this.lastWrittenSubject != null) {
            this.writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
            this.writeNewLine();
            this.lastWrittenSubject = null;
        }
    }

    private void writeStartOfStartTag(String namespace, String localName) throws IOException {
        String prefix = this.params.getNamespaceContext().getPrefix(namespace);
        if (prefix == null) {
            this.writer.write("<");
            this.writer.write(localName);
            this.writer.write(" xmlns=\"");
            this.writer.write(this.escapeDoubleQuotedAttValue(namespace));
            this.writer.write("\"");
        } else if (prefix.length() == 0) {
            this.writer.write("<");
            this.writer.write(localName);
        } else {
            this.writer.write("<");
            this.writer.write(prefix);
            this.writer.write(":");
            this.writer.write(localName);
        }
    }

    private void writeAttribute(String attName, String value) throws IOException {
        this.writer.write(" ");
        this.writer.write(attName);
        this.writer.write("=\"");
        this.writer.write(this.escapeDoubleQuotedAttValue(value));
        this.writer.write("\"");
    }

    private void writeAttribute(String namespace, String attName, String value) throws IOException {
        String prefix = this.params.getNamespaceContext().getPrefix(namespace);
        if (prefix == null || prefix.length() == 0) {
            throw new IOException("No prefix has been declared for the namespace used in this attribute: " + namespace);
        }
        this.writer.write(" ");
        this.writer.write(prefix);
        this.writer.write(":");
        this.writer.write(attName);
        this.writer.write("=\"");
        this.writer.write(this.escapeDoubleQuotedAttValue(value));
        this.writer.write("\"");
    }

    private void writeEndTag(String namespace, String localName) throws IOException {
        String prefix = this.params.getNamespaceContext().getPrefix(namespace);
        if (prefix == null || prefix.length() == 0) {
            this.writer.write("</");
            this.writer.write(localName);
            this.writer.write(">");
        } else {
            this.writer.write("</");
            this.writer.write(prefix);
            this.writer.write(":");
            this.writer.write(localName);
            this.writer.write(">");
        }
    }

    private void writeNewLine() throws IOException {
        this.writer.write("\n");
    }

    private String escapeCharacterData(String value) {
        String s = value;
        s = this.gsub("&", "&amp;", s);
        s = this.gsub("<", "&lt;", s);
        s = this.gsub(">", "&gt;", s);
        s = this.gsub("\r", "&#xD;", s);
        return s;
    }

    private String escapeDoubleQuotedAttValue(String value) {
        String s = value;
        s = this.escapeAttValue(s);
        s = this.gsub("\"", "&quot;", s);
        return s;
    }

    private String escapeAttValue(String value) {
        String s = value;
        s = this.gsub("&", "&amp;", s);
        s = this.gsub("<", "&lt;", s);
        s = this.gsub(">", "&gt;", s);
        s = this.gsub("\t", "&#x9;", s);
        s = this.gsub("\n", "&#xA;", s);
        s = this.gsub("\r", "&#xD;", s);
        return s;
    }

    private String gsub(String olds, String news, String text) {
        if (olds == null || olds.length() == 0) {
            return text;
        }
        if (text == null) {
            return null;
        }
        int oldsIndex = text.indexOf(olds);
        if (oldsIndex == -1) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int prevIndex = 0;
        while (oldsIndex >= 0) {
            buf.append(text.substring(prevIndex, oldsIndex));
            buf.append(news);
            prevIndex = oldsIndex + olds.length();
            oldsIndex = text.indexOf(olds, prevIndex);
        }
        buf.append(text.substring(prevIndex));
        return buf.toString();
    }

    private int findURISplitIndex(String uri) {
        char c;
        int i;
        int uriLength = uri.length();
        for (i = uriLength - 1; i >= 0 && (c = uri.charAt(i)) != '#' && c != '/' && XMLUtil.isNCNameChar((char)c); --i) {
        }
        ++i;
        while (i < uriLength && (c = uri.charAt(i)) != '_' && !XMLUtil.isLetter((char)c)) {
            ++i;
        }
        if (i == uriLength) {
            i = -1;
        }
        return i;
    }
}

