/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.rdfxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.RdfConstants;
import org.xbib.content.rdf.RdfContentBuilder;
import org.xbib.content.rdf.RdfContentBuilderHandler;
import org.xbib.content.rdf.RdfContentBuilderProvider;
import org.xbib.content.rdf.RdfContentParams;
import org.xbib.content.rdf.RdfContentParser;
import org.xbib.content.rdf.RdfContentType;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.StandardRdfContentType;
import org.xbib.content.rdf.Triple;
import org.xbib.content.rdf.internal.DefaultAnonymousResource;
import org.xbib.content.rdf.internal.DefaultLiteral;
import org.xbib.content.rdf.internal.DefaultTriple;
import org.xbib.content.rdf.io.xml.XmlHandler;
import org.xbib.content.resource.IRI;
import org.xbib.content.resource.IRINamespaceContext;
import org.xbib.content.resource.IRISyntaxException;
import org.xbib.content.resource.Node;
import org.xbib.content.xml.util.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class RdfXmlContentParser<R extends RdfContentParams>
implements RdfConstants,
RdfContentParser<R> {
    private static final Logger logger = Logger.getLogger(RdfXmlContentParser.class.getName());
    private final Reader reader;
    private final Resource resource = new DefaultAnonymousResource();
    private XmlHandler<R> xmlHandler = new Handler();
    private RdfContentBuilderProvider<R> provider;
    private RdfContentBuilderHandler<R> rdfContentBuilderHandler;
    private RdfContentBuilder<R> builder;
    private int bn = 0;

    public RdfXmlContentParser(InputStream in) {
        this(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public RdfXmlContentParser(Reader reader) {
        this.reader = reader;
    }

    @Override
    public RdfContentType contentType() {
        return StandardRdfContentType.RDFXML;
    }

    public RdfXmlContentParser<R> setRdfContentBuilderProvider(RdfContentBuilderProvider<R> provider) {
        this.provider = provider;
        return this;
    }

    public RdfXmlContentParser<R> setRdfContentBuilderHandler(RdfContentBuilderHandler<R> rdfContentBuilderHandler) {
        this.rdfContentBuilderHandler = rdfContentBuilderHandler;
        return this;
    }

    @Override
    public RdfXmlContentParser<R> parse() throws IOException {
        try {
            this.parse(new InputSource(this.reader));
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new IOException(ex);
        }
        return this;
    }

    public RdfXmlContentParser<R> parse(InputSource source) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        XMLReader xmlReader = parser.getXMLReader();
        this.parse(xmlReader, source);
        return this;
    }

    public RdfXmlContentParser<R> parse(XMLReader reader, InputSource source) throws IOException, SAXException {
        if (this.provider != null) {
            this.builder = this.provider.newContentBuilder();
            this.builder.startStream();
        }
        if (this.xmlHandler != null) {
            reader.setContentHandler(this.xmlHandler);
        }
        reader.parse(source);
        if (this.builder != null) {
            if (this.rdfContentBuilderHandler != null) {
                this.rdfContentBuilderHandler.build(this.builder);
            }
            this.builder.endStream();
        }
        return this;
    }

    public RdfContentBuilder<R> getBuilder() {
        return this.builder;
    }

    public XmlHandler<R> getHandler() {
        return this.xmlHandler;
    }

    public RdfXmlContentParser<R> setHandler(XmlHandler<R> handler) {
        this.xmlHandler = handler;
        return this;
    }

    private String getLanguage(Deque<Frame> stack) {
        String lang = "";
        Iterator<Frame> it = stack.descendingIterator();
        while (it.hasNext()) {
            Frame frame = it.next();
            if (frame.lang == null || lang.startsWith(frame.lang)) continue;
            lang = frame.lang;
        }
        return lang;
    }

    private String getBase(Deque<Frame> stack) {
        String base = "";
        Iterator<Frame> it = stack.descendingIterator();
        while (it.hasNext()) {
            Frame frame = it.next();
            if (frame.base == null) continue;
            base = frame.base;
        }
        return base;
    }

    private boolean inPredicate(Deque<Frame> stack) {
        boolean ip = false;
        Iterator<Frame> it = stack.descendingIterator();
        while (it.hasNext()) {
            Frame frame = it.next();
            ip = frame.isPredicate;
        }
        return ip;
    }

    private Frame parentPredicateFrame(Deque<Frame> stack) throws SAXException {
        if (this.inPredicate(stack)) {
            Frame predicateFrame = null;
            Iterator<Frame> it = stack.descendingIterator();
            while (it.hasNext()) {
                Frame frame = it.next();
                if (!frame.isPredicate) continue;
                predicateFrame = frame;
            }
            return predicateFrame;
        }
        throw new SAXException("internal parser error: cannot find enclosing predicate");
    }

    private IRI parentPredicate(Deque<Frame> stack) throws SAXException {
        Frame ppFrame = this.parentPredicateFrame(stack);
        return ppFrame != null ? ppFrame.node : null;
    }

    private Frame ancestorSubjectFrame(Deque<Frame> stack) throws SAXException {
        Frame subjectFrame = null;
        Iterator<Frame> it = stack.descendingIterator();
        while (it.hasNext()) {
            Frame frame = it.next();
            if (!frame.isSubject) continue;
            subjectFrame = frame;
        }
        return subjectFrame;
    }

    private IRI ancestorSubject(Deque<Frame> stack) throws SAXException {
        Frame subjectFrame = this.ancestorSubjectFrame(stack);
        return subjectFrame != null ? subjectFrame.node : null;
    }

    private Resource blankNode() {
        return new DefaultAnonymousResource("b" + this.bn++);
    }

    private Resource blankNode(String s) {
        return new DefaultAnonymousResource(s);
    }

    private IRI resolve(String uriString, Deque<Frame> stack) {
        IRI uri;
        try {
            uri = IRI.create((String)uriString);
        }
        catch (IRISyntaxException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            uri = IRI.create((String)uriString.replace(" ", "%20").replace("\"", "%22").replace("[", "%5B").replace("]", "%5D").replace("<", "%3C").replace(">", "%3E").replace("|", "%7C").replace("`", "%60").replace("\u0098", "").replace("\u009c", ""));
        }
        if (uri.isAbsolute()) {
            return uri;
        }
        return IRI.create((String)(this.getBase(stack) + uriString));
    }

    private void getSubjectNode(Frame frame, Deque<Frame> stack, Attributes attrs) throws SAXException {
        String rdfId;
        String nodeId;
        String about = attrs.getValue(RDF_STRING, "about");
        if (about != null) {
            frame.node = this.resolve(about, stack);
            if (this.provider != null) {
                try {
                    if (this.rdfContentBuilderHandler != null) {
                        this.rdfContentBuilderHandler.build(this.builder);
                    }
                    this.builder = this.provider.newContentBuilder();
                    this.builder.receive(frame.node);
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
        }
        if ((nodeId = attrs.getValue(RDF_STRING, "nodeID")) != null) {
            if (frame.node != null) {
                throw new SAXException("ambiguous use of rdf:nodeID");
            }
            frame.node = this.blankNode(nodeId).id();
        }
        if ((rdfId = attrs.getValue(RDF_STRING, "ID")) != null) {
            if (frame.node != null) {
                throw new SAXException("ambiguous use of rdf:ID");
            }
            frame.node = IRI.create((String)(this.getBase(stack) + "#" + rdfId));
        }
        if (frame.node == null) {
            frame.node = this.blankNode().id();
        }
        frame.isSubject = true;
    }

    private IRI getObjectNode(Deque<Frame> stack, Attributes attrs) throws SAXException {
        String nodeId;
        IRI node = null;
        String resource = attrs.getValue(RDF_STRING, "resource");
        if (resource != null) {
            node = this.resolve(resource, stack);
        }
        if ((nodeId = attrs.getValue(RDF_STRING, "nodeID")) != null) {
            if (node != null) {
                throw new SAXException("ambiguous use of rdf:nodeID");
            }
            node = this.blankNode(nodeId).id();
        }
        return node;
    }

    private void xmlLiteralStart(StringBuilder out, String ns, String qn, Attributes attrs) {
        String aQn;
        out.append("<").append(qn);
        HashMap<String, String> pfxMap = new HashMap<String, String>();
        for (int i = -1; i < attrs.getLength(); ++i) {
            String aNs;
            if (i < 0) {
                aQn = qn;
                aNs = ns;
            } else {
                aQn = attrs.getQName(i);
                aNs = attrs.getURI(i);
            }
            if ("".equals(aNs)) continue;
            String pfx = aQn.replaceFirst(":.*", "");
            pfxMap.put(pfx, aNs);
        }
        for (Map.Entry pfxMapping : pfxMap.entrySet()) {
            out.append(" xmlns:").append((String)pfxMapping.getKey()).append("=\"").append((String)pfxMapping.getValue()).append("\"");
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            aQn = attrs.getQName(i);
            String aVal = attrs.getValue(i);
            out.append(" ").append(aQn).append("=\"").append(XMLUtil.escape((CharSequence)aVal)).append("\"");
        }
        out.append(">");
    }

    private void xmlLiteralEnd(StringBuilder out, String qn) {
        out.append("</").append(qn).append(">");
    }

    private Literal withLanguageTag(Literal l, Deque<Frame> stack) {
        String lang = this.getLanguage(stack);
        if (!"".equals(lang)) {
            l.lang(lang);
        }
        return l;
    }

    protected void yield(Triple triple) throws IOException {
        if (this.builder != null) {
            this.builder.receive(triple);
        }
    }

    private void yield(Object s, Object p, Object o) throws IOException {
        this.yield(new DefaultTriple(this.resource.newSubject(s), this.resource.newPredicate(p), this.resource.newObject(o)));
    }

    private void yield(Object s, IRI p, Object o, IRI reified) throws IOException {
        this.yield(s, p, o);
        if (reified != null) {
            this.yield(reified, RDF_TYPE, RDF_STATEMENT);
            this.yield(reified, RDF_SUBJECT, s);
            this.yield(reified, RDF_PREDICATE, p);
            this.yield(reified, RDF_OBJECT, o);
        }
    }

    private class Handler
    extends DefaultHandler
    implements XmlHandler<R> {
        private final Deque<Frame> stack = new ArrayDeque<Frame>();
        private StringBuilder pcdata = null;
        private StringBuilder xmlLiteral = null;
        private IRINamespaceContext namespaceContext;
        private int literalLevel = 0;

        private Handler() {
        }

        @Override
        public XmlHandler<R> setNamespaceContext(IRINamespaceContext namespaceContext) {
            this.namespaceContext = namespaceContext;
            return this;
        }

        @Override
        public IRINamespaceContext getNamespaceContext() {
            return this.namespaceContext;
        }

        public Handler setDefaultNamespace(String prefix, String namespaceURI) {
            return this;
        }

        @Override
        public XmlHandler<R> setBuilder(RdfContentBuilder<R> builder) {
            return this;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (RdfXmlContentParser.this.builder != null) {
                RdfXmlContentParser.this.builder.startPrefixMapping(prefix, uri);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            if (RdfXmlContentParser.this.builder != null) {
                RdfXmlContentParser.this.builder.endPrefixMapping(prefix);
            }
        }

        @Override
        public void startElement(String ns, String name, String qn, Attributes attrs) throws SAXException {
            try {
                if (this.literalLevel > 0) {
                    ++this.literalLevel;
                    RdfXmlContentParser.this.xmlLiteralStart(this.xmlLiteral, ns, qn, attrs);
                } else {
                    Frame frame = new Frame();
                    IRI iri = IRI.create((String)(ns + name));
                    frame.lang = attrs.getValue("xml:lang");
                    frame.base = attrs.getValue("xml:base");
                    if (this.expectSubject(this.stack)) {
                        if (!iri.equals((Object)RdfConstants.RDF_RDF)) {
                            RdfXmlContentParser.this.getSubjectNode(frame, this.stack, attrs);
                            if (!iri.equals((Object)RdfConstants.RDF_DESCRIPTION)) {
                                RdfXmlContentParser.this.yield(frame.node, RdfConstants.RDF_TYPE, iri);
                            }
                            for (int i = 0; i < attrs.getLength(); ++i) {
                                String aQn = attrs.getQName(i);
                                String aUri = attrs.getURI(i) + attrs.getLocalName(i);
                                String aVal = attrs.getValue(i);
                                if (aUri.startsWith(RdfConstants.RDF_STRING) || aQn.startsWith("xml:")) continue;
                                RdfXmlContentParser.this.yield(frame.node, IRI.create((String)aUri), aVal);
                            }
                            if (RdfXmlContentParser.this.inPredicate(this.stack)) {
                                if (this.isCollectionItem(this.stack)) {
                                    Frame ppFrame = RdfXmlContentParser.this.parentPredicateFrame(this.stack);
                                    ppFrame.collection.add(frame.node);
                                } else {
                                    RdfXmlContentParser.this.yield(RdfXmlContentParser.this.ancestorSubject(this.stack), RdfXmlContentParser.this.parentPredicate(this.stack), frame.node);
                                }
                            }
                        }
                        this.pcdata = null;
                    } else {
                        IRI object;
                        frame.node = iri;
                        frame.isPredicate = true;
                        String reification = attrs.getValue(RdfConstants.RDF_STRING, "ID");
                        if (reification != null) {
                            frame.reification = IRI.create((String)(RdfXmlContentParser.this.getBase(this.stack) + "#" + reification));
                        }
                        if (iri.equals((Object)RdfConstants.RDF_LI)) {
                            Frame asf = RdfXmlContentParser.this.ancestorSubjectFrame(this.stack);
                            frame.node = IRI.create((String)(RdfConstants.RDF + "_" + asf.li));
                            ++asf.li;
                        }
                        if ((object = RdfXmlContentParser.this.getObjectNode(this.stack, attrs)) != null) {
                            RdfXmlContentParser.this.yield(RdfXmlContentParser.this.ancestorSubject(this.stack), frame.node, object, frame.reification);
                        } else {
                            this.pcdata = new StringBuilder();
                        }
                        String parseType = attrs.getValue(RdfConstants.RDF_STRING, "parseType");
                        if (parseType != null) {
                            switch (parseType) {
                                case "Resource": {
                                    object = object == null ? RdfXmlContentParser.this.blankNode().id() : object;
                                    RdfXmlContentParser.this.yield(RdfXmlContentParser.this.ancestorSubject(this.stack), frame.node, object, frame.reification);
                                    frame.node = object;
                                    frame.isSubject = true;
                                    break;
                                }
                                case "Collection": {
                                    frame.isCollection = true;
                                    frame.collection = new LinkedList<IRI>();
                                    Resource s = RdfXmlContentParser.this.resource.newSubject(RdfXmlContentParser.this.ancestorSubject(this.stack));
                                    IRI p = RdfXmlContentParser.this.resource.newPredicate(frame.node);
                                    Node o = RdfXmlContentParser.this.resource.newObject(RdfXmlContentParser.this.blankNode());
                                    frame.collectionHead = new DefaultTriple(s, p, o);
                                    this.pcdata = null;
                                    break;
                                }
                                case "Literal": {
                                    this.literalLevel = 1;
                                    this.xmlLiteral = new StringBuilder();
                                    this.pcdata = null;
                                    break;
                                }
                                default: {
                                    frame.datatype = attrs.getValue(RdfConstants.RDF_STRING, "datatype");
                                }
                            }
                        }
                        object = null;
                        for (int i = 0; i < attrs.getLength(); ++i) {
                            String aQn = attrs.getQName(i);
                            IRI aUri = IRI.create((String)(attrs.getURI(i) + attrs.getLocalName(i)));
                            String aVal = attrs.getValue(i);
                            if (!aUri.toString().equals(RdfConstants.RDF_TYPE.toString()) && aUri.toString().startsWith(RdfConstants.RDF_STRING) || aQn.startsWith("xml:")) continue;
                            if (object == null) {
                                object = RdfXmlContentParser.this.blankNode().id();
                                RdfXmlContentParser.this.yield(RdfXmlContentParser.this.ancestorSubject(this.stack), frame.node, object);
                            }
                            if (aUri.equals((Object)RdfConstants.RDF_TYPE)) {
                                RdfXmlContentParser.this.yield(object, RdfConstants.RDF_TYPE, aVal);
                                continue;
                            }
                            Literal value = RdfXmlContentParser.this.withLanguageTag(new DefaultLiteral(aVal), this.stack);
                            RdfXmlContentParser.this.yield(object, aUri, value);
                        }
                        if (object != null) {
                            this.pcdata = null;
                        }
                    }
                    this.stack.push(frame);
                }
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public void endElement(String ns, String name, String qn) throws SAXException {
            try {
                if (this.literalLevel > 0) {
                    --this.literalLevel;
                    if (this.literalLevel > 0) {
                        RdfXmlContentParser.this.xmlLiteralEnd(this.xmlLiteral, qn);
                    }
                } else {
                    if (RdfXmlContentParser.this.inPredicate(this.stack)) {
                        Frame ppFrame = RdfXmlContentParser.this.parentPredicateFrame(this.stack);
                        if (this.xmlLiteral != null) {
                            DefaultLiteral value = new DefaultLiteral(this.xmlLiteral.toString()).type(RdfConstants.RDF_XMLLITERAL);
                            RdfXmlContentParser.this.yield(RdfXmlContentParser.this.ancestorSubject(this.stack), RdfXmlContentParser.this.parentPredicate(this.stack), value);
                            this.xmlLiteral = null;
                        } else if (this.pcdata != null) {
                            IRI u = ppFrame.datatype == null ? null : IRI.create((String)ppFrame.datatype);
                            Literal value = RdfXmlContentParser.this.withLanguageTag(new DefaultLiteral(this.pcdata.toString()).type(u), this.stack);
                            IRI reification = ppFrame.reification;
                            RdfXmlContentParser.this.yield(RdfXmlContentParser.this.ancestorSubject(this.stack), ppFrame.node, value, reification);
                            this.pcdata = null;
                        } else if (ppFrame.isCollection) {
                            if (ppFrame.collection.isEmpty()) {
                                RdfXmlContentParser.this.yield(ppFrame.collectionHead.subject(), ppFrame.collectionHead.predicate(), RdfXmlContentParser.this.resource.newObject(RdfConstants.RDF_NIL));
                            } else {
                                RdfXmlContentParser.this.yield(ppFrame.collectionHead);
                                Node prevNode = null;
                                Node node = ppFrame.collectionHead.object();
                                for (IRI item : ppFrame.collection) {
                                    if (prevNode != null) {
                                        RdfXmlContentParser.this.yield(prevNode, RdfConstants.RDF_REST, node);
                                    }
                                    RdfXmlContentParser.this.yield(node, RdfConstants.RDF_FIRST, item);
                                    prevNode = node;
                                    node = RdfXmlContentParser.this.blankNode().id();
                                }
                                RdfXmlContentParser.this.yield(prevNode, RdfConstants.RDF_REST, RdfConstants.RDF_NIL);
                            }
                        }
                    }
                    this.stack.pop();
                }
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public void characters(char[] chars, int start, int len) throws SAXException {
            if (this.literalLevel > 0) {
                XMLUtil.escape((StringBuilder)this.xmlLiteral, (char[])chars, (int)start, (int)len);
            } else if (this.pcdata != null) {
                for (int i = start; i < start + len; ++i) {
                    this.pcdata.append(chars[i]);
                }
            }
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            if (this.literalLevel > 0) {
                this.xmlLiteral.append("<?").append(target).append(" ").append(data).append("?>");
            }
        }

        private boolean expectSubject(Deque<Frame> stack) {
            boolean b = true;
            Iterator<Frame> it = stack.descendingIterator();
            while (it.hasNext()) {
                Frame frame = it.next();
                b = !frame.isSubject;
            }
            return b;
        }

        private boolean isCollectionItem(Deque<Frame> stack) throws SAXException {
            if (RdfXmlContentParser.this.inPredicate(stack)) {
                Frame predicateFrame = RdfXmlContentParser.this.parentPredicateFrame(stack);
                return predicateFrame != null && predicateFrame.isCollection;
            }
            return false;
        }
    }

    private static class Frame {
        IRI node = null;
        String lang = null;
        String base = null;
        String datatype = null;
        IRI reification = null;
        List<IRI> collection = null;
        Triple collectionHead = null;
        boolean isSubject = false;
        boolean isPredicate = false;
        boolean isCollection = false;
        int li = 1;

        private Frame() {
        }
    }
}

