/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.sink;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.xbib.content.rdf.io.sink.CharSink;

public final class CharOutputSink
implements CharSink {
    private static final short BATCH_SIZE = 256;
    private final Charset charset;
    private Writer writer;
    private OutputStream outputStream;
    private boolean closeOnEndStream;
    private StringBuilder buffer;
    private short bufferSize;

    public CharOutputSink() {
        this(Charset.defaultCharset());
    }

    public CharOutputSink(Charset charset) {
        this.charset = charset;
    }

    public void connect(Writer writer) {
        this.writer = writer;
        this.outputStream = null;
        this.closeOnEndStream = false;
    }

    public void connect(OutputStream outputStream) {
        this.writer = null;
        this.outputStream = outputStream;
        this.closeOnEndStream = false;
    }

    @Override
    public CharOutputSink process(String str) throws IOException {
        this.buffer.append(str);
        this.bufferSize = (short)(this.bufferSize + str.length());
        this.writeBuffer();
        return this;
    }

    @Override
    public CharOutputSink process(char ch) throws IOException {
        this.buffer.append(ch);
        this.bufferSize = (short)(this.bufferSize + 1);
        this.writeBuffer();
        return this;
    }

    @Override
    public CharOutputSink process(char[] buffer, int start, int count) throws IOException {
        this.buffer.append(buffer, start, count);
        this.bufferSize = (short)(this.bufferSize + count);
        this.writeBuffer();
        return this;
    }

    private void writeBuffer() throws IOException {
        if (this.bufferSize >= 256) {
            this.writer.write(this.buffer.toString());
            this.buffer = new StringBuilder(256);
            this.bufferSize = 0;
        }
    }

    @Override
    public void setBaseUri(String baseUri) {
    }

    @Override
    public void startStream() throws IOException {
        this.buffer = new StringBuilder();
        this.bufferSize = 0;
        if (this.writer == null) {
            this.writer = new OutputStreamWriter(this.outputStream, this.charset);
        }
    }

    @Override
    public void endStream() throws IOException {
        this.buffer.append("\n");
        this.bufferSize = (short)256;
        this.writeBuffer();
        this.writer.flush();
        if (this.closeOnEndStream) {
            this.writer.close();
            this.writer = null;
        } else if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
    }

    @Override
    public void beginDocument(String id) throws IOException {
    }

    @Override
    public void endDocument(String id) throws IOException {
    }
}

