/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.sink;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.rdf.RdfContentBuilder;
import org.xbib.content.rdf.RdfContentBuilderProvider;
import org.xbib.content.rdf.RdfGraph;
import org.xbib.content.rdf.RdfGraphParams;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.internal.DefaultLiteral;
import org.xbib.content.rdf.internal.DefaultResource;
import org.xbib.content.rdf.internal.DefaultTriple;
import org.xbib.content.rdf.io.sink.QuadSink;
import org.xbib.content.resource.IRI;

public class RdfContentBuilderSink
implements QuadSink {
    private static final Logger logger = Logger.getLogger(RdfContentBuilderSink.class.getName());
    private final RdfGraph<RdfGraphParams> graph;
    private final RdfContentBuilderProvider<RdfGraphParams> provider;

    public RdfContentBuilderSink(RdfGraph<RdfGraphParams> graph, RdfContentBuilderProvider<RdfGraphParams> provider) {
        this.graph = graph;
        this.provider = provider;
    }

    @Override
    public void addNonLiteral(String subj, String pred, String obj) {
        try {
            Resource s = DefaultResource.create(((RdfGraphParams)this.graph.getParams()).getNamespaceContext(), subj);
            IRI p = IRI.create((String)pred);
            Resource o = DefaultResource.create(((RdfGraphParams)this.graph.getParams()).getNamespaceContext(), obj);
            DefaultTriple t = new DefaultTriple(s, p, o);
            this.graph.receive(t);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void addNonLiteral(String subj, String pred, String obj, String graphIRI) {
        try {
            Resource s = DefaultResource.create(((RdfGraphParams)this.graph.getParams()).getNamespaceContext(), subj);
            IRI p = IRI.create((String)pred);
            Resource o = DefaultResource.create(((RdfGraphParams)this.graph.getParams()).getNamespaceContext(), obj);
            DefaultTriple t = new DefaultTriple(s, p, o);
            this.graph.receive(t);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void addPlainLiteral(String subj, String pred, String content, String lang) {
        try {
            Resource s = DefaultResource.create(((RdfGraphParams)this.graph.getParams()).getNamespaceContext(), subj);
            IRI p = IRI.create((String)pred);
            DefaultLiteral o = new DefaultLiteral(content).lang(lang);
            DefaultTriple t = new DefaultTriple(s, p, o);
            this.graph.receive(t);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void addPlainLiteral(String subj, String pred, String content, String lang, String graphIRI) {
        try {
            Resource s = DefaultResource.create(((RdfGraphParams)this.graph.getParams()).getNamespaceContext(), subj);
            IRI p = IRI.create((String)pred);
            DefaultLiteral o = new DefaultLiteral(content).lang(lang);
            DefaultTriple t = new DefaultTriple(s, p, o);
            this.graph.receive(t);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void addTypedLiteral(String subj, String pred, String content, String type) {
        try {
            Resource s = DefaultResource.create(((RdfGraphParams)this.graph.getParams()).getNamespaceContext(), subj);
            IRI p = IRI.create((String)pred);
            DefaultLiteral o = new DefaultLiteral(content).type(IRI.create((String)type));
            DefaultTriple t = new DefaultTriple(s, p, o);
            this.graph.receive(t);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void addTypedLiteral(String subj, String pred, String content, String type, String graphIRI) {
        try {
            Resource s = DefaultResource.create(((RdfGraphParams)this.graph.getParams()).getNamespaceContext(), subj);
            IRI p = IRI.create((String)pred);
            DefaultLiteral o = new DefaultLiteral(content).type(IRI.create((String)type));
            DefaultTriple t = new DefaultTriple(s, p, o);
            this.graph.receive(t);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void setBaseUri(String baseUri) {
    }

    @Override
    public void startStream() throws IOException {
    }

    @Override
    public void endStream() throws IOException {
        if (this.graph.getResources() != null) {
            if (this.provider != null) {
                this.graph.getResources().forEachRemaining(resource -> {
                    try {
                        RdfContentBuilder<RdfGraphParams> rdfContentBuilder = this.provider.newContentBuilder();
                        rdfContentBuilder.startStream();
                        rdfContentBuilder.receive((Resource)resource);
                        rdfContentBuilder.endStream();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                });
            } else {
                logger.log(Level.WARNING, "no RDF content builder provider");
            }
        } else {
            logger.log(Level.WARNING, "no graph resources");
        }
    }

    @Override
    public void beginDocument(String id) throws IOException {
        IRI iri = ((RdfGraphParams)this.graph.getParams()).getNamespaceContext().expandIRI(id);
        this.graph.receive(iri);
    }

    @Override
    public void endDocument(String id) {
    }
}

