/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;

public abstract class BaseStreamProcessor {
    protected abstract void startStream() throws IOException;

    protected abstract void endStream() throws IOException;

    protected abstract void processInternal(Reader var1, String var2, String var3) throws IOException;

    protected abstract void processInternal(InputStream var1, String var2, String var3) throws IOException;

    public final void process(String uri) throws IOException {
        this.process(uri, uri);
    }

    public final void process(String uri, String baseUri) throws IOException {
        URL url = new URL(uri);
        URLConnection urlConnection = url.openConnection();
        String mimeType = urlConnection.getContentType();
        try (InputStream inputStream = urlConnection.getInputStream();){
            this.process(inputStream, mimeType, baseUri);
        }
    }

    public void process(InputStream inputStream) throws IOException {
        this.process(inputStream, null, null);
    }

    public void process(InputStream inputStream, String baseUri) throws IOException {
        this.process(inputStream, null, baseUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(InputStream inputStream, String mimeType, String baseUri) throws IOException {
        this.startStream();
        try {
            this.processInternal(inputStream, mimeType, baseUri);
        }
        finally {
            this.endStream();
        }
    }

    public void process(Reader reader) throws IOException {
        this.process(reader, null, null);
    }

    public void process(Reader reader, String baseUri) throws IOException {
        this.process(reader, null, baseUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(Reader reader, String mimeType, String baseUri) throws IOException {
        this.startStream();
        try {
            this.processInternal(reader, mimeType, baseUri);
        }
        finally {
            this.endStream();
        }
    }
}

