/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.xbib.content.rdf.io.sink.CharSink;
import org.xbib.content.rdf.io.source.AbstractSource;

public final class CharSource
extends AbstractSource<CharSink> {
    CharSource(CharSink sink) {
        super(sink);
    }

    @Override
    public void process(Reader reader, String mimeType, String baseUri) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            int read;
            ((CharSink)this.sink).setBaseUri(baseUri);
            char[] buffer = new char[1024];
            while ((read = bufferedReader.read(buffer)) != -1) {
                ((CharSink)this.sink).process(buffer, 0, read);
            }
        }
    }

    @Override
    public void process(InputStream inputStream, String mimeType, String baseUri) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));){
            this.process(reader, mimeType, baseUri);
        }
    }
}

