/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import org.xbib.content.rdf.io.sink.CharSink;
import org.xbib.content.rdf.io.sink.Sink;
import org.xbib.content.rdf.io.sink.XmlSink;
import org.xbib.content.rdf.io.source.AbstractSource;
import org.xbib.content.rdf.io.source.BaseStreamProcessor;
import org.xbib.content.rdf.io.source.CharSource;
import org.xbib.content.rdf.io.source.XmlSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class StreamProcessor<S extends Sink>
extends BaseStreamProcessor {
    private final Sink sink;
    private final AbstractSource<S> source;

    public StreamProcessor(CharSink sink) {
        this.sink = sink;
        this.source = new CharSource(sink);
    }

    public StreamProcessor(XmlSink sink) {
        this.sink = sink;
        this.source = new XmlSource(sink);
    }

    @Override
    public void processInternal(InputStream inputStream, String mimeType, String baseUri) throws IOException {
        this.source.process(inputStream, mimeType, baseUri);
    }

    @Override
    protected void startStream() throws IOException {
        this.sink.startStream();
    }

    @Override
    protected void endStream() throws IOException {
        this.sink.endStream();
    }

    @Override
    public void processInternal(Reader reader, String mimeType, String baseUri) throws IOException {
        this.source.process(reader, mimeType, baseUri);
    }

    public void setReader(XMLReader xmlReader) throws SAXException, ParserConfigurationException {
        ((XmlSource)this.source).setXmlReader(xmlReader);
    }
}

