/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xbib.content.rdf.io.sink.XmlSink;
import org.xbib.content.rdf.io.source.AbstractSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

final class XmlSource
extends AbstractSource<XmlSink> {
    private XMLReader xmlReader = null;

    XmlSource(XmlSink sink) {
        super(sink);
    }

    public static XMLReader getDefaultXmlReader() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        return parser.getXMLReader();
    }

    @Override
    public void process(Reader reader, String mimeType, String baseUri) throws IOException {
        try {
            this.initXmlReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("can not instantinate XMLReader", e);
        }
        try {
            ((XmlSink)this.sink).setBaseUri(baseUri);
            this.xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException e) {
            try {
                ((XmlSink)this.sink).endDocument();
            }
            catch (SAXException e2) {
                throw new IOException(e2);
            }
            throw new IOException(e);
        }
    }

    @Override
    public void process(InputStream inputStream, String mimeType, String baseUri) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));){
            this.process(reader, mimeType, baseUri);
        }
    }

    private void initXmlReader() throws SAXException, ParserConfigurationException {
        if (this.xmlReader == null) {
            this.xmlReader = XmlSource.getDefaultXmlReader();
        }
        this.xmlReader.setContentHandler((ContentHandler)((Object)this.sink));
        this.xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", this.sink);
    }

    public void setXmlReader(XMLReader xmlReader) throws SAXException, ParserConfigurationException {
        this.xmlReader = xmlReader == null ? XmlSource.getDefaultXmlReader() : xmlReader;
    }
}

