/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.turtle;

import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.RdfContentGenerator;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.Triple;
import org.xbib.content.rdf.internal.DefaultAnonymousResource;
import org.xbib.content.rdf.internal.DefaultResource;
import org.xbib.content.rdf.io.turtle.TurtleContentParams;
import org.xbib.content.resource.IRI;
import org.xbib.content.resource.Node;

public class TurtleContentGenerator
implements RdfContentGenerator<TurtleContentParams>,
Flushable {
    private static final Logger logger = Logger.getLogger(TurtleContentGenerator.class.getName());
    private static final char LF = '\n';
    private static final char TAB = '\t';
    private static final String TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    private final Writer writer;
    private boolean sameResource;
    private boolean sameProperty;
    private Resource lastSubject;
    private IRI lastPredicate;
    private Node lastObject;
    private LinkedList<Resource> embedded;
    private LinkedList<Triple> triples;
    private Triple triple;
    private boolean nsWritten;
    private StringBuilder sb;
    private Resource resource;
    private boolean closed;
    private TurtleContentParams params = TurtleContentParams.TURTLE_CONTENT_PARAMS;

    TurtleContentGenerator(OutputStream out) throws IOException {
        this(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    TurtleContentGenerator(Writer writer) throws IOException {
        this.writer = writer;
        this.resource = new DefaultAnonymousResource();
        this.nsWritten = false;
        this.sameResource = false;
        this.sameProperty = false;
        this.triples = new LinkedList();
        this.embedded = new LinkedList();
        this.sb = new StringBuilder();
    }

    @Override
    public TurtleContentParams getParams() {
        return this.params;
    }

    public TurtleContentGenerator setParams(TurtleContentParams params) {
        this.params = params;
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (!this.resource.isEmpty()) {
                this.receive(this.resource);
            }
            this.writer.close();
            this.closed = true;
        }
    }

    public TurtleContentGenerator receive(IRI iri) throws IOException {
        if (iri != null && !iri.equals((Object)this.resource.id())) {
            this.receive(this.resource);
            this.resource = new DefaultResource(iri);
        }
        return this;
    }

    public TurtleContentGenerator endStream() {
        return this;
    }

    @Override
    public RdfContentGenerator<TurtleContentParams> receive(Resource resource) throws IOException {
        resource.triples().forEach(t -> {
            try {
                this.writeTriple((Triple)t);
            }
            catch (IOException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
        });
        while (!this.embedded.isEmpty()) {
            this.closeEmbeddedResource();
        }
        if (this.sb.length() > 0) {
            this.sb.append('.').append('\n');
        }
        if (this.getParams().isWriteNamespaceContext() && !this.nsWritten) {
            this.writeNamespaces();
        }
        this.writer.write(this.sb.toString());
        this.sb.setLength(0);
        return this;
    }

    public TurtleContentGenerator receive(Triple triple) {
        this.resource.add(triple);
        return this;
    }

    public TurtleContentGenerator startStream() {
        return this;
    }

    @Override
    public RdfContentGenerator<TurtleContentParams> setBaseUri(String baseUri) {
        this.startPrefixMapping("", baseUri);
        return this;
    }

    public TurtleContentGenerator startPrefixMapping(String prefix, String uri) {
        if (prefix == null || prefix.isEmpty() || "http://www.w3.org/2001/XMLSchema-instance".equals(uri)) {
            return this;
        }
        this.getParams().getNamespaceContext().addNamespace(prefix, uri);
        return this;
    }

    public TurtleContentGenerator endPrefixMapping(String prefix) {
        return this;
    }

    private TurtleContentGenerator writeNamespaces() throws IOException {
        this.nsWritten = false;
        for (Map.Entry entry : this.getParams().getNamespaceContext().getNamespaces().entrySet()) {
            String nsURI;
            if (((String)entry.getValue()).length() <= 0 || "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(nsURI = (String)entry.getValue())) continue;
            this.writer.write("@prefix " + (String)entry.getKey() + ": <" + this.encodeURIString(nsURI) + "> ." + '\n');
            this.nsWritten = true;
        }
        if (this.nsWritten) {
            this.writer.write(10);
        }
        return this;
    }

    private void writeTriple(Triple stmt) throws IOException {
        this.triple = stmt;
        Resource subject = stmt.subject();
        IRI predicate = stmt.predicate();
        Node object = stmt.object();
        if (subject == null || predicate == null) {
            return;
        }
        boolean sameSubject = subject.equals(this.lastSubject);
        boolean samePredicate = predicate.equals((Object)this.lastPredicate);
        if (sameSubject) {
            if (samePredicate) {
                this.sb.append(", ");
                this.writeObject(object);
            } else {
                if (!(this.lastObject instanceof Resource) || !((Resource)this.lastObject).isEmbedded()) {
                    this.sb.append(';').append('\n');
                    this.writeIndent(1);
                }
                this.writeIndent(this.embedded.size());
                this.writePredicate(predicate);
                this.writeObject(object);
            }
        } else {
            boolean closeEmbedded;
            Resource r = this.embedded.isEmpty() ? null : this.embedded.peek();
            boolean bl = closeEmbedded = this.lastSubject != null && this.lastSubject.isEmbedded() && !subject.equals(r);
            if (closeEmbedded) {
                Resource tmp = this.closeEmbeddedResource();
                while (tmp != null && !this.embedded.isEmpty() && !this.embedded.peek().equals(subject)) {
                    tmp = this.closeEmbeddedResource();
                }
            }
            if (this.lastSubject != null) {
                if (this.sameResource) {
                    if (this.sameProperty) {
                        this.sb.append(',');
                    } else {
                        this.sb.append(';').append('\n');
                        this.writeIndent(this.embedded.size() + 1);
                    }
                } else {
                    if (this.sameProperty || closeEmbedded) {
                        this.sb.append(";").append('\n');
                        this.writeIndent(1);
                    }
                    this.writeIndent(this.embedded.size());
                }
            }
            if (!this.sameResource) {
                this.writeSubject(subject);
            }
            if (!this.sameProperty) {
                this.writePredicate(predicate);
            }
            this.writeObject(object);
        }
    }

    private void writeSubject(Resource subject) throws IOException {
        if (subject.id() == null) {
            this.sb.append("<> ");
            return;
        }
        if (!subject.isEmbedded()) {
            this.sb.append('<').append(subject.toString()).append("> ");
        }
        this.lastSubject = subject;
    }

    private void writePredicate(IRI predicate) throws IOException {
        if (predicate == null) {
            this.sb.append("<> ");
            return;
        }
        String p = predicate.toString();
        if ("rdf:type".equals(p) || TYPE.equals(p)) {
            this.sb.append("a ");
        } else {
            this.writeURI(predicate);
            this.sb.append(" ");
        }
        this.lastPredicate = predicate;
    }

    private void writeObject(Node object) throws IOException {
        if (object instanceof Resource) {
            Resource r = (Resource)object;
            if (r.isEmbedded()) {
                this.openEmbeddedResource(r);
                this.sameResource = false;
                this.sameProperty = false;
            } else {
                this.writeURI(r.id());
            }
        } else if (object instanceof Literal) {
            this.writeLiteral((Literal)object);
        } else {
            throw new IllegalArgumentException("unknown value class: " + (object != null ? object.getClass() : "<null>"));
        }
        this.lastObject = object;
    }

    private void openEmbeddedResource(Resource r) throws IOException {
        this.triples.push(this.triple);
        this.embedded.push(r);
        this.sb.append('[').append('\n');
        this.writeIndent(1);
    }

    private Resource closeEmbeddedResource() throws IOException {
        if (this.embedded.isEmpty()) {
            return null;
        }
        this.sb.append('\n');
        this.writeIndent(this.embedded.size());
        this.sb.append(']');
        Triple t = this.triples.pop();
        this.lastSubject = t.subject();
        this.lastPredicate = t.predicate();
        this.sameResource = this.lastSubject.equals(this.triple.subject());
        this.sameProperty = this.lastPredicate.equals((Object)this.triple.predicate());
        return this.embedded.pop();
    }

    private void writeURI(IRI uri) throws IOException {
        if (uri == null) {
            this.sb.append("<>");
            return;
        }
        String abbrev = this.getParams().getNamespaceContext().compact(uri);
        if (!abbrev.equals(uri.toString())) {
            this.sb.append(abbrev);
            return;
        }
        if (this.getParams().getNamespaceContext().getNamespaceURI(uri.getScheme()) != null) {
            this.sb.append(uri.toString());
            return;
        }
        this.sb.append('<').append(this.encodeURIString(uri.toString())).append('>');
    }

    private void writeLiteral(Literal literal) throws IOException {
        String value = literal.object().toString();
        if (value.indexOf(10) >= 0 || value.indexOf(13) >= 0 || value.indexOf(9) >= 0) {
            this.sb.append("\"\"\"").append(this.encodeLongString(value)).append("\"\"\"");
        } else {
            this.sb.append('\"').append(this.encodeString(value)).append('\"');
        }
        if (literal.type() != null) {
            this.sb.append("^^").append(literal.type().toString());
        } else if (literal.lang() != null) {
            this.sb.append('@').append(literal.lang());
        }
    }

    private void writeIndent(int indentLevel) throws IOException {
        for (int i = 0; i < indentLevel; ++i) {
            this.sb.append('\t');
        }
    }

    private String encodeString(String value) {
        String s = value;
        s = this.gsub("\\", "\\\\", s);
        s = this.gsub("\t", "\\t", s);
        s = this.gsub("\n", "\\n", s);
        s = this.gsub("\r", "\\r", s);
        s = this.gsub("\"", "\\\"", s);
        return s;
    }

    private String encodeLongString(String value) {
        String s = value;
        s = this.gsub("\\", "\\\\", s);
        s = this.gsub("\"", "\\\"", s);
        return s;
    }

    private String encodeURIString(String value) {
        String s = value;
        s = this.gsub("\\", "\\\\", s);
        s = this.gsub(">", "\\>", s);
        return s;
    }

    private String gsub(String olds, String news, String text) {
        if (olds == null || olds.length() == 0) {
            return text;
        }
        if (text == null) {
            return null;
        }
        int oldsIndex = text.indexOf(olds);
        if (oldsIndex == -1) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int prevIndex = 0;
        while (oldsIndex >= 0) {
            buf.append(text.substring(prevIndex, oldsIndex));
            buf.append(news);
            prevIndex = oldsIndex + olds.length();
            oldsIndex = text.indexOf(olds, prevIndex);
        }
        buf.append(text.substring(prevIndex));
        return buf.toString();
    }
}

