/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.turtle;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.RdfContentBuilder;
import org.xbib.content.rdf.RdfContentBuilderHandler;
import org.xbib.content.rdf.RdfContentBuilderProvider;
import org.xbib.content.rdf.RdfContentParams;
import org.xbib.content.rdf.RdfContentParser;
import org.xbib.content.rdf.RdfContentType;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.StandardRdfContentType;
import org.xbib.content.rdf.Triple;
import org.xbib.content.rdf.XSDResourceIdentifiers;
import org.xbib.content.rdf.internal.DefaultAnonymousResource;
import org.xbib.content.rdf.internal.DefaultLiteral;
import org.xbib.content.rdf.internal.DefaultResource;
import org.xbib.content.rdf.internal.DefaultTriple;
import org.xbib.content.resource.IRI;
import org.xbib.content.resource.Node;
import org.xbib.content.resource.XmlNamespaceContext;

public class TurtleContentParser<R extends RdfContentParams>
implements RdfContentParser<R> {
    private static final Logger logger = Logger.getLogger(TurtleContentParser.class.getName());
    private final Resource resource = new DefaultAnonymousResource();
    private final HashMap<String, Node> bnodes = new HashMap();
    private RdfContentBuilderProvider<R> provider;
    private RdfContentBuilderHandler<R> rdfContentBuilderHandler;
    private RdfContentBuilder<R> builder;
    private IRI baseIRI;
    private PushbackReader reader;
    private Resource subject;
    private IRI predicate;
    private Node object;
    private Resource lastsubject;
    private StringBuilder sb;
    private boolean eof;
    private LinkedList<Triple> triples;
    private XmlNamespaceContext context = XmlNamespaceContext.newDefaultInstance();

    public TurtleContentParser(InputStream in) throws IOException {
        this(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public TurtleContentParser(Reader reader) {
        this.reader = new PushbackReader(reader, 2);
    }

    public static String decode(String s, String encoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        boolean fragment = false;
        block5: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '+': {
                    sb.append(' ');
                    continue block5;
                }
                case '#': {
                    sb.append(ch);
                    fragment = true;
                    continue block5;
                }
                case '%': {
                    if (!fragment) {
                        sb.append((char)(Character.digit(s.charAt(++i), 16) << 4 | Character.digit(s.charAt(++i), 16)));
                        continue block5;
                    }
                    sb.append(ch);
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return new String(sb.toString().getBytes(StandardCharsets.ISO_8859_1), encoding);
    }

    @Override
    public RdfContentType contentType() {
        return StandardRdfContentType.TURTLE;
    }

    public TurtleContentParser<R> setRdfContentBuilderProvider(RdfContentBuilderProvider<R> provider) {
        this.provider = provider;
        return this;
    }

    public TurtleContentParser<R> setRdfContentBuilderHandler(RdfContentBuilderHandler<R> rdfContentBuilderHandler) {
        this.rdfContentBuilderHandler = rdfContentBuilderHandler;
        return this;
    }

    public TurtleContentParser<R> setBaseIRI(IRI baseIRI) {
        this.baseIRI = baseIRI;
        return this;
    }

    public TurtleContentParser<R> context(XmlNamespaceContext context) {
        this.context = context;
        return this;
    }

    @Override
    public TurtleContentParser<R> parse() throws IOException {
        if (this.provider != null) {
            this.builder = this.provider.newContentBuilder();
            this.builder.startStream();
        }
        this.reader = new PushbackReader(this.reader, 2);
        this.sb = new StringBuilder();
        this.eof = false;
        this.triples = new LinkedList();
        try {
            while (!this.eof) {
                char ch = this.skipWhitespace();
                if (this.eof) {
                    break;
                }
                if (ch == '@') {
                    this.parseDirective();
                    continue;
                }
                this.parseTriple();
            }
        }
        finally {
            this.reader.close();
            if (this.builder != null) {
                while (!this.triples.isEmpty()) {
                    Triple t = this.triples.pop();
                    this.builder.receive(t);
                }
                if (this.rdfContentBuilderHandler != null) {
                    this.rdfContentBuilderHandler.build(this.builder);
                }
                this.builder.endStream();
                this.bnodes.clear();
            }
        }
        return this;
    }

    private void skip() throws IOException {
        int c = this.reader.read();
        if (c == -1) {
            throw new EOFException();
        }
    }

    private void parseDirective() throws IOException {
        char ch;
        boolean b;
        this.sb.setLength(0);
        do {
            boolean bl = b = !this.isWhitespace(ch = this.read());
            if (!b) continue;
            this.sb.append(ch);
        } while (b);
        String directive = this.sb.toString();
        this.skipWhitespace();
        this.sb.setLength(0);
        if ("@prefix".equalsIgnoreCase(directive)) {
            ch = this.read();
            while (ch != ':') {
                this.sb.append(ch);
                ch = this.read();
            }
            String prefix = this.sb.toString();
            this.skip();
            this.skipWhitespace();
            IRI nsURI = this.parseURI();
            if ("".equals(prefix)) {
                this.baseIRI = nsURI;
            }
            this.context.addNamespace(prefix, nsURI.toString());
        } else if ("@base".equalsIgnoreCase(directive)) {
            this.baseIRI = this.parseURI();
        } else {
            throw new IOException(this.baseIRI + ": unknown directive: " + directive);
        }
        this.skipWhitespace();
        this.validate(this.reader.read(), '.');
    }

    private void parseTriple() throws IOException {
        this.subject = null;
        this.predicate = null;
        this.object = null;
        this.parseSubject();
        this.skipWhitespace();
        this.parsePredicateObjectList();
        this.skipWhitespace();
        this.validate(this.reader.read(), '.');
    }

    private void parsePredicateObjectList() throws IOException {
        this.predicate = this.parsePredicate();
        this.skipWhitespace();
        this.parseObjectList();
        char ch = this.skipWhitespace();
        while (ch == ';') {
            this.skip();
            ch = this.skipWhitespace();
            if (ch == '.' || ch == ']') break;
            this.predicate = this.parsePredicate();
            this.skipWhitespace();
            this.parseObjectList();
            ch = this.skipWhitespace();
        }
    }

    private void parseObjectList() throws IOException {
        this.parseObject();
        char ch = this.skipWhitespace();
        while (ch == ',') {
            this.skip();
            this.skipWhitespace();
            this.parseObject();
            ch = this.skipWhitespace();
        }
    }

    private void parseSubject() throws IOException {
        char ch = this.peek();
        if (ch == '(') {
            this.subject = this.parseCollection();
        } else if (ch == '[') {
            this.subject = (Resource)this.parseBlankNode();
        } else {
            Node value = this.parseValue();
            if (value instanceof Resource) {
                this.subject = (Resource)value;
            } else {
                throw new IOException(this.baseIRI + ": illegal subject value: '" + value + "' (" + value.getClass() + ")");
            }
        }
    }

    private IRI parsePredicate() throws IOException {
        char ch = this.read();
        if (ch == 'a') {
            char ch2 = this.read();
            if (this.isWhitespace(ch2)) {
                return this.resource.newPredicate("rdf:type");
            }
            this.reader.unread(ch2);
        }
        this.reader.unread(ch);
        Node obj = this.parseValue();
        if (obj instanceof Resource) {
            return this.resource.newPredicate(obj.toString());
        }
        throw new IOException(this.baseIRI + ": illegal predicate value: " + obj);
    }

    private void parseObject() throws IOException {
        char ch = this.peek();
        this.object = ch == '(' ? this.parseCollection() : (ch == '[' ? this.parseBlankNode() : this.parseValue());
        DefaultTriple stmt = new DefaultTriple(this.subject, this.predicate, this.object);
        if (this.subject.isEmbedded()) {
            this.triples.add(0, stmt);
        } else if (this.lastsubject == null || !this.subject.equals(this.lastsubject)) {
            if (this.provider != null) {
                while (!this.triples.isEmpty()) {
                    Triple t = this.triples.pop();
                    this.builder.receive(t);
                }
                if (this.rdfContentBuilderHandler != null && this.builder.getSubject() != null) {
                    this.rdfContentBuilderHandler.build(this.builder);
                }
                this.bnodes.clear();
                this.builder = this.provider.newContentBuilder();
                this.builder.receive(this.subject.id());
                this.builder.receive(stmt);
            }
            this.lastsubject = this.subject;
        } else if (this.builder != null) {
            this.builder.receive(stmt);
        }
    }

    private Node parseValue() throws IOException {
        char ch = this.peek();
        if (ch == '<') {
            return new DefaultResource(this.parseURI());
        }
        if (ch == ':' || this.isPrefixStartChar(ch)) {
            return this.parseQNameOrBoolean();
        }
        if (ch == '_') {
            return this.parseNodeID();
        }
        if (ch == '(') {
            return this.parseCollection();
        }
        if (ch == '\"') {
            return this.parseQuotedLiteral();
        }
        if (Character.isDigit(ch) || ch == '.' || ch == '+' || ch == '-') {
            return this.parseNumber();
        }
        if (ch == '\uffff') {
            throw new EOFException();
        }
        throw new IOException(this.baseIRI + ": unable to parse value, unknown character: code = " + ch + " character = '" + ch + "'.  Last triple seen: " + this.subject + " " + this.predicate + " " + this.object);
    }

    private IRI parseURI() throws IOException {
        char ch = this.read();
        boolean checkForClose = false;
        if (ch == '<') {
            ch = this.read();
            checkForClose = true;
        }
        this.sb.setLength(0);
        boolean ended = false;
        while (!ended) {
            this.sb.append(ch);
            if (ch == '\\') {
                ch = this.read();
                this.sb.append(ch);
            }
            ch = this.read();
            ended = checkForClose ? ch == '>' : ch == '>' || ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r';
        }
        String decoded = TurtleContentParser.decode(this.sb.toString().trim(), "UTF-8");
        IRI u = IRI.builder().curie(decoded).build();
        u = this.baseIRI.resolve(u);
        return u;
    }

    private Node parseQNameOrBoolean() throws IOException {
        String ns;
        this.sb.setLength(0);
        char ch = this.read();
        if (ch != ':' && !this.isPrefixStartChar(ch)) {
            throw new IOException(this.baseIRI + ": expected colon or letter, not: '" + ch + "'");
        }
        if (ch == ':') {
            ns = this.context.getNamespaceURI("");
        } else {
            String value;
            this.sb.append(ch);
            ch = this.read();
            while (Character.isLetter(ch) || Character.isDigit(ch) || ch == '-' || ch == '_') {
                this.sb.append(ch);
                ch = this.read();
            }
            if (ch != ':' && ("true".equals(value = this.sb.toString()) || "false".equals(value))) {
                return this.resource.newLiteral(value).type(XSDResourceIdentifiers.BOOLEAN);
            }
            this.validate(ch, ':');
            ns = this.context.getNamespaceURI(this.sb.toString());
            if (ns == null) {
                throw new IOException(this.baseIRI + ": namespace not found: " + this.sb.toString());
            }
        }
        this.sb.setLength(0);
        ch = this.read();
        if (Character.isLetter(ch) || ch == '_') {
            this.sb.append(ch);
            ch = this.read();
            while (Character.isLetter(ch) || Character.isDigit(ch) || ch == '-' || ch == '_') {
                this.sb.append(ch);
                ch = this.read();
            }
        }
        this.reader.unread(ch);
        IRI iri = IRI.builder().curie(ns + this.sb).build();
        return new DefaultResource(iri);
    }

    private Node parseBlankNode() throws IOException {
        char ch = this.peek();
        if (ch == '_') {
            return this.parseNodeID();
        }
        if (ch == '[') {
            this.skip();
            DefaultAnonymousResource bnode = new DefaultAnonymousResource();
            ch = this.read();
            if (ch != ']') {
                Resource oldsubject = this.subject;
                IRI oldpredicate = this.predicate;
                this.subject = bnode;
                this.skipWhitespace();
                this.parsePredicateObjectList();
                this.skipWhitespace();
                this.validate(this.reader.read(), ']');
                this.subject = oldsubject;
                this.predicate = oldpredicate;
            }
            return bnode;
        }
        throw new IOException(this.baseIRI + ":expected character: '[' or '_'");
    }

    private Resource parseCollection() throws IOException {
        DefaultResource value;
        this.validate(this.reader.read(), '(');
        char ch = this.skipWhitespace();
        if (ch == ')') {
            this.skip();
            return new DefaultResource(IRI.builder().curie("rdf", "nil").build());
        }
        DefaultAnonymousResource first = new DefaultAnonymousResource();
        Resource oldsubject = this.subject;
        IRI oldpredicate = this.predicate;
        this.subject = first;
        this.predicate = this.resource.newPredicate("rdf:first");
        this.parseObject();
        ch = this.skipWhitespace();
        DefaultResource blanknode = new DefaultResource(first.id());
        while (ch != ')') {
            value = new DefaultAnonymousResource();
            if (this.builder != null) {
                this.builder.receive(new DefaultTriple(blanknode, this.resource.newPredicate("rdf:rest"), value));
            }
            this.subject = value;
            blanknode = value;
            this.parseObject();
            ch = this.skipWhitespace();
        }
        this.skip();
        if (this.builder != null) {
            value = new DefaultResource(IRI.builder().curie("rdf", "null").build());
            this.builder.receive(new DefaultTriple(blanknode, this.resource.newPredicate("rdf:rest"), value));
        }
        this.subject = oldsubject;
        this.predicate = oldpredicate;
        return first;
    }

    private Node parseNodeID() throws IOException {
        this.validate(this.reader.read(), '_');
        this.validate(this.reader.read(), ':');
        char ch = this.read();
        this.sb.setLength(0);
        if (Character.isLetter(ch) || ch == '_') {
            this.sb.append(ch);
            ch = this.read();
            while (Character.isLetter(ch) || Character.isDigit(ch) || ch == '-' || ch == '_') {
                this.sb.append(ch);
                ch = this.read();
            }
        }
        this.reader.unread(ch);
        String nodeID = this.sb.toString();
        Node bnode = this.bnodes.get(nodeID);
        if (bnode != null) {
            return bnode;
        }
        bnode = new DefaultAnonymousResource(nodeID);
        this.bnodes.put(nodeID, bnode);
        return bnode;
    }

    private Literal parseQuotedLiteral() throws IOException {
        String value = this.parseQuotedString();
        char ch = this.peek();
        if (ch == '@') {
            this.skip();
            this.sb.setLength(0);
            ch = this.read();
            if (!Character.isLowerCase(ch)) {
                throw new IOException(this.baseIRI + ": lower case character expected: " + ch);
            }
            this.sb.append(ch);
            ch = this.read();
            while (Character.isLowerCase(ch) || Character.isDigit(ch) || ch == '-') {
                this.sb.append(ch);
                ch = this.read();
            }
            this.reader.unread(ch);
            return new DefaultLiteral(value).lang(this.sb.toString());
        }
        if (ch == '^') {
            this.skip();
            this.validate(this.reader.read(), '^');
            this.skipWhitespace();
            IRI iri = this.parseURI();
            return new DefaultLiteral(value).type(iri);
        }
        return new DefaultLiteral(value);
    }

    private String parseQuotedString() throws IOException {
        String result;
        this.validate(this.reader.read(), '\"');
        char c2 = this.read();
        char c3 = this.read();
        if (c2 == '\"' && c3 == '\"') {
            result = this.parseLongString();
        } else {
            this.reader.unread(c3);
            this.reader.unread(c2);
            result = this.parseString();
        }
        return this.decodeTurtleString(result);
    }

    private String parseString() throws IOException {
        char ch;
        this.sb.setLength(0);
        while ((ch = this.read()) != '\"') {
            this.sb.append(ch);
            if (ch != '\\') continue;
            ch = this.read();
            this.sb.append(ch);
        }
        return this.sb.toString();
    }

    private String parseLongString() throws IOException {
        this.sb.setLength(0);
        int doubleQuoteCount = 0;
        while (doubleQuoteCount < 3) {
            char ch = this.read();
            doubleQuoteCount = ch == '\"' ? ++doubleQuoteCount : 0;
            this.sb.append(ch);
            if (ch != '\\') continue;
            ch = this.read();
            this.sb.append(ch);
        }
        return this.sb.substring(0, this.sb.length() - 3);
    }

    private Literal parseNumber() throws IOException {
        this.sb.setLength(0);
        IRI datatype = IRI.builder().curie("xsd", "integer").build();
        char ch = this.read();
        if (ch == '+' || ch == '-') {
            this.sb.append(ch);
            ch = this.read();
        }
        while (Character.isDigit(ch)) {
            this.sb.append(ch);
            ch = this.read();
        }
        if (ch == '.' || ch == 'e' || ch == 'E') {
            datatype = IRI.builder().curie("xsd", "decimal").build();
            if (ch == '.') {
                this.sb.append(ch);
                ch = this.read();
                while (Character.isDigit(ch)) {
                    this.sb.append(ch);
                    ch = this.read();
                }
                if (this.sb.length() == 1) {
                    throw new IOException(" incomplete decimal: " + this.sb);
                }
            } else if (this.sb.length() == 0) {
                throw new IOException("in complete fraction: " + this.sb);
            }
            if (ch == 'e' || ch == 'E') {
                datatype = IRI.builder().curie("xsd", "double").build();
                this.sb.append(ch);
                ch = this.read();
                if (ch == '+' || ch == '-') {
                    this.sb.append(ch);
                    ch = this.read();
                }
                if (!Character.isDigit(ch)) {
                    throw new IOException("exponent value missing: " + this.sb);
                }
                this.sb.append(ch);
                ch = this.read();
                while (Character.isDigit(ch)) {
                    this.sb.append(ch);
                    ch = this.read();
                }
            }
        }
        this.reader.unread(ch);
        return new DefaultLiteral(this.sb.toString()).type(datatype);
    }

    private char skipWhitespace() throws IOException {
        int ch = this.reader.read();
        while (this.isWhitespace((char)ch) || ch == 35) {
            if (ch == 35) {
                this.skipLine();
            }
            ch = this.reader.read();
        }
        if (ch == -1) {
            this.eof = true;
        }
        this.reader.unread(ch);
        return (char)ch;
    }

    private void skipLine() throws IOException {
        int ch = this.reader.read();
        while (ch != 13 && ch != 10 && ch != -1) {
            ch = this.reader.read();
        }
        if (ch == 13 && (ch = this.reader.read()) != 10) {
            this.reader.unread(ch);
        }
        if (ch == -1) {
            this.eof = true;
        }
    }

    private char peek() throws IOException {
        int ch = this.reader.read();
        if (ch == -1) {
            this.eof = true;
        }
        this.reader.unread(ch);
        return (char)ch;
    }

    private char read() throws IOException {
        int ch = this.reader.read();
        if (ch == -1) {
            throw new EOFException();
        }
        return (char)ch;
    }

    private void validate(int ch, char v) throws IOException {
        if ((char)ch != v) {
            String message = (this.subject != null ? this.subject : "") + " unexpected character: '" + (char)ch + "' expected: '" + v + "'";
            logger.log(Level.WARNING, message);
        }
    }

    private boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    private boolean isPrefixStartChar(char ch) {
        return Character.isLetter(ch) || ch >= '\u00c0' && ch <= '\u00d6' || ch >= '\u00d8' && ch <= '\u00f6' || ch >= '\u00f8' && ch <= '\u02ff' || ch >= '\u0370' && ch <= '\u037d' || ch >= '\u037f' && ch <= '\u1fff' || ch >= '\u200c' && ch <= '\u200d' || ch >= '\u2070' && ch <= '\u218f' || ch >= '\u2c00' && ch <= '\u2fef' || ch >= '\u3001' && ch <= '\ud7ff' || ch >= '\uf900' && ch <= '\ufdcf' || ch >= '\ufdf0' && ch <= '\ufffd';
    }

    private String decodeTurtleString(String s) {
        int pos = s.indexOf(92);
        if (pos == -1) {
            return s;
        }
        int i = 0;
        int len = s.length();
        this.sb.setLength(0);
        while (pos != -1) {
            String xx;
            this.sb.append(s.substring(i, pos));
            if (pos + 1 >= len) break;
            char ch = s.charAt(pos + 1);
            if (ch == 't') {
                this.sb.append('\t');
                i = pos + 2;
            } else if (ch == 'r') {
                this.sb.append('\r');
                i = pos + 2;
            } else if (ch == 'n') {
                this.sb.append('\n');
                i = pos + 2;
            } else if (ch == '\"') {
                this.sb.append('\"');
                i = pos + 2;
            } else if (ch == '>') {
                this.sb.append('>');
                i = pos + 2;
            } else if (ch == 'u') {
                if (pos + 5 >= len) {
                    throw new IllegalArgumentException("incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(pos + 2, pos + 6);
                try {
                    ch = (char)Integer.parseInt(xx, 16);
                    this.sb.append(ch);
                    i = pos + 6;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("illegal Unicode escape sequence '\\u" + xx + "' in: " + s);
                }
            } else if (ch == 'U') {
                if (pos + 9 >= len) {
                    throw new IllegalArgumentException("incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(pos + 2, pos + 10);
                try {
                    ch = (char)Integer.parseInt(xx, 16);
                    this.sb.append(ch);
                    i = pos + 10;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("illegal Unicode escape sequence '\\U" + xx + "' in: " + s);
                }
            } else {
                this.sb.append('\\');
                i = pos + 2;
            }
            pos = s.indexOf(92, i);
        }
        this.sb.append(s.substring(i));
        return this.sb.toString();
    }
}

