/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.turtle;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.rdf.RDF;
import org.xbib.content.rdf.io.sink.CharSink;
import org.xbib.content.rdf.io.sink.TripleSink;

public final class TurtleSerializer
implements TripleSink,
RDF {
    private static final Logger logger = Logger.getLogger(TurtleSerializer.class.getName());
    private static final String DOT_EOL = " .\n";
    private static final String COMMA_EOL = " ,\n";
    private static final String SEMICOLON_EOL = " ;\n";
    private static final String EOL = "\n";
    private static final String MULTILINE_QUOTE = "\"\"\"";
    private static final char SINGLE_LINE_QUOTE = '\"';
    private static final char BNODE_START = '[';
    private static final char BNODE_END = ']';
    private static final char URI_START = '<';
    private static final char URI_END = '>';
    private static final char SPACE = ' ';
    private static final char RDF_TYPE_ABBR = 'a';
    private static final String INDENT = "    ";
    private final CharSink sink;
    private final LinkedList<String> bnodeStack = new LinkedList();
    private final Set<String> namedBnodes = new HashSet<String>();
    private String prevSubj;
    private String prevPred;
    private String baseUri;

    private TurtleSerializer(CharSink sink) {
        this.sink = sink;
    }

    public static TripleSink connect(CharSink sink) {
        return new TurtleSerializer(sink);
    }

    @Override
    public void addNonLiteral(String subj, String pred, String obj) {
        try {
            this.startTriple(subj, pred);
            if (obj.startsWith("_:")) {
                if (!this.namedBnodes.contains(obj) && obj.endsWith("sbl")) {
                    this.openBnode(obj);
                } else {
                    this.sink.process(obj);
                }
            } else {
                this.serializeUri(obj);
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
    }

    @Override
    public void addPlainLiteral(String subj, String pred, String content, String lang) {
        try {
            this.startTriple(subj, pred);
            this.addContent(content);
            if (lang != null) {
                this.sink.process('@').process(lang);
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
    }

    @Override
    public void addTypedLiteral(String subj, String pred, String content, String type) {
        try {
            this.startTriple(subj, pred);
            this.addContent(content);
            this.sink.process("^^");
            this.serializeUri(type);
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
    }

    @Override
    public void startStream() throws IOException {
        this.sink.startStream();
        this.prevSubj = null;
        this.prevPred = null;
        if (this.baseUri != null) {
            this.sink.process("@base ").process('<').process(this.baseUri).process('>').process(DOT_EOL);
        }
        this.sink.process("@prefix rdf: ").process('<').process("http://www.w3.org/1999/02/22-rdf-syntax-ns#").process('>').process(DOT_EOL);
        this.bnodeStack.clear();
        this.namedBnodes.clear();
    }

    @Override
    public void endStream() throws IOException {
        while (!this.bnodeStack.isEmpty()) {
            this.closeBnode();
        }
        if (this.prevPred != null) {
            this.sink.process(DOT_EOL);
        } else {
            this.sink.process(EOL);
        }
        this.baseUri = null;
        this.sink.endStream();
    }

    @Override
    public void beginDocument(String id) throws IOException {
        this.sink.beginDocument(id);
    }

    @Override
    public void endDocument(String id) throws IOException {
        this.sink.endDocument(id);
    }

    @Override
    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri.substring(0, baseUri.length() - 1);
    }

    private void startTriple(String subj, String pred) throws IOException {
        if (subj.equals(this.prevSubj)) {
            if (pred.equals(this.prevPred)) {
                this.sink.process(COMMA_EOL);
                this.indent(2);
            } else if (this.prevPred != null) {
                this.sink.process(SEMICOLON_EOL);
                this.indent(1);
                this.serializePredicate(pred);
            } else {
                this.indent(0);
                this.serializePredicate(pred);
            }
        } else {
            if (!this.bnodeStack.isEmpty()) {
                this.closeBnode();
                this.startTriple(subj, pred);
                return;
            }
            if (this.prevSubj != null) {
                this.sink.process(DOT_EOL);
            }
            if (subj.startsWith("_:")) {
                if (subj.endsWith("sbl")) {
                    this.openBnode(subj);
                } else {
                    this.sink.process(subj).process(' ');
                    this.namedBnodes.add(subj);
                }
            } else {
                this.serializeUri(subj);
            }
            this.serializePredicate(pred);
        }
        this.prevSubj = subj;
        this.prevPred = pred;
    }

    private void serializePredicate(String pred) throws IOException {
        if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(pred)) {
            this.sink.process('a').process(' ');
        } else {
            this.serializeUri(pred);
        }
    }

    private void serializeUri(String uri) throws IOException {
        String escapedUri = uri.replace("\\", "\\\\").replace(">", "\\u003E");
        if (escapedUri.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            this.sink.process("rdf:").process(escapedUri.substring("http://www.w3.org/1999/02/22-rdf-syntax-ns#".length()));
        } else if (this.baseUri != null && escapedUri.startsWith(this.baseUri)) {
            this.sink.process('<').process(escapedUri.substring(this.baseUri.length())).process('>');
        } else {
            this.sink.process('<').process(escapedUri).process('>');
        }
        this.sink.process(' ');
    }

    private void indent(int additionalIndent) throws IOException {
        for (int i = 0; i < this.bnodeStack.size() + additionalIndent; ++i) {
            this.sink.process(INDENT);
        }
    }

    private void addContent(String content) throws IOException {
        String escapedContent = content.replace("\\", "\\\\").replace("\"", "\\\"");
        if (escapedContent.contains(EOL)) {
            this.sink.process(MULTILINE_QUOTE).process(escapedContent).process(MULTILINE_QUOTE);
        } else {
            this.sink.process('\"').process(escapedContent).process('\"');
        }
    }

    private void openBnode(String obj) throws IOException {
        this.sink.process('[');
        this.bnodeStack.push(obj);
        this.prevSubj = obj;
        this.prevPred = null;
    }

    private void closeBnode() throws IOException {
        this.sink.process(']');
        this.prevSubj = this.bnodeStack.pop();
        this.prevPred = null;
        if (this.prevSubj == null) {
            this.sink.process(DOT_EOL);
        }
    }
}

