/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.xml;

import java.io.IOException;
import java.util.EmptyStackException;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.xbib.content.rdf.RdfContentBuilder;
import org.xbib.content.rdf.RdfContentParams;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.internal.DefaultAnonymousResource;
import org.xbib.content.rdf.io.xml.XmlHandler;
import org.xbib.content.resource.IRI;
import org.xbib.content.xml.util.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractXmlHandler<P extends RdfContentParams>
extends DefaultHandler
implements XmlHandler<P> {
    protected final RdfContentParams params;
    protected final StringBuilder content;
    private final LinkedList<QName> parents;
    protected Resource resource;
    private RdfContentBuilder<P> builder;
    private String defaultPrefix;
    private String defaultNamespace;
    private int lastlevel;

    public AbstractXmlHandler(RdfContentParams params) {
        this.params = params;
        this.content = new StringBuilder();
        this.parents = new LinkedList();
        this.resource = new DefaultAnonymousResource();
    }

    public RdfContentParams getParams() {
        return this.params;
    }

    public Resource getResource() {
        return this.resource;
    }

    public LinkedList<QName> getParents() {
        return this.parents;
    }

    @Override
    public AbstractXmlHandler<P> setDefaultNamespace(String prefix, String namespaceURI) {
        this.defaultPrefix = prefix;
        this.defaultNamespace = namespaceURI;
        this.params.getNamespaceContext().addNamespace(prefix, namespaceURI);
        return this;
    }

    @Override
    public AbstractXmlHandler<P> setBuilder(RdfContentBuilder<P> builder) {
        this.builder = builder;
        return this;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.openResource();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        this.parents.push(new QName("_"));
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.closeResource();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String nsURI, String localname, String qname, Attributes atts) throws SAXException {
        try {
            QName name = this.makeQName(nsURI, localname, qname);
            boolean delimiter = this.isResourceDelimiter(name);
            if (delimiter) {
                this.closeResource();
                this.openResource();
            }
            if (this.skip(name)) {
                return;
            }
            int level = this.parents.size();
            if (!delimiter) {
                this.openPredicate(this.parents.peek(), name, this.lastlevel - level);
            }
            this.parents.push(name);
            this.lastlevel = level;
            if (atts != null) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attrValue = atts.getValue(i);
                    if (attrValue == null || attrValue.isEmpty()) continue;
                    String newAttrname = '@' + atts.getLocalName(i);
                    QName attrQName = new QName(atts.getURI(i), newAttrname, atts.getQName(i));
                    if (this.skip(attrQName)) continue;
                    this.startElement(atts.getURI(i), newAttrname, atts.getQName(i), null);
                    this.characters(attrValue.toCharArray(), 0, attrValue.length());
                    this.endElement(atts.getURI(i), newAttrname, atts.getQName(i));
                }
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String nsURI, String localname, String qname) throws SAXException {
        QName name = this.makeQName(nsURI, localname, qname);
        if (this.skip(name)) {
            this.content.setLength(0);
            return;
        }
        int level = this.parents.size();
        this.parents.pop();
        this.identify(name, this.content(), this.resource.id());
        if (!this.isResourceDelimiter(name) && !this.parents.isEmpty()) {
            try {
                this.closePredicate(this.parents.peek(), name, level - this.lastlevel);
            }
            catch (EmptyStackException e) {
                throw new SAXException(e);
            }
        }
        this.content.setLength(0);
        this.lastlevel = level;
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        this.content.append(new String(chars, start, length));
        this.addToPredicate(this.parents.peek(), this.content());
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix == null || prefix.isEmpty() || "http://www.w3.org/2001/XMLSchema-instance".equals(uri)) {
            return;
        }
        this.params.getNamespaceContext().addNamespace(this.makePrefix(prefix), uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    protected String makePrefix(String prefix) {
        return prefix.replaceAll("[^a-zA-Z]+", "");
    }

    protected String makePrefix(String prefix, String localname) {
        String s = prefix.replaceAll("[^a-zA-Z]+", "");
        return s.length() > 0 ? s + ":" + localname : localname;
    }

    protected QName makeQName(String nsURI, String localname, String qname) {
        String prefix = this.params.getNamespaceContext().getPrefix(nsURI);
        return new QName(!this.isEmpty(nsURI) ? nsURI : this.defaultNamespace, !this.isEmpty(localname) ? localname : qname, !this.isEmpty(prefix) ? prefix : this.defaultPrefix);
    }

    public String content() {
        String s = XMLUtil.sanitizeToLineFeed((CharSequence)this.content.toString()).trim();
        return s.length() > 0 ? s : null;
    }

    protected void openResource() throws IOException {
        this.resource = new DefaultAnonymousResource();
    }

    protected void closeResource() throws IOException {
        boolean empty = this.resource.isEmpty();
        if (empty) {
            return;
        }
        if (this.builder != null) {
            this.builder.receive(this.resource.id());
            this.builder.receive(this.resource);
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public abstract boolean isResourceDelimiter(QName var1);

    public abstract boolean skip(QName var1);

    public abstract void identify(QName var1, String var2, IRI var3);

    public abstract void openPredicate(QName var1, QName var2, int var3);

    public abstract void addToPredicate(QName var1, String var2);

    public abstract void closePredicate(QName var1, QName var2, int var3);
}

