/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.xml;

import java.io.IOException;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.RdfContentParams;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.io.xml.AbstractXmlHandler;
import org.xbib.content.rdf.io.xml.XmlResourceHandler;
import org.xbib.content.resource.IRI;
import org.xbib.content.resource.Node;

public abstract class AbstractXmlResourceHandler<P extends RdfContentParams>
extends AbstractXmlHandler<P>
implements XmlResourceHandler<P> {
    protected final LinkedList<Resource> stack = new LinkedList();

    public AbstractXmlResourceHandler(RdfContentParams params) {
        super(params);
    }

    @Override
    public void openResource() throws IOException {
        super.openResource();
        this.stack.push(this.getResource());
    }

    @Override
    public void closeResource() throws IOException {
        super.closeResource();
        this.stack.clear();
    }

    @Override
    public void openPredicate(QName parent, QName name, int level) {
        String elementName = this.makePrefix(name.getPrefix(), name.getLocalPart());
        IRI p = this.toProperty(this.getResource().newPredicate(elementName));
        this.stack.push(this.stack.peek().newResource(p));
    }

    @Override
    public void addToPredicate(QName parent, String content) {
    }

    @Override
    public void closePredicate(QName parent, QName name, int level) {
        Resource r = this.stack.pop();
        String elementName = this.makePrefix(name.getPrefix(), name.getLocalPart());
        if (level < 0 && !this.stack.isEmpty() && !r.isEmpty()) {
            IRI p = this.toProperty(this.getResource().newPredicate(elementName));
            this.stack.peek().add(p, r);
        } else {
            String s = this.content();
            if (s != null && !this.stack.isEmpty()) {
                String newElementName;
                Resource resource;
                IRI p = this.toProperty(this.getResource().newPredicate(elementName));
                Node o = this.getResource().newObject(this.toObject(name, s));
                if (o instanceof Literal) {
                    r.add(p, (Literal)o);
                } else if (o instanceof Resource && !(resource = (Resource)o).isEmpty()) {
                    r.add(p, resource);
                }
                this.stack.peek().compactPredicate(p);
                if (o instanceof Literal && !elementName.equals(newElementName = this.toElementName(elementName))) {
                    this.stack.peek().rename(elementName, newElementName);
                }
            }
        }
    }

    public IRI toProperty(IRI property) {
        return property;
    }

    public String toElementName(String elementName) {
        return elementName;
    }

    @Override
    public Object toObject(QName name, String content) {
        return content;
    }
}

