/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.xml;

import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.util.XMLEventConsumer;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.RdfContentGenerator;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.Triple;
import org.xbib.content.rdf.internal.DefaultResource;
import org.xbib.content.rdf.io.xml.XmlConstants;
import org.xbib.content.rdf.io.xml.XmlContentParams;
import org.xbib.content.resource.IRI;
import org.xbib.content.resource.Node;

public class XmlContentGenerator
implements RdfContentGenerator<XmlContentParams>,
Flushable,
XmlConstants {
    private static final XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    private static final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private final Writer writer;
    private Resource resource;
    private XmlContentParams params = XmlContentParams.XML_CONTENT_PARAMS;

    public XmlContentGenerator(OutputStream out) {
        this(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    public XmlContentGenerator(Writer writer) {
        this.writer = writer;
    }

    @Override
    public XmlContentParams getParams() {
        return this.params;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public XmlContentGenerator receive(IRI iri) throws IOException {
        if (!iri.equals((Object)this.resource.id())) {
            this.receive(this.resource);
            this.resource = new DefaultResource(iri);
        }
        return this;
    }

    @Override
    public RdfContentGenerator<XmlContentParams> setParams(XmlContentParams rdfContentParams) {
        this.params = rdfContentParams;
        return this;
    }

    public XmlContentGenerator startStream() {
        return this;
    }

    @Override
    public RdfContentGenerator<XmlContentParams> setBaseUri(String baseUri) {
        this.startPrefixMapping("", baseUri);
        return this;
    }

    public XmlContentGenerator receive(Triple triple) {
        this.resource.add(triple);
        return this;
    }

    public XmlContentGenerator endStream() {
        return this;
    }

    public XmlContentGenerator startPrefixMapping(String prefix, String uri) {
        if (prefix == null || prefix.isEmpty() || "http://www.w3.org/2001/XMLSchema-instance".equals(uri)) {
            return this;
        }
        this.params.getNamespaceContext().addNamespace(prefix, uri);
        return this;
    }

    public XmlContentGenerator endPrefixMapping(String prefix) {
        return this;
    }

    public XmlContentGenerator receive(Resource resource) throws IOException {
        if (resource == null) {
            return this;
        }
        try {
            XMLEventWriter xew = outputFactory.createXMLEventWriter(this.writer);
            IRI resourceURI = resource.id();
            String nsPrefix = resourceURI.getScheme();
            String name = resourceURI.getSchemeSpecificPart();
            String nsURI = this.params.getNamespaceContext().getNamespaceURI(nsPrefix);
            this.writeResource(xew, resource, new QName(nsURI, name, nsPrefix));
            xew.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        return this;
    }

    private void writeResource(XMLEventConsumer consumer, Resource resource, QName parent) throws XMLStreamException {
        boolean startElementWritten = false;
        List<Triple> triples = resource.properties();
        for (Triple triple : triples) {
            if (!startElementWritten) {
                if (parent != null) {
                    consumer.add(eventFactory.createStartElement(parent, null, null));
                }
                startElementWritten = true;
            }
            this.write(consumer, triple);
        }
        if (!startElementWritten && parent != null) {
            consumer.add(eventFactory.createStartElement(parent, null, null));
        }
        if (parent != null) {
            consumer.add(eventFactory.createEndElement(parent, null));
        }
    }

    private void write(XMLEventConsumer consumer, Triple triple) throws XMLStreamException {
        IRI predicate = triple.predicate();
        Node object = triple.object();
        String nsPrefix = predicate.getScheme();
        String name = predicate.getSchemeSpecificPart();
        String nsURI = this.params.getNamespaceContext().getNamespaceURI(nsPrefix);
        if (object instanceof Resource) {
            this.writeResource(consumer, (Resource)object, new QName(nsURI, name, nsPrefix));
        } else if (object instanceof Literal) {
            String literal = ((Literal)object).object().toString();
            consumer.add(eventFactory.createStartElement(nsPrefix, nsURI, name));
            consumer.add(eventFactory.createCharacters(literal));
            consumer.add(eventFactory.createEndElement(nsPrefix, nsURI, name));
        } else {
            throw new XMLStreamException("can't write object class: " + object.getClass().getName());
        }
    }
}

