/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.util;

import java.io.IOException;
import java.io.Reader;
import org.xbib.content.rdf.util.SimpleFilterReader;

public class NormalizeEolFilter
extends SimpleFilterReader {
    private boolean previousWasEOL;
    private boolean fixLast;
    private int normalizedEOL = 0;
    private char[] eol = null;

    public NormalizeEolFilter(Reader in, String eolString, boolean fixLast) {
        super(in);
        this.eol = eolString.toCharArray();
        this.fixLast = fixLast;
    }

    @Override
    public int read() throws IOException {
        int thisChar = super.read();
        if (this.normalizedEOL == 0) {
            int numEOL = 0;
            boolean atEnd = false;
            switch (thisChar) {
                case 26: {
                    int c = super.read();
                    if (c == -1) {
                        atEnd = true;
                        if (!this.fixLast || this.previousWasEOL) break;
                        numEOL = 1;
                        this.push(thisChar);
                        break;
                    }
                    this.push(c);
                    break;
                }
                case -1: {
                    atEnd = true;
                    if (!this.fixLast || this.previousWasEOL) break;
                    numEOL = 1;
                    break;
                }
                case 10: {
                    numEOL = 1;
                    break;
                }
                case 13: {
                    numEOL = 1;
                    int c1 = super.read();
                    int c2 = super.read();
                    if (c1 == 13 && c2 == 10) break;
                    if (c1 == 13) {
                        numEOL = 2;
                        this.push(c2);
                        break;
                    }
                    if (c1 == 10) {
                        this.push(c2);
                        break;
                    }
                    this.push(c2);
                    this.push(c1);
                    break;
                }
            }
            if (numEOL > 0) {
                while (numEOL-- > 0) {
                    this.push(this.eol);
                    this.normalizedEOL += this.eol.length;
                }
                this.previousWasEOL = true;
                thisChar = this.read();
            } else if (!atEnd) {
                this.previousWasEOL = false;
            }
        } else {
            --this.normalizedEOL;
        }
        return thisChar;
    }
}

