/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.util;

import java.io.IOException;
import java.io.Reader;

public class SimpleFilterReader
extends Reader {
    private static final int PREEMPT_BUFFER_LENGTH = 16;
    private Reader in;
    private int[] preempt = new int[16];
    private int preemptIndex = 0;

    public SimpleFilterReader(Reader in) {
        this.in = in;
    }

    public void push(char c) {
        this.push((int)c);
    }

    public void push(int c) {
        try {
            this.preempt[this.preemptIndex++] = c;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int[] p2 = new int[this.preempt.length * 2];
            System.arraycopy(this.preempt, 0, p2, 0, this.preempt.length);
            this.preempt = p2;
            this.push(c);
        }
    }

    public void push(char[] cs, int start, int length) {
        int i = start + length - 1;
        while (i >= start) {
            this.push(cs[i--]);
        }
    }

    public void push(char[] cs) {
        this.push(cs, 0, cs.length);
    }

    @Override
    public int read() throws IOException {
        return this.preemptIndex > 0 ? this.preempt[--this.preemptIndex] : this.in.read();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public boolean ready() throws IOException {
        return this.in.ready();
    }

    @Override
    public void mark(int i) throws IOException {
        this.in.mark(i);
    }

    @Override
    public long skip(long i) throws IOException {
        return this.in.skip(i);
    }

    @Override
    public int read(char[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(char[] buf, int start, int length) throws IOException {
        int count = 0;
        int c = 0;
        while (length-- > 0 && (c = this.read()) != -1) {
            buf[start++] = (char)c;
            ++count;
        }
        return count == 0 && c == -1 ? -1 : count;
    }
}

