/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.util;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.xbib.content.rdf.util.MultiMap;

public class TreeMultiMap<K, V>
implements MultiMap<K, V> {
    private final Map<K, Set<V>> map = new TreeMap<K, Set<V>>();

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean put(K key, V value) {
        Set<V> set = this.map.get(key);
        if (set == null) {
            set = new LinkedHashSet<V>();
            set.add(value);
            this.map.put(key, set);
            return true;
        }
        set.add(value);
        return false;
    }

    @Override
    public void putAll(K key, Collection<V> values) {
        Set<V> set = this.map.get(key);
        if (set == null) {
            set = new LinkedHashSet<V>();
            this.map.put(key, set);
        }
        set.addAll(values);
    }

    @Override
    public Collection<V> get(K key) {
        return this.map.get(key);
    }

    @Override
    public Set<V> remove(K key) {
        return this.map.remove(key);
    }

    @Override
    public boolean remove(K key, V value) {
        Set<V> set = this.map.get(key);
        return set != null && set.remove(value);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof TreeMultiMap && this.map.equals(((TreeMultiMap)obj).map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

