/*
 * Decompiled with CFR 0.152.
 */
package com.incesoft.tools.excel.support;

import java.io.File;
import java.text.SimpleDateFormat;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.Sheet;
import jxl.Workbook;
import org.xbib.datastructures.xslx.ExcelRowIterator;
import org.xbib.datastructures.xslx.ReaderSupport;

public class XLSReaderSupport
extends ReaderSupport {
    private Workbook workbook;
    private Sheet[] sheets;
    private File inputFile;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public void open() {
        try {
            if (!this.inputFile.exists()) {
                throw new IllegalStateException("not found file " + this.inputFile.getAbsoluteFile());
            }
            this.workbook = Workbook.getWorkbook(this.inputFile);
            this.sheets = this.workbook.getSheets();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ExcelRowIterator rowIterator() {
        XLSObjectIterator iterator = new XLSObjectIterator();
        iterator.init();
        return iterator;
    }

    @Override
    public void close() {
        if (this.workbook != null) {
            this.workbook.close();
            this.workbook = null;
        }
    }

    private static String trimNull(Cell inputcell) {
        if (inputcell == null) {
            return null;
        }
        if (inputcell.getType() == CellType.DATE) {
            DateCell dateCell = (DateCell)inputcell;
            return sdf.format(dateCell.getDate());
        }
        String input = inputcell.getContents().trim();
        if (input.length() == 0) {
            return null;
        }
        return input;
    }

    @Override
    public void setInputFile(File file) {
        this.inputFile = file;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public class XLSObjectIterator
    implements ExcelRowIterator {
        byte sheetindex;
        int totalSheet;
        int rowPos = -1;
        Sheet theSheet;
        int currentSheetrowcount;

        @Override
        public void init() {
            this.sheetindex = 0;
            this.theSheet = XLSReaderSupport.this.sheets[this.sheetindex];
            this.totalSheet = XLSReaderSupport.this.sheets.length;
            this.currentSheetrowcount = this.theSheet.getRows();
        }

        @Override
        public boolean nextRow() {
            ++this.rowPos;
            if (this.rowPos == this.currentSheetrowcount) {
                this.sheetindex = (byte)(this.sheetindex + 1);
                if (this.sheetindex < this.totalSheet) {
                    this.rowPos = 1;
                    this.theSheet = XLSReaderSupport.this.sheets[this.sheetindex];
                    this.currentSheetrowcount = this.theSheet.getRows();
                    return this.rowPos < this.currentSheetrowcount;
                }
                return false;
            }
            return true;
        }

        @Override
        public String getCellValue(int col) {
            if (col < 0) {
                return null;
            }
            return XLSReaderSupport.trimNull(this.theSheet.getCell(col, this.rowPos));
        }

        @Override
        public byte getSheetIndex() {
            return this.sheetindex;
        }

        @Override
        public int getRowPos() {
            return this.rowPos;
        }

        @Override
        public int getCellCount() {
            Cell[] row = this.theSheet.getRow(this.rowPos);
            return row == null ? 0 : row.length;
        }

        @Override
        public void prevRow() {
            --this.rowPos;
            if (this.rowPos == -1) {
                this.rowPos = 0;
            }
        }
    }
}

