/*
 * Decompiled with CFR 0.152.
 */
package com.incesoft.tools.excel.support;

import com.incesoft.tools.excel.support.CellFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jxl.Workbook;
import jxl.format.Colour;
import jxl.format.RGB;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.xbib.datastructures.xslx.WriterSupport;

public class XLSWriterSupport
extends WriterSupport {
    WritableSheet sheet;
    WritableWorkbook workbook;
    static List<Integer> colours = new ArrayList<Integer>();
    static Map<Integer, Colour> colourMap = new HashMap<Integer, Colour>();

    @Override
    public void open() {
        block4: {
            try {
                if (this.file != null) {
                    this.workbook = Workbook.createWorkbook(this.file);
                    break block4;
                }
                if (this.output != null) {
                    this.workbook = Workbook.createWorkbook(this.output);
                    break block4;
                }
                throw new IllegalStateException("no output specified");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static int getRGB(Colour c) {
        RGB defaultRGB = c.getDefaultRGB();
        return defaultRGB.getRed() << 16 | defaultRGB.getGreen() << 8 | defaultRGB.getBlue();
    }

    public static Colour transformColor(int c) {
        int result = Collections.binarySearch(colours, c & 0xFFFFFF);
        if (result < 0 && (result = -(result + 1)) > colours.size() - 1) {
            result = colours.size() - 1;
        }
        return colourMap.get(colours.get(result));
    }

    @Override
    public void writeRow(String[] rowData, CellFormat[] formats) {
        for (int col = 0; col < rowData.length; ++col) {
            WritableCellFormat newFormat;
            String cellString = rowData[col];
            if (cellString == null) continue;
            CellFormat format = null;
            if (formats != null && formats.length > 0) {
                for (CellFormat cellFormat : formats) {
                    if (cellFormat == null || cellFormat.getCellIndex() != col) continue;
                    format = cellFormat;
                    break;
                }
            }
            Label label = new Label(col, this.rowpos, cellString);
            try {
                this.sheet.addCell(label);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (format == null) continue;
            WritableCell c = this.workbook.getSheet(0).getWritableCell(col, this.rowpos);
            WritableCellFormat writableCellFormat = newFormat = c.getCellFormat() == null ? new WritableCellFormat() : new WritableCellFormat(c.getCellFormat());
            if (format != null && (format.getBackColor() != -1 || format.getForeColor() != -1)) {
                if (format.getBackColor() != -1) {
                    try {
                        newFormat.setBackground(XLSWriterSupport.transformColor(format.getBackColor()));
                    }
                    catch (WriteException cellFormat) {
                        // empty catch block
                    }
                }
                if (format.getForeColor() != -1) {
                    try {
                        WritableFont writableFont = new WritableFont(WritableFont.createFont(format.getFontName()));
                        writableFont.setColour(Colour.PINK2);
                        newFormat.setFont(writableFont);
                    }
                    catch (WriteException writeException) {
                        // empty catch block
                    }
                }
            }
            c.setCellFormat(newFormat);
        }
    }

    @Override
    public void writeRow(String[] rowData) {
        this.writeRow(rowData, null);
    }

    @Override
    public void close() {
        try {
            this.workbook.write();
            this.workbook.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createNewSheet() {
        this.sheet = this.workbook.createSheet("sheet" + this.sheetIndex + "1", this.sheetIndex);
    }

    @Override
    public int getMaxRowNumOfSheet() {
        return 60000;
    }

    static {
        for (Colour c : Colour.getAllColours()) {
            colourMap.put(XLSWriterSupport.getRGB(c), c);
            colours.add(XLSWriterSupport.getRGB(c));
        }
        Collections.sort(colours);
    }
}

