/*
 * Decompiled with CFR 0.152.
 */
package com.incesoft.tools.excel.support;

import com.incesoft.tools.excel.xlsx.Cell;
import com.incesoft.tools.excel.xlsx.Sheet;
import com.incesoft.tools.excel.xlsx.SimpleXLSXWorkbook;
import java.io.File;
import org.xbib.datastructures.xslx.ExcelRowIterator;
import org.xbib.datastructures.xslx.ReaderSupport;

public class XLSXReaderSupport
extends ReaderSupport {
    private SimpleXLSXWorkbook wb;
    private Sheet sheet;
    private File inputFile;
    private boolean lazy = true;

    @Override
    public void open() {
        try {
            if (!this.inputFile.exists()) {
                throw new IllegalStateException("not found file " + this.inputFile.getAbsoluteFile());
            }
            this.wb = new SimpleXLSXWorkbook(this.inputFile);
            this.sheet = this.wb.getSheet(0, !this.lazy);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ExcelRowIterator rowIterator() {
        ExcelRowIterator iterator = this.lazy ? new LazyXLSXObjectIterator() : new XLSXObjectIterator();
        iterator.init();
        return iterator;
    }

    @Override
    public void close() {
        if (this.sheet != null) {
            this.sheet.cleanUp();
            this.sheet = null;
        }
        if (this.wb != null) {
            this.wb.close();
            this.wb = null;
        }
    }

    @Override
    public void setInputFile(File file) {
        this.inputFile = file;
    }

    public SimpleXLSXWorkbook getWorkbook() {
        return this.wb;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    protected class LazyXLSXObjectIterator
    implements ExcelRowIterator {
        Sheet.SheetRowReader reader;
        private Cell[] curRow;
        private Cell[] lastRow;
        private Cell[] nextRow;

        protected LazyXLSXObjectIterator() {
        }

        @Override
        public int getCellCount() {
            return this.curRow != null ? this.curRow.length : 0;
        }

        @Override
        public String getCellValue(int col) {
            if (this.curRow == null || col > this.curRow.length - 1 || this.curRow[col] == null) {
                return null;
            }
            String v = this.curRow[col].getValue();
            return v == null || v.trim().length() == 0 ? null : v.trim();
        }

        @Override
        public int getRowPos() {
            return this.reader.getStatus().getRowIndex() - (this.nextRow != null ? 1 : 0);
        }

        @Override
        public byte getSheetIndex() {
            return (byte)XLSXReaderSupport.this.sheet.getSheetIndex();
        }

        @Override
        public void init() {
            this.reader = XLSXReaderSupport.this.sheet.newReader();
        }

        @Override
        public boolean nextRow() {
            if (this.nextRow != null) {
                this.lastRow = this.curRow;
                this.curRow = this.nextRow;
                this.nextRow = null;
            } else {
                if (this.curRow != null) {
                    this.lastRow = this.curRow;
                }
                this.curRow = this.reader.readRow();
            }
            return this.curRow != null;
        }

        @Override
        public void prevRow() {
            if (this.nextRow == null) {
                this.nextRow = this.curRow;
                this.curRow = this.lastRow;
                this.lastRow = null;
            }
        }
    }

    protected class XLSXObjectIterator
    implements ExcelRowIterator {
        int currentSheetRowCount;
        int rowPos = -1;

        protected XLSXObjectIterator() {
        }

        @Override
        public void init() {
            this.currentSheetRowCount = XLSXReaderSupport.this.sheet.getRowCount();
        }

        @Override
        public boolean nextRow() {
            ++this.rowPos;
            return this.rowPos != this.currentSheetRowCount;
        }

        @Override
        public String getCellValue(int col) {
            if (col < 0) {
                return null;
            }
            String v = XLSXReaderSupport.this.sheet.getCellValue(this.rowPos, col);
            return v == null || v.trim().length() == 0 ? null : v.trim();
        }

        @Override
        public byte getSheetIndex() {
            return (byte)XLSXReaderSupport.this.sheet.getSheetIndex();
        }

        @Override
        public int getRowPos() {
            return this.rowPos;
        }

        @Override
        public int getCellCount() {
            Cell[] row = XLSXReaderSupport.this.sheet.getRows().get(this.rowPos);
            return row == null ? 0 : row.length;
        }

        @Override
        public void prevRow() {
            --this.rowPos;
            if (this.rowPos == -1) {
                this.rowPos = 0;
            }
        }
    }
}

