/*
 * Decompiled with CFR 0.152.
 */
package com.incesoft.tools.excel.support;

import com.incesoft.tools.excel.support.CellFormat;
import com.incesoft.tools.excel.xlsx.CellStyle;
import com.incesoft.tools.excel.xlsx.Fill;
import com.incesoft.tools.excel.xlsx.Font;
import com.incesoft.tools.excel.xlsx.Sheet;
import com.incesoft.tools.excel.xlsx.SimpleXLSXWorkbook;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.xbib.datastructures.xslx.WriterSupport;

public class XLSXWriterSupport
extends WriterSupport {
    SimpleXLSXWorkbook workbook;
    Sheet sheet;

    @Override
    public void open() {
        if (this.getClass().getResource("/empty.xlsx") == null) {
            throw new IllegalStateException("no empty.xlsx found in classpath");
        }
        this.workbook = new SimpleXLSXWorkbook(new File(this.getClass().getResource("/empty.xlsx").getFile()));
    }

    @Override
    protected int getMaxRowNumOfSheet() {
        return 0x3FFFFFFF;
    }

    @Override
    public void writeRow(String[] rowData) {
        this.writeRow(rowData, null);
    }

    @Override
    public void writeRow(String[] rowData, CellFormat[] formats) {
        for (int col = 0; col < rowData.length; ++col) {
            String string = rowData[col];
            if (string == null) continue;
            CellFormat format = null;
            if (formats != null && formats.length > 0) {
                for (CellFormat cellFormat : formats) {
                    if (cellFormat == null || cellFormat.getCellIndex() != col) continue;
                    format = cellFormat;
                    break;
                }
            }
            CellStyle cellStyle = null;
            if (format != null && (format.getBackColor() != -1 || format.getForeColor() != -1)) {
                Font font = null;
                Fill fill = null;
                if (format.getForeColor() != -1) {
                    font = this.workbook.createFont();
                    font.setColor(format.getForeColor());
                }
                if (format.getBackColor() != -1) {
                    fill = this.workbook.createFill();
                    fill.setFgColor(format.getBackColor());
                }
                cellStyle = this.workbook.createStyle(font, fill);
            }
            this.sheet.modify(this.rowpos, col, string, cellStyle);
        }
    }

    @Override
    public void close() {
        if (this.workbook == null) {
            return;
        }
        OutputStream fos = null;
        try {
            if (this.file != null) {
                fos = new FileOutputStream(this.file);
            } else if (this.output != null) {
                fos = this.output;
            } else {
                throw new IllegalStateException("no output specified");
            }
            this.workbook.commit(fos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (this.workbook != null) {
                this.workbook.close();
            }
        }
    }

    @Override
    public void createNewSheet() {
        if (this.sheetIndex > 0) {
            throw new IllegalStateException("only one sheet allowed");
        }
        this.sheet = this.workbook.getSheet(this.sheetIndex, true);
    }
}

