/*
 * Decompiled with CFR 0.152.
 */
package com.incesoft.tools.excel.xlsx;

import com.incesoft.tools.excel.xlsx.Font;
import com.incesoft.tools.excel.xlsx.FontRegion;
import com.incesoft.tools.excel.xlsx.SharedStringText;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class RichText
extends SharedStringText {
    private List<FontRegion> regions;
    public static final int RANGE_ALL_TEXT = -1;

    public RichText(String text) {
        super(text);
    }

    RichText() {
    }

    private void writeTagT(XMLStreamWriter writer, String text, int start, int end) throws XMLStreamException {
        writer.writeStartElement("t");
        if (text.charAt(start) == ' ' || text.charAt(end - 1) == ' ') {
            writer.writeAttribute("xml:space", "preserve");
        }
        writer.writeCharacters(text.substring(start, end));
        writer.writeEndElement();
    }

    @Override
    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        if (this.text == null || this.text.length() == 0) {
            throw new IllegalStateException("empty text of rich text,index=" + this.getIndex());
        }
        writer.writeStartElement("si");
        int lastEnd = 0;
        for (FontRegion region : this.regions) {
            if (region.start == -1) {
                region.start = 0;
                region.end = (short)this.text.length();
            }
            if (lastEnd < region.getStart()) {
                writer.writeStartElement("r");
                this.writeTagT(writer, this.text, lastEnd, region.getStart());
                writer.writeEndElement();
            }
            writer.writeStartElement("r");
            region.getFont().serializeAsRichText(writer);
            this.writeTagT(writer, this.text, region.getStart(), region.getEnd());
            writer.writeEndElement();
            lastEnd = region.getEnd();
        }
        if (lastEnd < this.text.length()) {
            writer.writeStartElement("r");
            this.writeTagT(writer, this.text, lastEnd, this.text.length());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public void parse(XMLStreamReader reader) {
    }

    public void applyFont(Font font) {
        this.applyFont(font, -1, -1);
    }

    public void applyFont(Font font, int start, int end) {
        if (start != -1 && start >= end) {
            throw new IllegalArgumentException("apply font with start >= end");
        }
        if (this.regions == null) {
            this.regions = new ArrayList<FontRegion>(2);
        }
        if (start == -1 && this.regions.size() > 0) {
            this.regions.clear();
        }
        this.regions.add(new FontRegion((short)start, (short)end, font));
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    public List<FontRegion> getRegions() {
        return this.regions;
    }
}

