/*
 * Decompiled with CFR 0.152.
 */
package com.incesoft.tools.excel.xlsx;

import com.incesoft.tools.excel.xlsx.Cell;
import com.incesoft.tools.excel.xlsx.CellStyle;
import com.incesoft.tools.excel.xlsx.RichText;
import com.incesoft.tools.excel.xlsx.SharedStringText;
import com.incesoft.tools.excel.xlsx.SheetCommentWriter;
import com.incesoft.tools.excel.xlsx.SimpleXLSXWorkbook;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class Sheet {
    private int sheetIndex;
    private SimpleXLSXWorkbook workbook;
    List<Cell[]> parsedRows = new ArrayList<Cell[]>();
    XMLStreamReader reader;
    boolean alreadyParsed = false;
    public static final Cell[] EMPTY_ROW = new Cell[0];
    private boolean addToMemory = true;
    private int rowCount = -2;
    int modifiedRowLength = 0;
    int lastCommittedRowLength = 0;
    HashMap<Integer, List<SimpleXLSXWorkbook.ModifyEntry>> modifications = new HashMap(100);
    private SheetWriter sheetsWriter;
    private boolean merged = false;
    private static char[] COLUMNS = new char[26];

    public Sheet(int sheetIndex, SimpleXLSXWorkbook workbook) {
        this.sheetIndex = sheetIndex;
        this.workbook = workbook;
    }

    void parseAllRows() {
        if (!this.alreadyParsed) {
            this.alreadyParsed = true;
            new SheetRowReader(this, this.workbook.getSheetReader(this.sheetIndex + 1), true).readRow();
        }
    }

    public SheetRowReader newReader() {
        return new SheetRowReader(this, this.workbook.getSheetReader(this.sheetIndex + 1), false);
    }

    public List<Cell[]> getRows() {
        if (!this.alreadyParsed || !this.addToMemory) {
            throw new IllegalStateException("rows not parsed,it should only be used in classic mode");
        }
        return this.parsedRows;
    }

    /*
     * Unable to fully structure code
     */
    public int getRowCount() {
        block18: {
            if (this.alreadyParsed && this.addToMemory) {
                return this.parsedRows.size();
            }
            if (this.rowCount != -2) break block18;
            this.rowCount = 0;
            reader = this.workbook.getSheetReader(this.sheetIndex + 1);
            try {
                block14: while (reader.hasNext()) {
                    type = reader.next();
                    switch (type) {
                        case 1: {
                            if (!"dimension".equals(reader.getLocalName())) ** GOTO lbl22
                            v = reader.getAttributeValue(null, "ref");
                            if (v != null && (spanPair = v.replaceAll("[A-Z]", "").split(":")).length == 2) {
                                try {
                                    this.rowCount = Integer.valueOf(spanPair[1]) - Integer.valueOf(spanPair[0]) + 1;
                                    ** break;
lbl17:
                                    // 1 sources

                                }
                                catch (NumberFormatException var5_8) {
                                    ** break;
                                }
lbl20:
                                // 1 sources

                                break block18;
                            }
                            ** GOTO lbl24
lbl22:
                            // 1 sources

                            if ("row".equals(reader.getLocalName()) && (r = Integer.valueOf(reader.getAttributeValue(null, "r")).intValue()) > this.rowCount) {
                                this.rowCount = r;
                            }
                        }
lbl24:
                        // 5 sources

                        default: {
                            continue block14;
                        }
                    }
                }
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (XMLStreamException var7_10) {}
            }
        }
        return this.rowCount;
    }

    public void clearRows() {
        this.parsedRows.clear();
    }

    public String getCellValue(int row, int column) {
        if (!this.alreadyParsed || !this.addToMemory) {
            throw new IllegalStateException("rows not parsed,it should only be used in classic mode");
        }
        if (row < this.parsedRows.size()) {
            Cell[] rowEntry = this.parsedRows.get(row);
            if (rowEntry == EMPTY_ROW) {
                return null;
            }
            if (column < rowEntry.length) {
                return rowEntry[column] == null ? null : rowEntry[column].getValue();
            }
            return null;
        }
        return null;
    }

    public String getCellValue(String cellId) {
        if (!this.alreadyParsed || !this.addToMemory) {
            throw new IllegalStateException("rows not parsed,it should only be used in classic mode");
        }
        return this.getCellValue(Integer.valueOf(cellId.substring(1)) - 1, cellId.charAt(0) - 65);
    }

    public boolean isModified() {
        return this.lastCommittedRowLength > 0 || this.modifiedRowLength > 0;
    }

    public int getModfiedRowLength() {
        return this.modifiedRowLength == 0 ? this.lastCommittedRowLength : this.modifiedRowLength;
    }

    public int modify(int r, int c, String comment) {
        List<SimpleXLSXWorkbook.ModifyEntry> modified;
        if (c > 51) {
            throw new IllegalArgumentException("column index(" + c + ") exceeded the limit(51)");
        }
        if (r == -1) {
            r = this.getModfiedRowLength();
        } else if (this.lastCommittedRowLength > 0 && r < this.lastCommittedRowLength) {
            throw new IllegalStateException("after merge,only add allowed");
        }
        if (r >= this.modifiedRowLength) {
            this.modifiedRowLength = r + 1;
        }
        if ((modified = this.modifications.get(r)) == null) {
            modified = new ArrayList<SimpleXLSXWorkbook.ModifyEntry>();
            this.modifications.put(r, modified);
        }
        modified.add(new SimpleXLSXWorkbook.ModifyEntry(r, c, null, null, comment));
        return r;
    }

    public int modify(int r, int c, String text, CellStyle style) {
        List<SimpleXLSXWorkbook.ModifyEntry> modified;
        if (c > 51) {
            throw new IllegalArgumentException("column index(" + c + ") exceeded the limit(51)");
        }
        if (r == -1) {
            r = this.getModfiedRowLength();
        } else if (this.lastCommittedRowLength > 0 && r < this.lastCommittedRowLength) {
            throw new IllegalStateException("after merge,only add allowed");
        }
        if (r >= this.modifiedRowLength) {
            this.modifiedRowLength = r + 1;
        }
        if ((modified = this.modifications.get(r)) == null) {
            modified = new ArrayList<SimpleXLSXWorkbook.ModifyEntry>();
            this.modifications.put(r, modified);
        }
        SharedStringText t = null;
        if (text != null) {
            t = this.workbook.createPlainText(text);
            t.setText(text);
        }
        modified.add(new SimpleXLSXWorkbook.ModifyEntry(r, c, t, style));
        return r;
    }

    public int modify(int r, int c, RichText text, CellStyle style) {
        List<SimpleXLSXWorkbook.ModifyEntry> modified;
        if (c > 51) {
            throw new IllegalArgumentException("column index(" + c + ") exceeded the limit(51)");
        }
        if (r == -1) {
            r = this.getModfiedRowLength();
        } else if (this.lastCommittedRowLength > 0 && r < this.lastCommittedRowLength) {
            throw new IllegalStateException("after merge,only add allowed");
        }
        if (r >= this.modifiedRowLength) {
            this.modifiedRowLength = r + 1;
        }
        if ((modified = this.modifications.get(r)) == null) {
            modified = new ArrayList<SimpleXLSXWorkbook.ModifyEntry>();
            this.modifications.put(r, modified);
        }
        modified.add(new SimpleXLSXWorkbook.ModifyEntry(r, c, text, style));
        return r;
    }

    public void writeDocumentStart(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument("UTF-8", "1.0");
    }

    private Cell modifyCellInternal(SimpleXLSXWorkbook.ModifyEntry modification, Cell cell) {
        if (modification != null) {
            SharedStringText text;
            if (cell == null) {
                cell = new Cell();
            }
            if ((text = modification.text) != null) {
                if (text instanceof RichText && text.getText() == null && cell != null) {
                    if (cell.getValue() == null) {
                        throw new IllegalStateException("there is no cell content for richtext modification,cell=" + Sheet.getCellId(modification.r, modification.c));
                    }
                    text.setText(cell.getValue());
                }
                cell.setV(String.valueOf(text.getIndex()));
                cell.setT("s");
            }
            if (modification.style != null) {
                cell.setS(String.valueOf(modification.style.index));
            }
            if (modification.comment != null) {
                cell.setComment(modification.comment);
            }
        }
        return cell;
    }

    void writeSheetStart(XMLStreamWriter writer, SimpleXLSXWorkbook.XMLStreamCreator commentWriter, SimpleXLSXWorkbook.XMLStreamCreator vmlWriter) throws XMLStreamException {
        if (this.sheetsWriter != null) {
            throw new IllegalStateException("sheets can only be merged once.");
        }
        this.sheetsWriter = new SheetWriter(writer, new SheetCommentWriter(commentWriter, vmlWriter));
        this.sheetsWriter.writeStart();
    }

    public boolean isCommentModified() {
        return this.sheetsWriter != null && this.sheetsWriter.commentWriter != null && this.sheetsWriter.commentWriter.startWriten;
    }

    void writeSheetEnd(String commentRId, String vmlRid, String settingRid) throws XMLStreamException {
        this.sheetsWriter.writeEnd(commentRId, vmlRid, settingRid);
    }

    void writeSheet() throws XMLStreamException {
        this.merged = true;
        for (int rowIndex = this.sheetsWriter.rowIndex; rowIndex < this.modifiedRowLength; ++rowIndex) {
            this.sheetsWriter.writeRow(EMPTY_ROW, rowIndex);
        }
        this.cleanUp();
    }

    void mergeSheet() throws XMLStreamException {
        if (this.merged) {
            this.writeSheet();
            return;
        }
        this.merged = true;
        if (this.alreadyParsed) {
            int rowLen = Math.max(this.parsedRows.size(), this.modifiedRowLength);
            for (int rowIndex = 0; rowIndex < rowLen; ++rowIndex) {
                if (rowIndex < this.parsedRows.size()) {
                    this.sheetsWriter.writeRow(this.parsedRows.get(rowIndex), rowIndex);
                    continue;
                }
                this.sheetsWriter.writeRow(EMPTY_ROW, rowIndex);
            }
        } else {
            SheetRowReader rowReader = this.newReader();
            Cell[] row = null;
            int rowIndex = -1;
            while ((row = rowReader.readRow()) != null) {
                rowIndex = rowReader.getStatus().getRowIndex();
                this.sheetsWriter.writeRow(row, rowIndex);
            }
            if (this.modifiedRowLength - 1 > rowIndex) {
                for (int i = rowIndex + 1; i < this.modifiedRowLength; ++i) {
                    this.sheetsWriter.writeRow(EMPTY_ROW, i);
                }
            }
        }
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.sheetsWriter != null) {
            this.lastCommittedRowLength = this.sheetsWriter.rowIndex + 1;
        }
        this.modifiedRowLength = 0;
        this.parsedRows.clear();
        this.modifications.clear();
    }

    public static String getCellId(int r, int c) {
        if (c <= 25) {
            return COLUMNS[c] + String.valueOf(r + 1);
        }
        return String.valueOf(new char[]{COLUMNS[c / COLUMNS.length - 1], COLUMNS[c % COLUMNS.length]}) + String.valueOf(r + 1);
    }

    void setWorkbook(SimpleXLSXWorkbook workbook) {
        this.workbook = workbook;
    }

    public void setAddToMemory(boolean addToMemory) {
        this.addToMemory = addToMemory;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public boolean isMerged() {
        return this.merged;
    }

    static {
        for (int i = 0; i < COLUMNS.length; ++i) {
            Sheet.COLUMNS[i] = (char)(i + 65);
        }
    }

    public static class SheetRowReader {
        public static final int MAX_COLUMN_SPAN = 52;
        IteratorStatus status = new IteratorStatus();
        Sheet sheet;
        XMLStreamReader reader;
        boolean loadEagerly;
        private int lastRowIndex = -1;
        private Cell[] delayRow;

        SheetRowReader(Sheet sheet, XMLStreamReader reader, boolean loadEagerly) {
            this.sheet = sheet;
            this.reader = reader;
            this.loadEagerly = loadEagerly;
        }

        public IteratorStatus getStatus() {
            return this.status;
        }

        public Cell[] readRow() {
            try {
                if (!this.loadEagerly) {
                    ++this.status.rowIndex;
                    if (this.status.rowIndex < this.lastRowIndex) {
                        return EMPTY_ROW;
                    }
                    if (this.delayRow != null) {
                        Cell[] ret = this.delayRow;
                        this.delayRow = null;
                        return ret;
                    }
                }
                Cell[] ret = null;
                String s = null;
                block6: while (this.reader.hasNext()) {
                    int type = this.reader.next();
                    switch (type) {
                        case 1: {
                            int i;
                            if ("row".equals(this.reader.getLocalName())) {
                                String spans = this.reader.getAttributeValue(null, "spans");
                                if (spans == null) {
                                    ret = EMPTY_ROW;
                                    break;
                                }
                                this.lastRowIndex = Integer.valueOf(this.reader.getAttributeValue(null, "r")) - 1;
                                int columnspan = Integer.valueOf(spans.substring(spans.indexOf(":") + 1));
                                if (columnspan > 52) {
                                    columnspan = 52;
                                }
                                ret = new Cell[columnspan];
                                break;
                            }
                            if (!"c".equals(this.reader.getLocalName())) break;
                            if (ret != null) {
                                String t = this.reader.getAttributeValue(null, "t");
                                String r = this.reader.getAttributeValue(null, "r");
                                String text = null;
                                String v = null;
                                while (this.reader.hasNext()) {
                                    type = this.reader.next();
                                    if (type == 4) {
                                        v = this.reader.getText();
                                        if (!"s".equals(t)) continue;
                                        text = this.sheet.workbook.getSharedStringValue(Integer.valueOf(v));
                                        continue;
                                    }
                                    if (type != 2 || !"c".equals(this.reader.getLocalName())) continue;
                                }
                                if (r.charAt(1) < 'A') {
                                    ret[r.charAt((int)0) - 65] = new Cell(r, s, t, v, text);
                                    break;
                                }
                                if (r.length() <= 2 || r.charAt(2) >= 'A') break;
                                i = r.charAt(1) - 65 + (r.charAt(0) - 65 + 1) * 26;
                                if (i >= 52) continue block6;
                                ret[i] = new Cell(r, s, t, v, text);
                                break;
                            }
                            throw new IllegalStateException("<c> mal-format");
                        }
                        case 2: {
                            int i;
                            if (!"row".equals(this.reader.getLocalName())) break;
                            if (this.loadEagerly) {
                                ++this.status.rowIndex;
                                if (this.status.rowIndex < this.lastRowIndex && this.sheet.addToMemory) {
                                    for (i = 0; i < this.lastRowIndex - this.status.rowIndex; ++i) {
                                        this.sheet.parsedRows.add(EMPTY_ROW);
                                    }
                                }
                                this.status.rowIndex = this.lastRowIndex;
                            }
                            if (this.sheet.addToMemory) {
                                this.sheet.parsedRows.add(ret);
                            }
                            if (this.loadEagerly) {
                                ret = null;
                                break;
                            }
                            if (this.status.rowIndex < this.lastRowIndex) {
                                this.delayRow = ret;
                                return EMPTY_ROW;
                            }
                            return ret;
                        }
                    }
                }
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SheetWriter {
        XMLStreamWriter xmlWriter;
        int rowIndex = -1;
        SheetCommentWriter commentWriter;
        private Cell cell;

        public SheetWriter(XMLStreamWriter xmlWriter, SheetCommentWriter commentWriter) {
            this.xmlWriter = xmlWriter;
            this.commentWriter = commentWriter;
        }

        void writeStart() throws XMLStreamException {
            this.xmlWriter.writeStartDocument("UTF-8", "1.0");
            this.xmlWriter.writeStartElement("worksheet");
            this.xmlWriter.writeNamespace("xmlns", "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            this.xmlWriter.writeNamespace("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
            this.xmlWriter.writeStartElement("sheetData");
        }

        void writeEnd(String commentRId, String vmlRid, String settingRid) throws XMLStreamException {
            this.xmlWriter.writeEndElement();
            if (settingRid != null) {
                this.xmlWriter.writeStartElement("pageSetup");
                this.xmlWriter.writeAttribute("r:id", settingRid);
                this.xmlWriter.writeEndElement();
            }
            if (this.commentWriter.startWriten) {
                if (vmlRid == null) {
                    throw new IllegalStateException("vmlRid should not be null");
                }
                this.xmlWriter.writeStartElement("legacyDrawing");
                this.xmlWriter.writeAttribute("r:id", vmlRid);
                this.xmlWriter.writeEndElement();
            }
            this.xmlWriter.writeEndElement();
            this.commentWriter.writeEnd();
        }

        void writeRow(Cell[] row, int rowIndex) throws XMLStreamException {
            List<SimpleXLSXWorkbook.ModifyEntry> modificationList;
            this.rowIndex = rowIndex;
            int maxCol = 0;
            List<SimpleXLSXWorkbook.ModifyEntry> list = modificationList = Sheet.this.modifications.isEmpty() ? null : Sheet.this.modifications.get(rowIndex);
            if (modificationList != null) {
                for (SimpleXLSXWorkbook.ModifyEntry entry : modificationList) {
                    if (entry.c < maxCol) continue;
                    maxCol = entry.c;
                }
            } else if (row == EMPTY_ROW) {
                return;
            }
            if (row == EMPTY_ROW) {
                row = new Cell[maxCol + 1];
            } else if (maxCol > row.length - 1) {
                Cell[] newrow = new Cell[maxCol + 1];
                System.arraycopy(row, 0, newrow, 0, row.length);
                row = newrow;
            }
            this.xmlWriter.writeStartElement("row");
            this.xmlWriter.writeAttribute("r", String.valueOf(rowIndex + 1));
            this.xmlWriter.writeAttribute("spans", "1:" + row.length);
            if (modificationList != null) {
                for (SimpleXLSXWorkbook.ModifyEntry modification : modificationList) {
                    row[modification.c] = Sheet.this.modifyCellInternal(modification, row[modification.c]);
                }
            }
            for (int col = 0; col < row.length; ++col) {
                this.cell = row[col];
                if (this.cell == null) continue;
                if (this.cell.getR() == null) {
                    this.cell.setR(Sheet.getCellId(rowIndex, col));
                }
                this.writeCell(rowIndex, col, this.cell, this.xmlWriter);
            }
            this.xmlWriter.writeEndElement();
        }

        private void writeCell(int row, int c, Cell cell, XMLStreamWriter writer) throws XMLStreamException {
            if (cell != null) {
                writer.writeStartElement("c");
                writer.writeAttribute("r", cell.getR());
                if (cell.getS() != null) {
                    writer.writeAttribute("s", cell.getS());
                }
                if (cell.getT() != null) {
                    writer.writeAttribute("t", cell.getT());
                }
                if (cell.getV() != null) {
                    writer.writeStartElement("v");
                    writer.writeCharacters(String.valueOf(cell.getV()));
                    writer.writeEndElement();
                }
                if (cell.getComment() != null) {
                    this.commentWriter.writeComment(row, c, cell.getComment());
                }
                writer.writeEndElement();
            }
        }
    }

    public static class IteratorStatus {
        int rowIndex = -1;

        public int getRowIndex() {
            return this.rowIndex;
        }
    }
}

