/*
 * Decompiled with CFR 0.152.
 */
package com.incesoft.tools.excel.xlsx;

import com.incesoft.tools.excel.xlsx.Sheet;
import com.incesoft.tools.excel.xlsx.SimpleXLSXWorkbook;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SheetCommentWriter {
    XMLStreamWriter commentsWriter;
    XMLStreamWriter vmlWriter;
    SimpleXLSXWorkbook.XMLStreamCreator commentWriterCreator;
    SimpleXLSXWorkbook.XMLStreamCreator vmlWriterCreator;
    private String shapeTypeId = "_x0000_m1027";
    private String shapeTypeRefId = "#" + this.shapeTypeId;
    boolean startWriten = false;

    public SheetCommentWriter(SimpleXLSXWorkbook.XMLStreamCreator commentWriterCreator, SimpleXLSXWorkbook.XMLStreamCreator vmlWriterCreator) {
        this.commentWriterCreator = commentWriterCreator;
        this.vmlWriterCreator = vmlWriterCreator;
    }

    public SheetCommentWriter() {
    }

    public void writeStart() throws XMLStreamException {
        if (this.commentsWriter == null) {
            this.commentsWriter = this.commentWriterCreator.createWriter();
            this.vmlWriter = this.vmlWriterCreator.createWriter();
        }
        this.commentsWriter.writeStartDocument("UTF-8", "1.0");
        this.commentsWriter.writeStartElement("comments");
        this.commentsWriter.writeNamespace("xmlns", "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
        this.commentsWriter.writeStartElement("authors");
        this.commentsWriter.writeStartElement("author");
        this.commentsWriter.writeCharacters("sjxlsx");
        this.commentsWriter.writeEndElement();
        this.commentsWriter.writeEndElement();
        this.commentsWriter.writeStartElement("commentList");
        this.vmlWriter.writeStartElement("xml");
        this.vmlWriter.writeNamespace("xmlns", "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
        this.vmlWriter.writeNamespace("v", "urn:schemas-microsoft-com:vml");
        this.vmlWriter.writeNamespace("o", "urn:schemas-microsoft-com:office:office");
        this.vmlWriter.writeNamespace("x", "urn:schemas-microsoft-com:office:excel");
        this.vmlWriter.writeStartElement("v:shapetype");
        this.vmlWriter.writeAttribute("id", this.shapeTypeId);
        this.vmlWriter.writeAttribute("coordsize", "21600,21600");
        this.vmlWriter.writeAttribute("path", "m,l,21600r21600,l21600,xe");
        this.vmlWriter.writeEndElement();
    }

    public void writeEnd() throws XMLStreamException {
        if (this.startWriten) {
            this.commentsWriter.writeEndElement();
            this.commentsWriter.writeEndElement();
            this.vmlWriter.writeEndElement();
        }
    }

    public void writeComment(int r, int c, String comment) throws XMLStreamException {
        if (!this.startWriten) {
            this.startWriten = true;
            this.writeStart();
        }
        this.commentsWriter.writeStartElement("comment");
        this.commentsWriter.writeAttribute("ref", Sheet.getCellId(r, c));
        this.commentsWriter.writeAttribute("authorId", "0");
        this.commentsWriter.writeStartElement("text");
        this.commentsWriter.writeStartElement("r");
        this.commentsWriter.writeStartElement("t");
        if (comment.charAt(0) < ' ' || comment.charAt(comment.length() - 1) == ' ') {
            this.commentsWriter.writeAttribute("xml:space", "preserve");
        }
        this.commentsWriter.writeCharacters(comment);
        this.commentsWriter.writeEndElement();
        this.commentsWriter.writeEndElement();
        this.commentsWriter.writeEndElement();
        this.commentsWriter.writeEndElement();
        this.vmlWriter.writeStartElement("v:shape");
        this.vmlWriter.writeAttribute("type", this.shapeTypeRefId);
        this.vmlWriter.writeAttribute("fillcolor", "#ffffe1");
        this.vmlWriter.writeAttribute("o:insetmode", "auto");
        this.vmlWriter.writeStartElement("x:ClientData");
        this.vmlWriter.writeAttribute("ObjectType", "Note");
        this.vmlWriter.writeStartElement("x:Row");
        this.vmlWriter.writeCharacters(String.valueOf(r));
        this.vmlWriter.writeEndElement();
        this.vmlWriter.writeStartElement("x:Column");
        this.vmlWriter.writeCharacters(String.valueOf(c));
        this.vmlWriter.writeEndElement();
        this.vmlWriter.writeStartElement("x:Anchor");
        String anchorPoints = String.join((CharSequence)",", String.valueOf(c + 1), String.valueOf(15), String.valueOf(r), String.valueOf(15), String.valueOf(c + 1 + 2), String.valueOf(15), String.valueOf(r + 2 + new StringTokenizer(comment, "\n").countTokens()), String.valueOf(15));
        this.vmlWriter.writeCharacters(anchorPoints);
        this.vmlWriter.writeEndElement();
        this.vmlWriter.writeEndElement();
        this.vmlWriter.writeEndElement();
    }
}

