/*
 * Decompiled with CFR 0.152.
 */
package com.incesoft.tools.excel.xlsx;

import com.incesoft.tools.excel.xlsx.CellStyle;
import com.incesoft.tools.excel.xlsx.Fill;
import com.incesoft.tools.excel.xlsx.Font;
import com.incesoft.tools.excel.xlsx.RichText;
import com.incesoft.tools.excel.xlsx.SharedStringText;
import com.incesoft.tools.excel.xlsx.Sheet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class SimpleXLSXWorkbook {
    ZipFile zipfile;
    private static final String PATH_XL_RELATION = "xl/_rels/workbook.xml.rels";
    private static final String PATH_XL_RELATION_SHEETS = "xl/worksheets/_rels/sheet%d.xml.rels";
    private static final String PATH_SHAREDSTRINGS = "xl/sharedStrings.xml";
    private static final String PATH_CONTENT_TYPES = "[Content_Types].xml";
    private static List<Pattern> blackListPatterns;
    private static List<String> blackList;
    BidirectionMap sharedStrings = new BidirectionMap();
    int sharedStringLen = 0;
    XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private static final String PATH_SHEET = "xl/worksheets/sheet%d.xml";
    private static final String PATH_SHEET_COMMENT = "xl/comments%d.xml";
    private static final String PATH_SHEET_COMMENT_VMLDRAWING = "xl/drawings/vmlDrawing%d.vml";
    private static final String PATH_STYLES = "xl/styles.xml";
    private static final String STR_XML_HEAD = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
    private static final byte[] DATA_XL_WORKSHEETS__RELS_SHEET;
    List<Sheet> sheets = new ArrayList<Sheet>();
    List<Font> fonts = new ArrayList<Font>();
    List<Fill> fills = new ArrayList<Fill>();
    List<CellStyle> styles = new ArrayList<CellStyle>();
    private static final String NS_SHAREDSTRINGS = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings";
    private static final String NS_VMLDRAWING = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing";
    private static final String NS_COMMENT = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments";
    int fontsCountOffset = 0;
    int fillsCountOffset = 0;
    int stylesCountOffset = 0;
    boolean stylesCountLoaded = false;
    XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    Commiter commiter;

    private InputStream findData(String name) {
        try {
            ZipEntry entry = this.zipfile.getEntry(name);
            if (entry != null) {
                return this.zipfile.getInputStream(entry);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public SimpleXLSXWorkbook(File file) {
        try {
            this.zipfile = new ZipFile(file);
            InputStream stream = this.findData(PATH_SHAREDSTRINGS);
            if (stream != null) {
                this.parseSharedStrings(stream);
            }
            this.initSheets();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (this.zipfile != null) {
            try {
                this.zipfile.close();
                this.zipfile = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.commiter = null;
        this.sharedStrings.clear();
        this.sharedStrings = null;
        this.fills.clear();
        this.fonts.clear();
        for (Sheet s : this.sheets) {
            s.cleanUp();
        }
        this.sheets.clear();
        this.styles.clear();
    }

    private int addSharedString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null string added to SharedStrings");
        }
        Integer i = (Integer)this.sharedStrings.inverse().get(string);
        if (i != null) {
            return i;
        }
        this.sharedStrings.put((Object)this.sharedStringLen++, string);
        return this.sharedStringLen - 1;
    }

    public RichText createRichText() {
        RichText text = new RichText();
        int i = this.addRichText(text);
        text.setIndex(i);
        return text;
    }

    public SharedStringText createPlainText(String text) {
        SharedStringText sharedStringText = new SharedStringText();
        sharedStringText.setIndex(this.addSharedString(text));
        sharedStringText.setText(text);
        return sharedStringText;
    }

    private int addRichText(RichText richText) {
        if (richText == null) {
            throw new IllegalArgumentException("null rich text added to sharedStrings");
        }
        this.sharedStrings.put((Object)this.sharedStringLen++, richText);
        return this.sharedStringLen - 1;
    }

    String getSharedStringValue(int i) {
        Object obj = this.sharedStrings.get(i);
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    private String getSheetPath(int i) {
        return String.format(PATH_SHEET, i);
    }

    private String getSheetCommentPath(int i) {
        return String.format(PATH_SHEET_COMMENT, i);
    }

    private String getSheetCommentDrawingPath(int i) {
        return String.format(PATH_SHEET_COMMENT_VMLDRAWING, i);
    }

    private void parseSharedStrings(InputStream inputStream) throws Exception {
        XMLStreamReader reader = this.inputFactory.createXMLStreamReader(inputStream);
        boolean si = false;
        StringBuilder builder = new StringBuilder(100);
        block5: while (reader.hasNext()) {
            int type = reader.next();
            switch (type) {
                case 4: {
                    if (!si) continue block5;
                    builder.append(reader.getText());
                    continue block5;
                }
                case 1: {
                    if (!"si".equals(reader.getLocalName())) continue block5;
                    builder.setLength(0);
                    si = true;
                    continue block5;
                }
                case 2: {
                    if (!"si".equals(reader.getLocalName())) continue block5;
                    for (int j = builder.length() - 1; j >= 0; --j) {
                        if (builder.charAt(j) != '_' || j - 6 < 0 || builder.charAt(j - 5) != 'x' || builder.charAt(j - 6) != '_') continue;
                        builder.delete(j - 6, j + 1);
                        j -= 6;
                    }
                    this.sharedStrings.put((Object)this.sharedStringLen++, builder.toString());
                    si = false;
                    continue block5;
                }
            }
        }
    }

    XMLStreamReader getReader(String resourceId) {
        InputStream stream = this.findData(resourceId);
        if (stream == null) {
            if (resourceId.startsWith("xl/worksheets/_rels/sheet")) {
                byte[] b = new byte[DATA_XL_WORKSHEETS__RELS_SHEET.length];
                System.arraycopy(DATA_XL_WORKSHEETS__RELS_SHEET, 0, b, 0, b.length);
                stream = new ByteArrayInputStream(b);
            } else {
                throw new RuntimeException("resource not found,resourceId=" + resourceId);
            }
        }
        try {
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(stream);
            return reader;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    XMLStreamReader getSheetReader(Integer sheetId) {
        if (sheetId == null) {
            sheetId = 1;
        }
        return this.getReader(this.getSheetPath(sheetId));
    }

    XMLStreamReader getStylesReader() {
        return this.getReader(PATH_STYLES);
    }

    private void initSheets() {
        ZipEntry entry;
        int i = 0;
        while ((entry = this.zipfile.getEntry(this.getSheetPath(i + 1))) != null) {
            this.sheets.add(new Sheet(i, this));
            ++i;
        }
    }

    public Sheet createSheet() {
        Sheet sheet = new Sheet(this.sheets.size(), this);
        this.sheets.add(sheet);
        return sheet;
    }

    public int getSheetCount() {
        return this.sheets.size();
    }

    public Sheet getSheet(int i) {
        return this.getSheet(i, true);
    }

    public Sheet getSheet(int i, boolean parseAllRow) {
        if (i >= this.sheets.size()) {
            throw new IllegalArgumentException("sheet " + i + " not exists!SheetCount=" + this.sheets.size());
        }
        Sheet sheet = this.sheets.get(i);
        if (parseAllRow) {
            sheet.parseAllRows();
        } else {
            sheet.setAddToMemory(false);
        }
        return sheet;
    }

    private static void writeStart(XMLStreamReader reader, XMLStreamWriter writer, String ... attributes) throws XMLStreamException {
        int i;
        writer.writeStartElement(reader.getLocalName());
        for (i = 0; i < attributes.length; i += 2) {
            writer.writeAttribute(attributes[i], attributes[i + 1]);
        }
        if (reader != null) {
            for (i = 0; i < reader.getNamespaceCount(); ++i) {
                writer.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
            }
            for (int i2 = 0; i2 < reader.getAttributeCount(); ++i2) {
                String attName = reader.getAttributeLocalName(i2);
                if (attributes.length > 0) {
                    for (int j = 0; j < attributes.length; j += 2) {
                        if (attName.equals(attributes[j])) continue;
                        if (reader.getAttributePrefix(i2) != null && reader.getAttributePrefix(i2).length() > 0) {
                            writer.writeAttribute(reader.getAttributePrefix(i2), writer.getNamespaceContext().getNamespaceURI(reader.getAttributePrefix(i2)), reader.getAttributeLocalName(i2), reader.getAttributeValue(i2));
                            continue;
                        }
                        writer.writeAttribute(reader.getAttributeLocalName(i2), reader.getAttributeValue(i2));
                    }
                    continue;
                }
                if (reader.getAttributePrefix(i2) != null && reader.getAttributePrefix(i2).length() > 0) {
                    writer.writeAttribute(reader.getAttributePrefix(i2), writer.getNamespaceContext().getNamespaceURI(reader.getAttributePrefix(i2)), reader.getAttributeLocalName(i2), reader.getAttributeValue(i2));
                    continue;
                }
                writer.writeAttribute(reader.getAttributeLocalName(i2), reader.getAttributeValue(i2));
            }
        }
    }

    private static void writeDocumentStart(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument("UTF-8", "1.0");
    }

    private void mergeSharedStrings(XMLStreamWriter writer) throws XMLStreamException {
        SimpleXLSXWorkbook.writeDocumentStart(writer);
        writer.writeStartElement("sst");
        writer.writeNamespace("xmlns", "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
        for (int i = 0; i < this.sharedStringLen; ++i) {
            Object obj = this.sharedStrings.get(i);
            if (obj instanceof SharedStringText) {
                ((SharedStringText)obj).serialize(writer);
                continue;
            }
            try {
                writer.writeStartElement("si");
                writer.writeStartElement("t");
                writer.writeCharacters((String)obj);
                writer.writeEndElement();
                writer.writeEndElement();
                continue;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        writer.writeEndElement();
    }

    private void mergeStyles(XMLStreamWriter writer) throws XMLStreamException {
        this.prepareStylesCount();
        XMLStreamReader reader = this.getStylesReader();
        SimpleXLSXWorkbook.writeDocumentStart(writer);
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if ("fonts".equals(reader.getLocalName())) {
                        SimpleXLSXWorkbook.writeStart(reader, writer, "count", String.valueOf(this.fontsCountOffset + this.fonts.size()));
                        break;
                    }
                    if ("fills".equals(reader.getLocalName())) {
                        SimpleXLSXWorkbook.writeStart(reader, writer, "count", String.valueOf(this.fillsCountOffset + this.fills.size()));
                        break;
                    }
                    if ("cellXfs".equals(reader.getLocalName())) {
                        SimpleXLSXWorkbook.writeStart(reader, writer, "count", String.valueOf(this.stylesCountOffset + this.styles.size()));
                        break;
                    }
                    SimpleXLSXWorkbook.writeStart(reader, writer, new String[0]);
                    break;
                }
                case 2: {
                    if ("fonts".equals(reader.getLocalName())) {
                        for (Font font : this.fonts) {
                            font.serialize(writer);
                        }
                    }
                    if ("fills".equals(reader.getLocalName())) {
                        for (Fill fill : this.fills) {
                            fill.serialize(writer);
                        }
                    }
                    if ("cellXfs".equals(reader.getLocalName())) {
                        for (CellStyle cellStyle : this.styles) {
                            cellStyle.serialize(writer);
                        }
                    }
                    writer.writeEndElement();
                    break;
                }
                case 4: {
                    writer.writeCharacters(reader.getText());
                    break;
                }
            }
        }
    }

    private void mergeContentTypes(XMLStreamReader reader, XMLStreamWriter writer, String ... overrides) throws XMLStreamException {
        SimpleXLSXWorkbook.writeDocumentStart(writer);
        HashSet<String> existsTargets = new HashSet<String>();
        while (reader.hasNext()) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    if ("Override".equals(reader.getLocalName())) {
                        existsTargets.add(reader.getAttributeValue(null, "PartName"));
                    } else if ("Default".equals(reader.getLocalName())) {
                        existsTargets.add(reader.getAttributeValue(null, "Extension"));
                    }
                    SimpleXLSXWorkbook.writeStart(reader, writer, new String[0]);
                    break;
                }
                case 2: {
                    if ("Types".equals(reader.getLocalName())) {
                        for (int i = 0; i < overrides.length; i += 3) {
                            if (existsTargets.contains(overrides[i + 1])) continue;
                            writer.writeStartElement(overrides[i]);
                            if ("Override".equals(overrides[i])) {
                                writer.writeAttribute("PartName", overrides[i + 1]);
                            } else {
                                writer.writeAttribute("Extension", overrides[i + 1]);
                            }
                            writer.writeAttribute("ContentType", overrides[i + 2]);
                            writer.writeEndElement();
                        }
                    }
                    writer.writeEndElement();
                    break;
                }
                case 7: {
                    SimpleXLSXWorkbook.writeStart(reader, writer, new String[0]);
                    break;
                }
                case 4: {
                    writer.writeCharacters(reader.getText());
                    break;
                }
            }
        }
        writer.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prepareStylesCount() {
        if (this.stylesCountLoaded) {
            return;
        }
        this.stylesCountLoaded = true;
        try {
            XMLStreamReader reader = this.getStylesReader();
            block6: while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        if ("fonts".equals(reader.getLocalName())) {
                            this.fontsCountOffset = Integer.valueOf(reader.getAttributeValue(null, "count"));
                        }
                        if ("fills".equals(reader.getLocalName())) {
                            this.fillsCountOffset = Integer.valueOf(reader.getAttributeValue(null, "count"));
                        }
                        if (!"cellXfs".equals(reader.getLocalName())) break;
                        this.stylesCountOffset = Integer.valueOf(reader.getAttributeValue(null, "count"));
                        return;
                    }
                    case 2: {
                        continue block6;
                    }
                }
            }
            return;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public Font createFont() {
        return new Font();
    }

    public Fill createFill() {
        return new Fill();
    }

    public CellStyle createStyle(Font font, Fill fill) {
        if (font == null && fill == null) {
            throw new IllegalArgumentException("either font or fill is required");
        }
        if (font != null && font.getColor() == null) {
            throw new IllegalArgumentException("either font color required");
        }
        if (fill != null && fill.getFgColor() == null) {
            throw new IllegalArgumentException("either fill fgcolor required");
        }
        this.prepareStylesCount();
        int pos = -1;
        if (font != null) {
            pos = this.fonts.indexOf(font);
            if (pos == -1) {
                font.setIndex(this.fontsCountOffset + this.fonts.size());
                this.fonts.add(font);
            } else {
                font = this.fonts.get(pos);
            }
        }
        if (fill != null) {
            pos = this.fills.indexOf(fill);
            if (pos == -1) {
                fill.setIndex(this.fillsCountOffset + this.fills.size());
                this.fills.add(fill);
            } else {
                fill = this.fills.get(pos);
            }
        }
        CellStyle style = new CellStyle();
        style.setFill(fill);
        style.setFont(font);
        pos = this.styles.indexOf(style);
        if (pos == -1) {
            style.setIndex(this.stylesCountOffset + this.styles.size());
            this.styles.add(style);
        } else {
            style = this.styles.get(pos);
        }
        return style;
    }

    XMLStreamWriter newWriter(OutputStream outputStream) throws UnsupportedEncodingException, XMLStreamException {
        return this.outputFactory.createXMLStreamWriter(new OutputStreamWriter(outputStream, "UTF-8"));
    }

    public Commiter newCommiter(OutputStream output) {
        this.commiter = new Commiter(this, output);
        return this.commiter;
    }

    public void commit(OutputStream output) throws Exception {
        if (this.commiter != null) {
            throw new IllegalStateException("cannot commit again - newCommiter() or commit() has been called already.");
        }
        this.commiter = this.newCommiter(output);
        this.commiter.beginCommit();
        this.commiter.endCommit();
    }

    public static void testMergeStyles(SimpleXLSXWorkbook excel, XMLStreamWriter writer) throws Exception {
    }

    static {
        if ("false".equals(System.getProperty("ince.tools.excel.disableXMLOptimize"))) {
            System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
            System.setProperty("javax.xml.stream.XMLOutputFactory", "com.ctc.wstx.stax.WstxOutputFactory");
        }
        blackListPatterns = new ArrayList<Pattern>();
        blackList = Arrays.asList(".*comments\\d+\\.xml", ".*calcChain\\.xml", ".*drawings/vmlDrawing\\d+\\.vml");
        for (String pstr : blackList) {
            blackListPatterns.add(Pattern.compile(pstr));
        }
        DATA_XL_WORKSHEETS__RELS_SHEET = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\"></Relationships>".getBytes();
    }

    private static class BidirectionMap
    implements Map {
        private Map values = new LinkedHashMap();
        private Map inverseValues = new LinkedHashMap();

        private BidirectionMap() {
        }

        public Map inverse() {
            return this.inverseValues;
        }

        @Override
        public void clear() {
            this.values.clear();
            this.inverseValues.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        public Set entrySet() {
            throw new RuntimeException();
        }

        public Object get(Object key) {
            return this.values.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.values.isEmpty();
        }

        public Set keySet() {
            throw new RuntimeException();
        }

        public Object put(Object key, Object value) {
            this.inverseValues.put(value, key);
            return this.values.put(key, value);
        }

        public void putAll(Map m) {
            throw new RuntimeException();
        }

        public Object remove(Object key) {
            throw new RuntimeException();
        }

        @Override
        public int size() {
            return this.values.size();
        }

        public Collection values() {
            return this.values.values();
        }
    }

    public static class Commiter {
        SimpleXLSXWorkbook wb;
        HashSet<String> mergedItems = new HashSet();
        ZipOutputStream zos;
        boolean modified = false;
        XMLStreamWriter sheetWriter;
        Sheet lastCommitSheet;
        SheetCommentXMLStreamCreator commentStreamCreator;
        SheetCommentXMLStreamCreator vmlStreamCreator;

        private Commiter(SimpleXLSXWorkbook wb, OutputStream output) {
            this.wb = wb;
            this.zos = new ZipOutputStream(output);
        }

        public void beginCommit() {
        }

        public void beginCommitSheet(Sheet sheet) throws IOException, XMLStreamException {
            this.sheetWriter = this.newWriter(this.wb.getSheetPath(sheet.getSheetIndex() + 1));
            this.lastCommitSheet = sheet;
            this.commentStreamCreator = new SheetCommentXMLStreamCreator();
            this.vmlStreamCreator = new SheetCommentXMLStreamCreator();
            sheet.writeSheetStart(this.sheetWriter, this.commentStreamCreator, this.vmlStreamCreator);
        }

        public void commitSheetModifications() {
            try {
                if (this.lastCommitSheet == null) {
                    throw new IllegalStateException("plz call beginCommitSheet(Sheet) first");
                }
                this.lastCommitSheet.mergeSheet();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        public void commitSheetWrites() {
            try {
                if (this.lastCommitSheet == null) {
                    throw new IllegalStateException("plz call beginCommitSheet(Sheet) first");
                }
                this.lastCommitSheet.writeSheet();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        public void endCommitSheet() throws IOException, XMLStreamException {
            if (this.lastCommitSheet == null) {
                throw new IllegalStateException("plz call beginCommitSheet(Sheet) first");
            }
            int sheet = this.lastCommitSheet.getSheetIndex() + 1;
            String commentRid = null;
            String vmlRid = null;
            String settingRid = null;
            String relationPath = String.format(SimpleXLSXWorkbook.PATH_XL_RELATION_SHEETS, sheet);
            ByteArrayOutputStream relation_baos = new ByteArrayOutputStream();
            String[] relationsToMerge = new String[]{};
            if (this.commentStreamCreator.getWriter() != null) {
                relationsToMerge = new String[]{"../comments" + sheet + ".xml", SimpleXLSXWorkbook.NS_COMMENT, "../drawings/vmlDrawing" + sheet + ".vml", SimpleXLSXWorkbook.NS_VMLDRAWING};
            }
            XMLStreamWriter writer = this.wb.newWriter(relation_baos);
            Map<String, String> rids = new RelationShipMerger(relationsToMerge).mergeRelation(this.wb.getReader(relationPath), writer);
            writer.close();
            relation_baos.close();
            commentRid = rids.get("../comments" + sheet + ".xml");
            vmlRid = rids.get("../drawings/vmlDrawing" + sheet + ".vml");
            settingRid = rids.get("../printerSettings/printerSettings" + sheet + ".bin");
            this.lastCommitSheet.writeSheetEnd(commentRid, vmlRid, settingRid);
            this.sheetWriter.close();
            this.lastCommitSheet.clearRows();
            if (this.commentStreamCreator.getWriter() != null) {
                this.commentStreamCreator.getWriter().close();
                this.commentStreamCreator.getOutput().close();
                this.newZipEntry(this.wb.getSheetCommentPath(sheet));
                this.zos.write(this.commentStreamCreator.getOutput().toByteArray());
                this.vmlStreamCreator.getWriter().close();
                this.vmlStreamCreator.getOutput().close();
                this.newZipEntry(this.wb.getSheetCommentDrawingPath(sheet));
                this.zos.write(this.vmlStreamCreator.getOutput().toByteArray());
            }
            this.newZipEntry(relationPath);
            this.zos.write(relation_baos.toByteArray());
        }

        public void endCommit() {
            try {
                for (int i = 0; i < this.wb.sheets.size(); ++i) {
                    Sheet s = this.wb.sheets.get(i);
                    if (!s.isModified()) continue;
                    this.modified = true;
                    this.mergedItems.add(this.wb.getSheetPath(i + 1));
                }
                if (this.modified) {
                    this.commitStyles();
                    this.mergeSheets();
                    this.commitContentTypes();
                    this.commitRelation();
                    this.commitSharedStrings();
                }
                this.commitUnmodifiedStream();
                this.zos.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void newZipEntry(String path) {
            try {
                this.zos.putNextEntry(new ZipEntry(path));
                this.mergedItems.add(path);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private XMLStreamWriter newWriter(String path) {
            try {
                this.newZipEntry(path);
                return this.wb.newWriter(this.zos);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void mergeSheets() {
            try {
                for (int i = 0; i < this.wb.sheets.size(); ++i) {
                    Sheet s = this.wb.sheets.get(i);
                    if (!s.isModified() || s.isMerged()) continue;
                    this.beginCommitSheet(s);
                    s.mergeSheet();
                    this.endCommitSheet();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void commitContentTypes() {
            try {
                XMLStreamWriter writer = this.newWriter(SimpleXLSXWorkbook.PATH_CONTENT_TYPES);
                ArrayList<Object> parts = new ArrayList<Object>();
                if (this.wb.sharedStringLen > 0) {
                    parts.add("Override");
                    parts.add("/xl/sharedStrings.xml");
                    parts.add("application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml");
                }
                boolean commentModified = false;
                for (int i = 0; i < this.wb.sheets.size(); ++i) {
                    Sheet s = this.wb.sheets.get(i);
                    if (!s.isCommentModified()) continue;
                    commentModified = true;
                    parts.add("Override");
                    parts.add("/xl/comments" + (s.getSheetIndex() + 1) + ".xml");
                    parts.add("application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml");
                }
                if (commentModified) {
                    parts.add("Default");
                    parts.add("vml");
                    parts.add("application/vnd.openxmlformats-officedocument.vmlDrawing");
                }
                this.wb.mergeContentTypes(this.wb.getReader(SimpleXLSXWorkbook.PATH_CONTENT_TYPES), writer, parts.toArray(new String[parts.size()]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void commitRelation() {
            try {
                XMLStreamWriter writer = this.newWriter(SimpleXLSXWorkbook.PATH_XL_RELATION);
                if (this.wb.sharedStringLen > 0) {
                    new RelationShipMerger(new String[]{"sharedStrings.xml", SimpleXLSXWorkbook.NS_SHAREDSTRINGS}).mergeRelation(this.wb.getReader(SimpleXLSXWorkbook.PATH_XL_RELATION), writer);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void commitStyles() {
            try {
                XMLStreamWriter writer = this.newWriter(SimpleXLSXWorkbook.PATH_STYLES);
                this.wb.mergeStyles(writer);
                writer.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void commitSharedStrings() {
            try {
                XMLStreamWriter writer = this.newWriter(SimpleXLSXWorkbook.PATH_SHAREDSTRINGS);
                this.wb.mergeSharedStrings(writer);
                writer.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void commitUnmodifiedStream() throws IOException {
            Enumeration<? extends ZipEntry> entries = this.wb.zipfile.entries();
            block0: while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (this.modified && this.mergedItems.contains(entry.getName())) continue;
                for (Pattern p : blackListPatterns) {
                    if (!p.matcher(entry.getName()).matches()) continue;
                    continue block0;
                }
                this.zos.putNextEntry(new ZipEntry(entry.getName()));
                this.wb.zipfile.getInputStream(entry).transferTo(this.zos);
            }
        }

        private class SheetCommentXMLStreamCreator
        extends XMLStreamCreator {
            ByteArrayOutputStream output;

            private SheetCommentXMLStreamCreator() {
            }

            @Override
            XMLStreamReader createReaderInternal() {
                throw new RuntimeException("not implemented");
            }

            @Override
            XMLStreamWriter createWriterInternal() {
                this.output = new ByteArrayOutputStream();
                try {
                    this.writer = Commiter.this.wb.outputFactory.createXMLStreamWriter(this.output);
                    return this.writer;
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException("create xml stream writer failed", e);
                }
            }

            public ByteArrayOutputStream getOutput() {
                return this.output;
            }
        }
    }

    static abstract class XMLStreamCreator {
        protected XMLStreamWriter writer;
        protected XMLStreamReader reader;

        public XMLStreamReader createReader() throws XMLStreamException {
            this.reader = this.createReaderInternal();
            return this.reader;
        }

        abstract XMLStreamReader createReaderInternal();

        abstract XMLStreamWriter createWriterInternal();

        public XMLStreamWriter createWriter() throws XMLStreamException {
            this.writer = this.createWriterInternal();
            return this.writer;
        }

        public XMLStreamReader getReader() {
            return this.reader;
        }

        public XMLStreamWriter getWriter() {
            return this.writer;
        }
    }

    static class ModifyEntry {
        int r;
        int c;
        String comment;
        SharedStringText text;
        CellStyle style;

        public ModifyEntry(int r, int c, SharedStringText text, CellStyle style, String comment) {
            this.r = r;
            this.c = c;
            this.comment = comment;
            this.text = text;
            this.style = style;
        }

        public ModifyEntry(int r, int c, SharedStringText text, CellStyle style) {
            this.text = text;
            this.style = style;
            this.r = r;
            this.c = c;
        }
    }

    private static class RelationShipMerger {
        public String[] targets;

        public RelationShipMerger(String[] targets) {
            this.targets = targets;
        }

        public Map<String, String> mergeRelation(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
            SimpleXLSXWorkbook.writeDocumentStart(writer);
            int maxRid = 0;
            HashMap<String, String> existTargets = new HashMap<String, String>();
            while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if ("Relationship".equals(reader.getLocalName())) {
                            String ridStr = reader.getAttributeValue(null, "Id");
                            Integer rid = Integer.valueOf(ridStr.replace("rId", ""));
                            if (rid > maxRid) {
                                maxRid = rid;
                            }
                            existTargets.put(reader.getAttributeValue(null, "Target"), ridStr);
                        }
                        SimpleXLSXWorkbook.writeStart(reader, writer, new String[0]);
                        break;
                    }
                    case 2: {
                        if ("Relationships".equals(reader.getLocalName())) {
                            for (int i = 0; i < this.targets.length; i += 2) {
                                if (existTargets.containsKey(this.targets[i])) continue;
                                writer.writeStartElement("Relationship");
                                writer.writeAttribute("Type", this.targets[i + 1]);
                                writer.writeAttribute("Target", this.targets[i]);
                                writer.writeAttribute("Id", "rId" + String.valueOf(++maxRid));
                                writer.writeEndElement();
                                existTargets.put(this.targets[i], "rId" + maxRid);
                            }
                        }
                        writer.writeEndElement();
                        break;
                    }
                    case 7: {
                        SimpleXLSXWorkbook.writeStart(reader, writer, new String[0]);
                        break;
                    }
                    case 4: {
                        writer.writeCharacters(reader.getText());
                        break;
                    }
                }
            }
            writer.close();
            return existTargets;
        }
    }
}

