/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jxl.Cell;
import jxl.CellType;
import jxl.LabelCell;
import jxl.Sheet;

public class CellFinder {
    private final Sheet sheet;

    public CellFinder(Sheet s) {
        this.sheet = s;
    }

    public Cell findCell(String contents, int firstCol, int firstRow, int lastCol, int lastRow, boolean reverse) {
        Cell cell = null;
        boolean found = false;
        int numCols = lastCol - firstCol;
        int numRows = lastRow - firstRow;
        int row1 = reverse ? lastRow : firstRow;
        int row2 = reverse ? firstRow : lastRow;
        int col1 = reverse ? lastCol : firstCol;
        int col2 = reverse ? firstCol : lastCol;
        int inc = reverse ? -1 : 1;
        for (int i = 0; i <= numCols && !found; ++i) {
            for (int j = 0; j <= numRows && !found; ++j) {
                Cell c;
                int curCol = col1 + i * inc;
                int curRow = row1 + j * inc;
                if (curCol >= this.sheet.getColumns() || curRow >= this.sheet.getRows() || (c = this.sheet.getCell(curCol, curRow)).getType() == CellType.EMPTY || !c.getContents().equals(contents)) continue;
                cell = c;
                found = true;
            }
        }
        return cell;
    }

    public Cell findCell(String contents) {
        Cell cell = null;
        boolean found = false;
        for (int i = 0; i < this.sheet.getRows() && !found; ++i) {
            Cell[] row = this.sheet.getRow(i);
            for (int j = 0; j < row.length && !found; ++j) {
                if (!row[j].getContents().equals(contents)) continue;
                cell = row[j];
                found = true;
            }
        }
        return cell;
    }

    public Cell findCell(Pattern pattern, int firstCol, int firstRow, int lastCol, int lastRow, boolean reverse) {
        Cell cell = null;
        boolean found = false;
        int numCols = lastCol - firstCol;
        int numRows = lastRow - firstRow;
        int row1 = reverse ? lastRow : firstRow;
        int row2 = reverse ? firstRow : lastRow;
        int col1 = reverse ? lastCol : firstCol;
        int col2 = reverse ? firstCol : lastCol;
        int inc = reverse ? -1 : 1;
        for (int i = 0; i <= numCols && !found; ++i) {
            for (int j = 0; j <= numRows && !found; ++j) {
                Matcher m;
                Cell c;
                int curCol = col1 + i * inc;
                int curRow = row1 + j * inc;
                if (curCol >= this.sheet.getColumns() || curRow >= this.sheet.getRows() || (c = this.sheet.getCell(curCol, curRow)).getType() == CellType.EMPTY || !(m = pattern.matcher(c.getContents())).matches()) continue;
                cell = c;
                found = true;
            }
        }
        return cell;
    }

    public LabelCell findLabelCell(String contents) {
        LabelCell cell = null;
        boolean found = false;
        for (int i = 0; i < this.sheet.getRows() && !found; ++i) {
            Cell[] row = this.sheet.getRow(i);
            for (int j = 0; j < row.length && !found; ++j) {
                if (row[j].getType() != CellType.LABEL && row[j].getType() != CellType.STRING_FORMULA || !row[j].getContents().equals(contents)) continue;
                cell = (LabelCell)row[j];
                found = true;
            }
        }
        return cell;
    }
}

