/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.WritableRecordData;
import jxl.common.Logger;
import jxl.read.biff.Record;

public class ConditionalFormatRangeRecord
extends WritableRecordData {
    private static final Logger logger = Logger.getLogger(ConditionalFormatRangeRecord.class);
    private Range enclosingRange;
    private Range[] ranges;
    private int numRanges;
    private boolean initialized = false;
    private boolean modified = false;
    private final byte[] data = this.getRecord().getData();

    public ConditionalFormatRangeRecord(Record t) {
        super(t);
    }

    private void initialize() {
        this.enclosingRange = new Range();
        this.enclosingRange.firstRow = IntegerHelper.getInt(this.data[4], this.data[5]);
        this.enclosingRange.lastRow = IntegerHelper.getInt(this.data[6], this.data[7]);
        this.enclosingRange.firstColumn = IntegerHelper.getInt(this.data[8], this.data[9]);
        this.enclosingRange.lastColumn = IntegerHelper.getInt(this.data[10], this.data[11]);
        this.numRanges = IntegerHelper.getInt(this.data[12], this.data[13]);
        this.ranges = new Range[this.numRanges];
        int pos = 14;
        for (int i = 0; i < this.numRanges; ++i) {
            this.ranges[i] = new Range();
            this.ranges[i].firstRow = IntegerHelper.getInt(this.data[pos], this.data[pos + 1]);
            this.ranges[i].lastRow = IntegerHelper.getInt(this.data[pos + 2], this.data[pos + 3]);
            this.ranges[i].firstColumn = IntegerHelper.getInt(this.data[pos + 4], this.data[pos + 5]);
            this.ranges[i].lastColumn = IntegerHelper.getInt(this.data[pos + 6], this.data[pos + 7]);
            pos += 8;
        }
        this.initialized = true;
    }

    public void insertColumn(int col) {
        if (!this.initialized) {
            this.initialize();
        }
        this.enclosingRange.insertColumn(col);
        if (this.enclosingRange.modified) {
            this.modified = true;
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            this.ranges[i].insertColumn(col);
            if (!this.ranges[i].modified) continue;
            this.modified = true;
        }
    }

    public void removeColumn(int col) {
        if (!this.initialized) {
            this.initialize();
        }
        this.enclosingRange.removeColumn(col);
        if (this.enclosingRange.modified) {
            this.modified = true;
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            this.ranges[i].removeColumn(col);
            if (!this.ranges[i].modified) continue;
            this.modified = true;
        }
    }

    public void removeRow(int row) {
        if (!this.initialized) {
            this.initialize();
        }
        this.enclosingRange.removeRow(row);
        if (this.enclosingRange.modified) {
            this.modified = true;
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            this.ranges[i].removeRow(row);
            if (!this.ranges[i].modified) continue;
            this.modified = true;
        }
    }

    public void insertRow(int row) {
        if (!this.initialized) {
            this.initialize();
        }
        this.enclosingRange.insertRow(row);
        if (this.enclosingRange.modified) {
            this.modified = true;
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            this.ranges[i].insertRow(row);
            if (!this.ranges[i].modified) continue;
            this.modified = true;
        }
    }

    @Override
    public byte[] getData() {
        if (!this.modified) {
            return this.data;
        }
        byte[] d = new byte[14 + this.ranges.length * 8];
        System.arraycopy(this.data, 0, d, 0, 4);
        IntegerHelper.getTwoBytes(this.enclosingRange.firstRow, d, 4);
        IntegerHelper.getTwoBytes(this.enclosingRange.lastRow, d, 6);
        IntegerHelper.getTwoBytes(this.enclosingRange.firstColumn, d, 8);
        IntegerHelper.getTwoBytes(this.enclosingRange.lastColumn, d, 10);
        IntegerHelper.getTwoBytes(this.numRanges, d, 12);
        int pos = 14;
        for (int i = 0; i < this.ranges.length; ++i) {
            IntegerHelper.getTwoBytes(this.ranges[i].firstRow, d, pos);
            IntegerHelper.getTwoBytes(this.ranges[i].lastRow, d, pos + 2);
            IntegerHelper.getTwoBytes(this.ranges[i].firstColumn, d, pos + 4);
            IntegerHelper.getTwoBytes(this.ranges[i].lastColumn, d, pos + 6);
            pos += 8;
        }
        return d;
    }

    private static class Range {
        public int firstRow;
        public int firstColumn;
        public int lastRow;
        public int lastColumn;
        public boolean modified = false;

        public void insertColumn(int col) {
            if (col > this.lastColumn) {
                return;
            }
            if (col <= this.firstColumn) {
                ++this.firstColumn;
                this.modified = true;
            }
            if (col <= this.lastColumn) {
                ++this.lastColumn;
                this.modified = true;
            }
        }

        public void removeColumn(int col) {
            if (col > this.lastColumn) {
                return;
            }
            if (col < this.firstColumn) {
                --this.firstColumn;
                this.modified = true;
            }
            if (col <= this.lastColumn) {
                --this.lastColumn;
                this.modified = true;
            }
        }

        public void removeRow(int row) {
            if (row > this.lastRow) {
                return;
            }
            if (row < this.firstRow) {
                --this.firstRow;
                this.modified = true;
            }
            if (row <= this.lastRow) {
                --this.lastRow;
                this.modified = true;
            }
        }

        public void insertRow(int row) {
            if (row > this.lastRow) {
                return;
            }
            if (row <= this.firstRow) {
                ++this.firstRow;
                this.modified = true;
            }
            if (row <= this.lastRow) {
                ++this.lastRow;
                this.modified = true;
            }
        }
    }
}

