/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import jxl.biff.IntegerHelper;
import jxl.common.Logger;

public class DValParser {
    private static final Logger logger = Logger.getLogger(DValParser.class);
    private static final int PROMPT_BOX_VISIBLE_MASK = 1;
    private static final int PROMPT_BOX_AT_CELL_MASK = 2;
    private static final int VALIDITY_DATA_CACHED_MASK = 4;
    private boolean promptBoxVisible;
    private boolean promptBoxAtCell;
    private final boolean validityDataCached;
    private int numDVRecords;
    private final int objectId;

    public DValParser(byte[] data) {
        int options = IntegerHelper.getInt(data[0], data[1]);
        this.promptBoxVisible = (options & 1) != 0;
        this.promptBoxAtCell = (options & 2) != 0;
        this.validityDataCached = (options & 4) != 0;
        this.objectId = IntegerHelper.getInt(data[10], data[11], data[12], data[13]);
        this.numDVRecords = IntegerHelper.getInt(data[14], data[15], data[16], data[17]);
    }

    public DValParser(int objid, int num) {
        this.objectId = objid;
        this.numDVRecords = num;
        this.validityDataCached = true;
    }

    public byte[] getData() {
        byte[] data = new byte[18];
        int options = 0;
        if (this.promptBoxVisible) {
            options |= 1;
        }
        if (this.promptBoxAtCell) {
            options |= 2;
        }
        if (this.validityDataCached) {
            options |= 4;
        }
        IntegerHelper.getTwoBytes(options, data, 0);
        IntegerHelper.getFourBytes(this.objectId, data, 10);
        IntegerHelper.getFourBytes(this.numDVRecords, data, 14);
        return data;
    }

    public void dvRemoved() {
        --this.numDVRecords;
    }

    public int getNumberOfDVRecords() {
        return this.numDVRecords;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public void dvAdded() {
        ++this.numDVRecords;
    }
}

