/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import jxl.WorkbookSettings;
import jxl.biff.ByteArray;
import jxl.biff.StringHelper;
import jxl.common.Logger;

public class EncodedURLHelper {
    private static final Logger logger = Logger.getLogger(EncodedURLHelper.class);
    private static final byte msDosDriveLetter = 1;
    private static final byte sameDrive = 2;
    private static final byte endOfSubdirectory = 3;
    private static final byte parentDirectory = 4;
    private static final byte unencodedUrl = 5;

    public static byte[] getEncodedURL(String s, WorkbookSettings ws) {
        if (s.startsWith("http:")) {
            return EncodedURLHelper.getURL(s, ws);
        }
        return EncodedURLHelper.getFile(s, ws);
    }

    private static byte[] getFile(String s, WorkbookSettings ws) {
        ByteArray byteArray = new ByteArray();
        int pos = 0;
        if (s.charAt(1) == ':') {
            byteArray.add((byte)1);
            byteArray.add((byte)s.charAt(0));
            pos = 2;
        } else if (s.charAt(pos) == '\\' || s.charAt(pos) == '/') {
            byteArray.add((byte)2);
        }
        while (s.charAt(pos) == '\\' || s.charAt(pos) == '/') {
            ++pos;
        }
        while (pos < s.length()) {
            int nextSepIndex1 = s.indexOf(47, pos);
            int nextSepIndex2 = s.indexOf(92, pos);
            int nextSepIndex = 0;
            String nextFileNameComponent = null;
            if (nextSepIndex1 != -1 && nextSepIndex2 != -1) {
                nextSepIndex = Math.min(nextSepIndex1, nextSepIndex2);
            } else if (nextSepIndex1 == -1 || nextSepIndex2 == -1) {
                nextSepIndex = Math.max(nextSepIndex1, nextSepIndex2);
            }
            if (nextSepIndex == -1) {
                nextFileNameComponent = s.substring(pos);
                pos = s.length();
            } else {
                nextFileNameComponent = s.substring(pos, nextSepIndex);
                pos = nextSepIndex + 1;
            }
            if (!nextFileNameComponent.equals(".")) {
                if (nextFileNameComponent.equals("..")) {
                    byteArray.add((byte)4);
                } else {
                    byteArray.add(StringHelper.getBytes(nextFileNameComponent, ws));
                }
            }
            if (pos >= s.length()) continue;
            byteArray.add((byte)3);
        }
        return byteArray.getBytes();
    }

    private static byte[] getURL(String s, WorkbookSettings ws) {
        ByteArray byteArray = new ByteArray();
        byteArray.add((byte)5);
        byteArray.add((byte)s.length());
        byteArray.add(StringHelper.getBytes(s, ws));
        return byteArray.getBytes();
    }
}

