/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import jxl.biff.drawing.Chunk;
import jxl.biff.drawing.ChunkType;

public class PNGReader {
    private static final byte[] PNG_MAGIC_NUMBER = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private final byte[] pngData;
    private Chunk ihdr;
    private Chunk phys;
    private int pixelWidth;
    private int pixelHeight;
    private int verticalResolution;
    private int horizontalResolution;
    private int resolutionUnit;

    public PNGReader(byte[] data) {
        this.pngData = data;
    }

    public static void main(String[] args) {
        try {
            File f = new File(args[0]);
            int size = (int)f.length();
            byte[] data = new byte[size];
            FileInputStream fis = new FileInputStream(f);
            fis.read(data);
            fis.close();
            PNGReader reader = new PNGReader(data);
            reader.read();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void read() {
        int length;
        byte[] header = new byte[PNG_MAGIC_NUMBER.length];
        System.arraycopy(this.pngData, 0, header, 0, header.length);
        boolean pngFile = Arrays.equals(PNG_MAGIC_NUMBER, header);
        if (!pngFile) {
            return;
        }
        for (int pos = 8; pos < this.pngData.length; pos += length + 12) {
            length = this.getInt(this.pngData[pos], this.pngData[pos + 1], this.pngData[pos + 2], this.pngData[pos + 3]);
            ChunkType chunkType = ChunkType.getChunkType(this.pngData[pos + 4], this.pngData[pos + 5], this.pngData[pos + 6], this.pngData[pos + 7]);
            if (chunkType == ChunkType.IHDR) {
                this.ihdr = new Chunk(pos + 8, length, chunkType, this.pngData);
                continue;
            }
            if (chunkType != ChunkType.PHYS) continue;
            this.phys = new Chunk(pos + 8, length, chunkType, this.pngData);
        }
        byte[] ihdrData = this.ihdr.getData();
        this.pixelWidth = this.getInt(ihdrData[0], ihdrData[1], ihdrData[2], ihdrData[3]);
        this.pixelHeight = this.getInt(ihdrData[4], ihdrData[5], ihdrData[6], ihdrData[7]);
        if (this.phys != null) {
            byte[] physData = this.phys.getData();
            this.resolutionUnit = physData[8];
            this.horizontalResolution = this.getInt(physData[0], physData[1], physData[2], physData[3]);
            this.verticalResolution = this.getInt(physData[4], physData[5], physData[6], physData[7]);
        }
    }

    private int getInt(byte d1, byte d2, byte d3, byte d4) {
        int i1 = d1 & 0xFF;
        int i2 = d2 & 0xFF;
        int i3 = d3 & 0xFF;
        int i4 = d4 & 0xFF;
        int val = i1 << 24 | i2 << 16 | i3 << 8 | i4;
        return val;
    }

    public int getHeight() {
        return this.pixelHeight;
    }

    public int getWidth() {
        return this.pixelWidth;
    }

    public int getHorizontalResolution() {
        return this.resolutionUnit == 1 ? this.horizontalResolution : 0;
    }

    public int getVerticalResolution() {
        return this.resolutionUnit == 1 ? this.verticalResolution : 0;
    }
}

