/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.common.Logger;
import jxl.read.biff.Record;

class MulBlankRecord
extends RecordData {
    private static final Logger logger = Logger.getLogger(MulBlankRecord.class);
    private final int row;
    private final int colFirst;
    private final int colLast;
    private final int numblanks;
    private final int[] xfIndices;

    public MulBlankRecord(Record t) {
        super(t);
        byte[] data = this.getRecord().getData();
        int length = this.getRecord().getLength();
        this.row = IntegerHelper.getInt(data[0], data[1]);
        this.colFirst = IntegerHelper.getInt(data[2], data[3]);
        this.colLast = IntegerHelper.getInt(data[length - 2], data[length - 1]);
        this.numblanks = this.colLast - this.colFirst + 1;
        this.xfIndices = new int[this.numblanks];
        this.readBlanks(data);
    }

    private void readBlanks(byte[] data) {
        int pos = 4;
        for (int i = 0; i < this.numblanks; ++i) {
            this.xfIndices[i] = IntegerHelper.getInt(data[pos], data[pos + 1]);
            pos += 2;
        }
    }

    public int getRow() {
        return this.row;
    }

    public int getFirstColumn() {
        return this.colFirst;
    }

    public int getNumberOfColumns() {
        return this.numblanks;
    }

    public int getXFIndex(int index) {
        return this.xfIndices[index];
    }
}

