/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import jxl.CellType;
import jxl.NumberCell;
import jxl.biff.DoubleHelper;
import jxl.biff.FormattingRecords;
import jxl.common.Logger;
import jxl.read.biff.CellValue;
import jxl.read.biff.Record;
import jxl.read.biff.SheetImpl;

class NumberRecord
extends CellValue
implements NumberCell {
    private static final Logger logger = Logger.getLogger(NumberRecord.class);
    private static final DecimalFormat defaultFormat = new DecimalFormat("#.###");
    private final double value;
    private NumberFormat format;

    public NumberRecord(Record t, FormattingRecords fr, SheetImpl si) {
        super(t, fr, si);
        byte[] data = this.getRecord().getData();
        this.value = DoubleHelper.getIEEEDouble(data, 6);
        this.format = fr.getNumberFormat(this.getXFIndex());
        if (this.format == null) {
            this.format = defaultFormat;
        }
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public String getContents() {
        return this.format.format(this.value);
    }

    @Override
    public CellType getType() {
        return CellType.NUMBER;
    }

    @Override
    public NumberFormat getNumberFormat() {
        return this.format;
    }
}

