/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import jxl.CellFeatures;
import jxl.CellType;
import jxl.NumberCell;
import jxl.biff.FormattingRecords;
import jxl.format.CellFormat;
import jxl.read.biff.CellFeaturesAccessor;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.RowRecord;
import jxl.read.biff.SheetImpl;

class NumberValue
implements NumberCell,
CellFeaturesAccessor {
    private static final DecimalFormat defaultFormat = new DecimalFormat("#.###");
    private final int row;
    private final int column;
    private final double value;
    private NumberFormat format;
    private CellFormat cellFormat;
    private CellFeatures features;
    private final int xfIndex;
    private final FormattingRecords formattingRecords;
    private boolean initialized;
    private final SheetImpl sheet;

    public NumberValue(int r, int c, double val, int xfi, FormattingRecords fr, SheetImpl si) {
        this.row = r;
        this.column = c;
        this.value = val;
        this.format = defaultFormat;
        this.xfIndex = xfi;
        this.formattingRecords = fr;
        this.sheet = si;
        this.initialized = false;
    }

    @Override
    public final int getRow() {
        return this.row;
    }

    @Override
    public final int getColumn() {
        return this.column;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public String getContents() {
        return this.format.format(this.value);
    }

    @Override
    public CellType getType() {
        return CellType.NUMBER;
    }

    @Override
    public CellFormat getCellFormat() {
        if (!this.initialized) {
            this.cellFormat = this.formattingRecords.getXFRecord(this.xfIndex);
            this.initialized = true;
        }
        return this.cellFormat;
    }

    @Override
    public boolean isHidden() {
        ColumnInfoRecord cir = this.sheet.getColumnInfo(this.column);
        if (cir != null && cir.getWidth() == 0) {
            return true;
        }
        RowRecord rr = this.sheet.getRowInfo(this.row);
        return rr != null && (rr.getRowHeight() == 0 || rr.isCollapsed());
    }

    @Override
    public NumberFormat getNumberFormat() {
        return this.format;
    }

    final void setNumberFormat(NumberFormat f) {
        if (f != null) {
            this.format = f;
        }
    }

    @Override
    public CellFeatures getCellFeatures() {
        return this.features;
    }

    @Override
    public void setCellFeatures(CellFeatures cf) {
        this.features = cf;
    }
}

