/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.biff.DoubleHelper;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.Type;
import jxl.common.Logger;
import jxl.read.biff.Record;

public class SetupRecord
extends RecordData {
    private static final Logger logger = Logger.getLogger(SetupRecord.class);
    private final byte[] data;
    private final boolean portraitOrientation;
    private final boolean pageOrder;
    private final double headerMargin;
    private final double footerMargin;
    private final int paperSize;
    private final int scaleFactor;
    private final int pageStart;
    private final int fitWidth;
    private final int fitHeight;
    private final int horizontalPrintResolution;
    private final int verticalPrintResolution;
    private final int copies;
    private final boolean initialized;

    SetupRecord(Record t) {
        super(Type.SETUP);
        this.data = t.getData();
        this.paperSize = IntegerHelper.getInt(this.data[0], this.data[1]);
        this.scaleFactor = IntegerHelper.getInt(this.data[2], this.data[3]);
        this.pageStart = IntegerHelper.getInt(this.data[4], this.data[5]);
        this.fitWidth = IntegerHelper.getInt(this.data[6], this.data[7]);
        this.fitHeight = IntegerHelper.getInt(this.data[8], this.data[9]);
        this.horizontalPrintResolution = IntegerHelper.getInt(this.data[12], this.data[13]);
        this.verticalPrintResolution = IntegerHelper.getInt(this.data[14], this.data[15]);
        this.copies = IntegerHelper.getInt(this.data[32], this.data[33]);
        this.headerMargin = DoubleHelper.getIEEEDouble(this.data, 16);
        this.footerMargin = DoubleHelper.getIEEEDouble(this.data, 24);
        int grbit = IntegerHelper.getInt(this.data[10], this.data[11]);
        this.pageOrder = (grbit & 1) != 0;
        this.portraitOrientation = (grbit & 2) != 0;
        this.initialized = (grbit & 4) == 0;
    }

    public boolean isPortrait() {
        return this.portraitOrientation;
    }

    public boolean isRightDown() {
        return this.pageOrder;
    }

    public double getHeaderMargin() {
        return this.headerMargin;
    }

    public double getFooterMargin() {
        return this.footerMargin;
    }

    public int getPaperSize() {
        return this.paperSize;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public int getPageStart() {
        return this.pageStart;
    }

    public int getFitWidth() {
        return this.fitWidth;
    }

    public int getFitHeight() {
        return this.fitHeight;
    }

    public int getHorizontalPrintResolution() {
        return this.horizontalPrintResolution;
    }

    public int getVerticalPrintResolution() {
        return this.verticalPrintResolution;
    }

    public int getCopies() {
        return this.copies;
    }

    public boolean getInitialized() {
        return this.initialized;
    }
}

