/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.SheetSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;

class Window2Record
extends WritableRecordData {
    private final byte[] data;

    public Window2Record(SheetSettings settings) {
        super(Type.WINDOW2);
        int options = 0;
        options |= 0;
        if (settings.getShowGridLines()) {
            options |= 2;
        }
        options |= 4;
        options |= 0;
        if (settings.getDisplayZeroValues()) {
            options |= 0x10;
        }
        options |= 0x20;
        options |= 0x80;
        if (settings.getHorizontalFreeze() != 0 || settings.getVerticalFreeze() != 0) {
            options |= 8;
            options |= 0x100;
        }
        if (settings.isSelected()) {
            options |= 0x600;
        }
        if (settings.getPageBreakPreviewMode()) {
            options |= 0x800;
        }
        this.data = new byte[18];
        IntegerHelper.getTwoBytes(options, this.data, 0);
        IntegerHelper.getTwoBytes(64, this.data, 6);
        IntegerHelper.getTwoBytes(settings.getPageBreakPreviewMagnification(), this.data, 10);
        IntegerHelper.getTwoBytes(settings.getNormalMagnification(), this.data, 12);
    }

    @Override
    public byte[] getData() {
        return this.data;
    }
}

