/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.datastructures.xslx;

import com.incesoft.tools.excel.support.CellFormat;
import com.incesoft.tools.excel.support.XLSWriterSupport;
import com.incesoft.tools.excel.support.XLSXWriterSupport;
import java.io.File;
import java.io.OutputStream;

public abstract class WriterSupport {
    public static final int TYPE_XLS = 1;
    public static final int TYPE_XLSX = 2;
    protected File file;
    protected OutputStream output;
    protected int rowpos = this.getMaxRowNumOfSheet();
    protected int sheetIndex = -1;

    public void setFile(File file) {
        this.file = file;
    }

    public void setOutputStream(OutputStream output) {
        this.output = output;
    }

    protected abstract int getMaxRowNumOfSheet();

    public abstract void open();

    public abstract void createNewSheet();

    public abstract void writeRow(String[] var1);

    public abstract void writeRow(String[] var1, CellFormat[] var2);

    public abstract void close();

    public static WriterSupport newInstance(int type, File f) {
        WriterSupport support = null;
        support = type == 2 ? new XLSXWriterSupport() : new XLSWriterSupport();
        support.setFile(f);
        return support;
    }

    public static WriterSupport newInstance(int type, OutputStream outputStream) {
        WriterSupport support = null;
        support = type == 2 ? new XLSXWriterSupport() : new XLSWriterSupport();
        support.setOutputStream(outputStream);
        return support;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public int getRowPos() {
        return this.rowpos;
    }

    public void increaseRow() {
        ++this.rowpos;
        if (this.rowpos > this.getMaxRowNumOfSheet()) {
            ++this.sheetIndex;
            this.createNewSheet();
            this.rowpos = -1;
        }
    }
}

