/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.interlibrary.elasticsearch;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.xbib.content.settings.Settings;
import org.xbib.elx.api.SearchClient;
import org.xbib.interlibrary.action.avail.AbstractAvailService;
import org.xbib.interlibrary.action.avail.AvailRequest;
import org.xbib.interlibrary.action.avail.AvailResponse;
import org.xbib.interlibrary.api.action.Response;
import org.xbib.interlibrary.api.service.ServiceArguments;
import org.xbib.interlibrary.common.util.LinkedHashSetMultiMap;
import org.xbib.interlibrary.common.util.MultiMap;

public class ElasticsearchAvailService
extends AbstractAvailService {
    private static final Logger logger = Logger.getLogger(ElasticsearchAvailService.class.getName());
    private final String manifestationsIndex;
    private final String manifestationsType;
    private final String partsIndex;
    private final String partsType;
    private final String holdingsIndex;
    private final String holdingsType;
    private final String servicesIndex;
    private final String servicesType;
    private final String serialIndex;
    private final String monographIndex;
    private final AtomicBoolean closed;
    private final SearchClient searchClient;

    public ElasticsearchAvailService(Settings settings, ServiceArguments arguments, SearchClient searchClient) {
        super(settings, arguments);
        this.manifestationsIndex = settings.get("manifestations.index", "fixm");
        this.manifestationsType = settings.get("manifestations.type", "manifestations");
        this.partsIndex = settings.get("parts.index", "fixp");
        this.partsType = settings.get("parts.type", "parts");
        this.holdingsIndex = settings.get("holdings.index", "fixh");
        this.holdingsType = settings.get("holdings.type", "holdings");
        this.servicesIndex = settings.get("services.index", "fixs");
        this.servicesType = settings.get("services.type", "services");
        this.serialIndex = settings.get("serial.index", "zdb");
        this.monographIndex = settings.get("monograph.index", "aleph");
        this.searchClient = searchClient;
        this.closed = new AtomicBoolean(false);
    }

    public String getName() {
        return "elasticsearch";
    }

    public AvailResponse execute(AvailRequest availRequest) {
        AvailResponse response;
        this.ensureOpen();
        try {
            AvailRequest validatedRequest = availRequest.isValidated() != false ? availRequest : this.validate(availRequest);
            response = new AvailResponse(validatedRequest, Response.Status.OK, this.getDomain(), null);
            LinkedHashSetMultiMap multiMap = new LinkedHashSetMultiMap();
            String source = validatedRequest.getBibliographicDescription().getSource();
            String sourceId = validatedRequest.getBibliographicDescription().getSourceId();
            Integer year = availRequest.getBibliographicDescription().getYear();
            if (source != null) {
                switch (source.toLowerCase(Locale.ROOT)) {
                    case "hbz": {
                        this.fetchHBZ(validatedRequest, response, (MultiMap<String, Map<String, Object>>)multiMap, sourceId, year);
                        break;
                    }
                    case "zdb": {
                        this.fetchZDB(validatedRequest, response, (MultiMap<String, Map<String, Object>>)multiMap, sourceId, year);
                        break;
                    }
                    case "issn": {
                        this.fetchISSN(validatedRequest, response, (MultiMap<String, Map<String, Object>>)multiMap, sourceId, year);
                        break;
                    }
                    case "isbn": {
                        this.fetchISBN(validatedRequest, response, (MultiMap<String, Map<String, Object>>)multiMap, sourceId, year);
                        break;
                    }
                    default: {
                        response.setStatus(Response.Status.ERROR, "can not perform avail request for source: " + source);
                        break;
                    }
                }
            } else {
                response.setStatus(Response.Status.ERROR, "can not perform avail request without source ");
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, t.getMessage(), t);
            }
            return new AvailResponse(availRequest, Response.Status.ERROR, null, t.getMessage());
        }
        return response;
    }

    private void fetchHBZ(AvailRequest request, AvailResponse response, MultiMap<String, Map<String, Object>> multiMap, String hbzId, Integer year) {
        List servicesIds;
        Map map;
        Optional optionalGetResponseHoldings;
        StringBuilder holdingsId = new StringBuilder(hbzId);
        if (year != null && year > 0) {
            holdingsId.append('.').append(year);
        }
        if ((optionalGetResponseHoldings = this.searchClient.get(grb -> ((GetRequestBuilder)grb.setIndex(this.holdingsIndex)).setType(this.holdingsType).setId(holdingsId.toString()))).isEmpty()) {
            holdingsId.setLength(0);
            holdingsId.append(hbzId);
            optionalGetResponseHoldings = this.searchClient.get(grb -> ((GetRequestBuilder)grb.setIndex(this.holdingsIndex)).setType(this.holdingsType).setId(holdingsId.toString()));
        }
        if (optionalGetResponseHoldings.isEmpty()) {
            response.setStatus(Response.Status.ERROR, "HBZ ID " + hbzId + " does not exist as manifestation");
            return;
        }
        Optional optionalGetResponse = this.searchClient.get(grb -> ((GetRequestBuilder)grb.setIndex(this.manifestationsIndex)).setType(this.manifestationsType).setId(hbzId));
        if (optionalGetResponse.isEmpty()) {
            optionalGetResponse = this.searchClient.get(grb -> ((GetRequestBuilder)grb.setIndex(this.partsIndex)).setType(this.partsType).setId(hbzId));
        }
        Map map2 = map = optionalGetResponse.isPresent() ? ((GetResponse)optionalGetResponse.get()).getSource() : Collections.emptyMap();
        if (map.containsKey("openaccess")) {
            Collection issns;
            response.getMeta().put("openaccess", map.get("openaccess"));
            if (map.containsKey("prism:issn") && !(issns = (Collection)map.get("prism:issn")).isEmpty()) {
                response.getMeta().put("issn", new StringBuilder((String)issns.iterator().next()).insert(4, '-').toString().toUpperCase(Locale.ROOT));
            }
        }
        if (map.containsKey("green")) {
            response.getMeta().put("green", map.get("green"));
        }
        if (map.containsKey("link")) {
            response.getMeta().put("link", map.get("link"));
        }
        if (request.isBibliographicDescriptionEnabled().booleanValue()) {
            Optional searchResponse = this.searchClient.search(searchRequestBuilder -> searchRequestBuilder.setIndices(new String[]{this.monographIndex}).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"RecordIdentifier.identifierForTheRecord", (Object)hbzId)).setSize(1));
            if (searchResponse.isPresent()) {
                SearchHit searchHit = ((SearchResponse)searchResponse.get()).getHits().getHits()[0];
                response.getBibliographicDescription().putAll(searchHit.getSource());
            } else if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "bibliographic description not found for: " + hbzId);
            }
        }
        if ((servicesIds = (List)((GetResponse)optionalGetResponseHoldings.get()).getSource().get("service")) != null) {
            this.toServices(servicesIds, "HBZ", hbzId, multiMap);
        }
        if (!multiMap.isEmpty()) {
            this.toResult(request, response, multiMap);
        } else {
            response.setStatus(Response.Status.ERROR, "no services for HBZ ID " + hbzId);
        }
    }

    private void fetchZDB(AvailRequest request, AvailResponse response, MultiMap<String, Map<String, Object>> multiMap, String zdbId, Integer year) {
        Optional getResponseOptional = this.searchClient.get(grb -> ((GetRequestBuilder)grb.setIndex(this.manifestationsIndex)).setType(this.manifestationsType).setId(zdbId));
        if (getResponseOptional.isEmpty()) {
            response.setStatus(Response.Status.ERROR, "ZDB ID " + zdbId + " does not exist as manifestation");
            return;
        }
        Map map = ((GetResponse)getResponseOptional.get()).getSource();
        if (map.containsKey("openaccess")) {
            response.getMeta().put("openaccess", map.get("openaccess"));
            Collection issns = (Collection)map.get("prism:issn");
            if (issns != null && !issns.isEmpty()) {
                response.getMeta().put("issn", new StringBuilder((String)issns.iterator().next()).insert(4, '-').toString().toUpperCase(Locale.ROOT));
            }
        }
        if (map.containsKey("green")) {
            response.getMeta().put("green", map.get("green"));
        }
        if (map.containsKey("link")) {
            response.getMeta().put("link", map.get("link"));
        }
        if (request.isBibliographicDescriptionEnabled().booleanValue()) {
            Optional searchResponseOptional = this.searchClient.search(qrb -> qrb.setIndices(new String[]{this.serialIndex}).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"IdentifierZDB.identifierZDB", (Object)zdbId)).setSize(1));
            if (searchResponseOptional.isPresent()) {
                SearchHit searchHit = ((SearchResponse)searchResponseOptional.get()).getHits().getHits()[0];
                response.getBibliographicDescription().putAll(searchHit.getSource());
            } else {
                response.setStatus(Response.Status.ERROR, "no bibliographic description for ZDB ID " + zdbId);
            }
        }
        StringBuilder holdingsId = new StringBuilder(zdbId);
        if (year != null && year > 0) {
            holdingsId.append('.').append(year);
        }
        getResponseOptional = this.searchClient.get(grb -> ((GetRequestBuilder)grb.setIndex(this.holdingsIndex)).setType(this.holdingsType).setId(holdingsId.toString()));
        List servicesIds = null;
        if (getResponseOptional.isPresent()) {
            servicesIds = (List)((GetResponse)getResponseOptional.get()).getSource().get("service");
        } else {
            response.setStatus(Response.Status.ERROR, "ZDB ID does not exist: " + this.holdingsIndex + "/" + this.holdingsType + "/" + holdingsId);
        }
        if (servicesIds != null) {
            this.toServices(servicesIds, "ZDB", zdbId, multiMap);
            if (!multiMap.isEmpty()) {
                this.toResult(request, response, multiMap);
            } else {
                response.setStatus(Response.Status.EMPTY, "no services for ZDB ID " + zdbId);
            }
        }
    }

    private void fetchISSN(AvailRequest request, AvailResponse response, MultiMap<String, Map<String, Object>> multiMap, String issn, Integer year) {
        Optional searchResponseOptional;
        String cleanIssn = issn != null ? issn : request.getBibliographicDescription().getIssn();
        cleanIssn = cleanIssn.toLowerCase(Locale.ROOT).trim().replace("-", "");
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        MatchQueryBuilder issnQuery = QueryBuilders.matchQuery((String)"prism:issn", (Object)cleanIssn);
        ExistsQueryBuilder notVolumeQuery = QueryBuilders.existsQuery((String)"volume");
        queryBuilder.mustNot((QueryBuilder)notVolumeQuery).must((QueryBuilder)issnQuery);
        if (request.getBibliographicDescription().getYear() != null) {
            RangeQueryBuilder dateQuery = QueryBuilders.rangeQuery((String)"dc:date").lte((Object)request.getBibliographicDescription().getYear());
            queryBuilder.must((QueryBuilder)dateQuery);
        }
        if ((searchResponseOptional = this.searchClient.search(qrb -> qrb.setIndices(new String[]{this.manifestationsIndex}).setQuery((QueryBuilder)queryBuilder))).isPresent()) {
            SearchHit searchHit = ((SearchResponse)searchResponseOptional.get()).getHits().getHits()[0];
            String zdbId = searchHit.getId();
            String otherZdbId = (String)searchHit.getSource().get("zdb");
            if (otherZdbId != null) {
                zdbId = otherZdbId;
            }
            this.fetchZDB(request, response, multiMap, zdbId, year);
        }
    }

    private void fetchISBN(AvailRequest request, AvailResponse response, MultiMap<String, Map<String, Object>> multiMap, String isbn, Integer year) {
        Optional searchResponseOptional;
        String cleanIsbn = isbn != null ? isbn : request.getBibliographicDescription().getIsbn();
        cleanIsbn = cleanIsbn.toLowerCase(Locale.ROOT).trim().replace("-", "");
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        MatchQueryBuilder isbnQuery = QueryBuilders.matchQuery((String)"prism:isbn", (Object)cleanIsbn);
        queryBuilder.must((QueryBuilder)isbnQuery);
        if (year != null) {
            RangeQueryBuilder dateQuery = QueryBuilders.rangeQuery((String)"dc:date").lte((Object)request.getBibliographicDescription().getYear());
            queryBuilder.must((QueryBuilder)dateQuery);
        }
        if ((searchResponseOptional = this.searchClient.search(qrb -> qrb.setIndices(new String[]{this.manifestationsIndex}).setQuery((QueryBuilder)queryBuilder))).isPresent()) {
            SearchHit searchHit = ((SearchResponse)searchResponseOptional.get()).getHits().getHits()[0];
            String hbzId = searchHit.getId();
            String otherHbzId = (String)searchHit.getSource().get("hbz");
            if (otherHbzId != null) {
                hbzId = otherHbzId;
            }
            this.fetchHBZ(request, response, multiMap, hbzId, year);
        }
    }

    private void toServices(List<String> serviceIds, String source, String sourceId, MultiMap<String, Map<String, Object>> multiMap) {
        if (serviceIds == null || serviceIds.isEmpty()) {
            return;
        }
        Optional multiGetResponseOptional = this.searchClient.multiGet(mgrb -> {
            for (String serviceID : serviceIds) {
                mgrb.add(this.servicesIndex, this.servicesType, serviceID);
            }
        });
        if (multiGetResponseOptional.isPresent()) {
            for (MultiGetItemResponse multiGetItemResponse : (MultiGetResponse)multiGetResponseOptional.get()) {
                if (!multiGetItemResponse.isFailed()) {
                    String id = multiGetItemResponse.getResponse().getId();
                    if (multiGetItemResponse.getResponse().getSource() != null) {
                        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>(multiGetItemResponse.getResponse().getSource());
                        int pos1 = id.indexOf(40);
                        int pos2 = id.indexOf(41);
                        String isil = id.substring(pos1 + 1, pos2);
                        m.put("_id", id);
                        m.put("source", source);
                        m.put("sourceid", sourceId);
                        m.put("isil", isil);
                        multiMap.put((Object)isil, m);
                        continue;
                    }
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.log(Level.WARNING, "no document: " + multiGetItemResponse.getResponse().getId());
                    continue;
                }
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "failed: " + multiGetItemResponse.getResponse().getId(), multiGetItemResponse.getFailure().getFailure());
            }
        }
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.searchClient.close();
        }
    }

    private void ensureOpen() {
        if (this.closed.get()) {
            throw new IllegalStateException("closed");
        }
    }

    public String toString() {
        return this.getName();
    }
}

