/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.interlibrary.elasticsearch;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.xbib.elx.api.SearchClient;
import org.xbib.interlibrary.api.Domain;
import org.xbib.interlibrary.api.InterlibraryConfigurationArguments;
import org.xbib.interlibrary.api.Library;
import org.xbib.interlibrary.api.LibraryNotificationAddress;
import org.xbib.interlibrary.api.LibraryPostalAddress;
import org.xbib.interlibrary.api.LibrarySenderAddress;
import org.xbib.interlibrary.api.Place;
import org.xbib.interlibrary.common.DefaultDomain;
import org.xbib.interlibrary.common.DefaultInterlibraryConfiguration;
import org.xbib.interlibrary.common.DefaultLibrary;
import org.xbib.interlibrary.common.DefaultLibraryNotificationAddress;
import org.xbib.interlibrary.common.DefaultLibraryPostalAddress;
import org.xbib.interlibrary.common.DefaultLibrarySenderAddress;
import org.xbib.interlibrary.common.DefaultPlace;
import org.xbib.interlibrary.common.util.MapHelper;

public class ElasticsearchInterlibraryConfiguration
extends DefaultInterlibraryConfiguration {
    private static final Logger logger = Logger.getLogger(ElasticsearchInterlibraryConfiguration.class.getName());
    private final SearchClient searchClient;
    private final AtomicBoolean closed;

    public ElasticsearchInterlibraryConfiguration(InterlibraryConfigurationArguments arguments, SearchClient searchClient) throws IOException {
        super(arguments);
        this.searchClient = searchClient;
        this.closed = new AtomicBoolean(false);
        Stream searchHitStream = searchClient.search(srb -> srb.setIndices(new String[]{"bibdat"}), TimeValue.timeValueMinutes((long)1L), 1000);
        searchHitStream.forEach(this::process);
        super.addCustomLibraries();
        super.completeLibrarySetup();
        super.createLibraryRules();
        logger.log(Level.INFO, "libraries configured = " + this.getLibraries().size());
    }

    private void process(SearchHit hit) {
        String state;
        String type;
        String isil;
        Map m = hit.getSource();
        String string = isil = m.containsKey("Identifier") ? (String)((Map)m.get("Identifier")).get("identifierAuthorityISIL") : null;
        if (isil == null) {
            return;
        }
        String string2 = type = m.containsKey("Organization") ? (String)((Map)m.get("Organization")).get("organizationType") : null;
        if (type == null) {
            return;
        }
        String string3 = state = m.containsKey("Organization") ? (String)((Map)m.get("Organization")).get("organizationState") : null;
        if (state == null) {
            return;
        }
        if ("Adresse".equals(state)) {
            switch (type) {
                case "Nationalbibliothek": {
                    boolean lastResort = !isil.equals("DE-12") && !isil.equals("DE-1a");
                    Library library = this.newLibrary(m, isil, false, lastResort);
                    this.addLibrary(isil, library);
                    break;
                }
                case "Regionalbibliothek": 
                case "Zentrale Fachbibliothek": 
                case "Verbundsystem/ -katalog": 
                case "Wissenschaftliche Spezialbibliothek": 
                case "\u00d6ffentliche Bibliothek": 
                case "\u00d6ffentliche Bibliothek f\u00fcr besondere Benutzergruppen": 
                case "Mediathek": 
                case "Zentrale Hochschulbibliothek, nicht Universit\u00e4t": 
                case "Zentrale Universit\u00e4tsbibliothek": {
                    Library library = this.newLibrary(m, isil, false, false);
                    this.addLibrary(isil, library);
                    if (!"DE-634".equals(isil)) break;
                    this.addLibrary("DE-Co1", library);
                    break;
                }
                case "Abteilungsbibliothek, Institutsbibliothek, Fachbereichsbibliothek (Universit\u00e4t)": 
                case "Abteilungsbibliothek, Fachbereichsbibliothek (Hochschule, nicht Universit\u00e4t)": {
                    Library library = this.newLibrary(m, isil, true, false);
                    this.addLibrary(isil, library);
                    break;
                }
                default: {
                    if (!logger.isLoggable(Level.FINEST)) break;
                    logger.log(Level.FINEST, "unknown: library organization type is " + type + " for " + isil);
                }
            }
        }
    }

    private Library newLibrary(Map<String, Object> map, String isil, boolean subLibrary, boolean lastResort) {
        String name;
        String string = name = map.containsKey("ShortName") ? (String)((Map)map.get("ShortName")).get("name") : null;
        if (name == null && map.containsKey("code")) {
            Object o = map.get("code");
            if (o instanceof List) {
                o = ((List)o).get(0);
            }
            name = (String)((Map)o).get("name");
        }
        String fullName = ElasticsearchInterlibraryConfiguration.extractFullName(map);
        if (map.containsKey("LibraryService")) {
            String sigel;
            DefaultLibrary library = new DefaultLibrary();
            String string2 = sigel = map.containsKey("Identifier") ? (String)((Map)map.get("Identifier")).get("identifierAuthoritySigel") : null;
            if (sigel != null) {
                this.addNormalizedIdentifier(sigel, isil);
            }
            List<String> legacyCodes = this.extractLegacyCodes(map);
            for (String legacyCode : legacyCodes) {
                this.addLegacy(legacyCode, isil);
            }
            String zip = ElasticsearchInterlibraryConfiguration.extractLocationZip(map);
            String place = ElasticsearchInterlibraryConfiguration.extractLocationPlace(map);
            Boolean isPublic = ElasticsearchInterlibraryConfiguration.extractIsPublic(map);
            library.setISIL(isil);
            library.setAliases(legacyCodes);
            library.setName(name);
            library.setFullName(fullName);
            library.setPlace((Place)new DefaultPlace(zip, place, isPublic.booleanValue()));
            library.setSubLibrary(subLibrary);
            if (lastResort) {
                library.setLastResort(true);
            }
            library.setSenderAddress(ElasticsearchInterlibraryConfiguration.extractSenderAddress(map, "Fernleihe"));
            library.setNotificationAddress(ElasticsearchInterlibraryConfiguration.extractNotificationAddress(map, "Fernleihe"));
            library.setPostalAddress(ElasticsearchInterlibraryConfiguration.extractPostalAddress(map, "Fernleihe"));
            library.setActiveEmail(ElasticsearchInterlibraryConfiguration.extractEmail(map, "active"));
            library.setPassiveEmail(ElasticsearchInterlibraryConfiguration.extractEmail(map, "passive"));
            library.setReservationEmail(ElasticsearchInterlibraryConfiguration.extractEmail(map, "reservation"));
            library.setRaw(map);
            List<Object> libraryService = map.get("LibraryService");
            if (!(libraryService instanceof List)) {
                libraryService = Collections.singletonList(libraryService);
            }
            List libraryServices = libraryService;
            for (Map m : libraryServices) {
                String serviceName = (String)m.get("libraryServiceName");
                String serviceOrganization = (String)m.get("libraryServiceOrganization");
                String serviceDomain = (String)m.get("libraryServiceDomain");
                if (serviceDomain == null) {
                    serviceDomain = (String)m.get("libraryServiceRegion");
                }
                library.setInterlibrary("\u00dcLV".equals(serviceName));
                if (serviceDomain == null) continue;
                library.setDomain((Domain)new DefaultDomain(serviceDomain, serviceOrganization));
            }
            return library;
        }
        return null;
    }

    private static String extractFullName(Map<String, Object> map) {
        if (!map.containsKey("code")) {
            return null;
        }
        List<Object> o = map.get("code");
        if (!(o instanceof Collection)) {
            o = o != null ? Collections.singletonList(o) : Collections.emptyList();
        }
        for (Map m : (Collection)o) {
            if (!m.containsKey("name")) continue;
            return (String)m.get("name");
        }
        return null;
    }

    private static String extractLocationZip(Map<String, Object> map) {
        if (!map.containsKey("LocationTypePostal")) {
            return null;
        }
        List<Object> o = map.get("LocationTypePostal");
        if (!(o instanceof Collection)) {
            o = o != null ? Collections.singletonList(o) : Collections.emptyList();
        }
        for (Map m : (Collection)o) {
            if (!m.containsKey("locationZipCode")) continue;
            return (String)m.get("locationZipCode");
        }
        return null;
    }

    private static String extractLocationPlace(Map<String, Object> map) {
        if (!map.containsKey("LocationTypePostal")) {
            return null;
        }
        List<Object> o = map.get("LocationTypePostal");
        if (!(o instanceof Collection)) {
            o = o != null ? Collections.singletonList(o) : Collections.emptyList();
        }
        for (Map m : (Collection)o) {
            if (!m.containsKey("locationPlace")) continue;
            return (String)m.get("locationPlace");
        }
        return null;
    }

    private static Boolean extractIsPublic(Map<String, Object> map) {
        if (!map.containsKey("LocationTypePostal")) {
            return Boolean.FALSE;
        }
        List<Object> o = map.get("LocationTypePostal");
        if (!(o instanceof Collection)) {
            o = o != null ? Collections.singletonList(o) : Collections.emptyList();
        }
        for (Map m : (Collection)o) {
            if (!m.containsKey("isPublic")) continue;
            return Boolean.valueOf((String)m.get("isPublic"));
        }
        return Boolean.FALSE;
    }

    private List<String> extractLegacyCodes(Map<String, Object> map) {
        ArrayList<String> list = new ArrayList<String>();
        if (map.containsKey("FormerOrganization")) {
            List<Object> o = map.get("FormerOrganization");
            if (!(o instanceof List)) {
                o = o != null ? Collections.singletonList(o) : Collections.emptyList();
            }
            for (Map mm : (List)o) {
                if (mm.containsKey("formerIdentifierAuthoritySigel")) {
                    String formerSigel = (String)mm.get("formerIdentifierAuthoritySigel");
                    list.add(formerSigel);
                }
                if (!mm.containsKey("formerIdentifierAuthorityISIL")) continue;
                String formerISIL = (String)mm.get("formerIdentifierAuthorityISIL");
                list.add(formerISIL);
            }
        }
        return list;
    }

    private static LibrarySenderAddress extractSenderAddress(Map<String, Object> map, String typeName) {
        Object o;
        DefaultLibrarySenderAddress address = new DefaultLibrarySenderAddress();
        if (map.containsKey("code")) {
            address.setName(MapHelper.getString(map, (String)"code.name"));
            address.setShortName(MapHelper.getString(map, (String)"ShortName.name"));
        }
        if (!((o = map.get("LocationTypePostal")) instanceof List)) {
            o = o != null ? Collections.singletonList(o) : Collections.emptyList();
        }
        for (Map location : (List)o) {
            if (!location.containsKey("locationStreet") || address.getStreet() != null) continue;
            address.setStreet((String)location.get("locationStreet"));
            address.setZipCode((String)location.get("locationZipCode"));
            address.setPlace((String)location.get("locationPlace"));
        }
        boolean found = false;
        o = map.get("Connection");
        if (!(o instanceof List)) {
            o = o != null ? Collections.singletonList(o) : Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        Iterator<Object> iterator = o.iterator();
        while (iterator.hasNext()) {
            Map connection = (Map)iterator.next();
            if (typeName == null || !typeName.equals(connection.get("connectionTypeName")) || !connection.containsKey("email")) continue;
            list.add((String)connection.get("email"));
            found = true;
        }
        if (found) {
            address.setEmail(list);
        } else {
            o = map.get("Connection");
            if (!(o instanceof List)) {
                o = o != null ? Collections.singletonList(o) : Collections.emptyList();
            }
            for (Map connection : (List)o) {
                if (connection.containsKey("connectionTypeName") || !connection.containsKey("email")) continue;
                list.add((String)connection.get("email"));
            }
            if (!list.isEmpty()) {
                address.setEmail(list);
            }
        }
        return address;
    }

    private static LibraryNotificationAddress extractNotificationAddress(Map<String, Object> map, String typeName) {
        Map connection;
        DefaultLibraryNotificationAddress address = new DefaultLibraryNotificationAddress(ElasticsearchInterlibraryConfiguration.extractSenderAddress(map, typeName));
        Object o = map.get("LocationTypePostal");
        if (!(o instanceof List)) {
            o = o != null ? Collections.singletonList(o) : Collections.emptyList();
        }
        for (Map location : (List)o) {
            if (!location.containsKey("openingHours")) continue;
            address.setOpeningHours("\u00d6ffnungszeiten " + location.get("openingHours"));
            if (!location.containsKey("openingHoursComments")) continue;
            address.setOpeningHoursComments((String)location.get("openingHoursComments"));
        }
        o = map.get("Connection");
        if (!(o instanceof List)) {
            o = o != null ? Collections.singletonList(o) : Collections.emptyList();
        }
        boolean found = false;
        ArrayList emails = new ArrayList();
        ArrayList<CallSite> phonenumbers = new ArrayList<CallSite>();
        Iterator<Object> iterator = o.iterator();
        while (iterator.hasNext()) {
            connection = (Map)iterator.next();
            if (typeName == null || !typeName.equals(connection.get("connectionTypeName")) || !connection.containsKey("phoneNumber")) continue;
            phonenumbers.add((CallSite)((Object)(connection.get("phoneCountryPrefix") + " " + connection.get("phoneLocationPrefix") + " " + connection.get("phoneNumber"))));
            found = true;
        }
        if (found) {
            address.setPhoneNumber(phonenumbers);
        } else {
            iterator = o.iterator();
            while (iterator.hasNext()) {
                connection = (Map)iterator.next();
                if (!connection.containsKey("phoneNumber")) continue;
                phonenumbers.add((CallSite)((Object)(connection.get("phoneCountryPrefix") + " " + connection.get("phoneLocationPrefix") + " " + connection.get("phoneNumber"))));
            }
            if (!phonenumbers.isEmpty()) {
                address.setPhoneNumber(phonenumbers);
            }
        }
        o = map.get("HomepageURL");
        if (!(o instanceof List)) {
            o = o != null ? Collections.singletonList(o) : Collections.emptyList();
        }
        for (Map homepage : (List)o) {
            if (!homepage.containsKey("resourceLocator")) continue;
            address.setHomePageURL((String)homepage.get("resourceLocator"));
        }
        return address;
    }

    private static LibraryPostalAddress extractPostalAddress(Map<String, Object> map, String typename) {
        DefaultLibraryPostalAddress address = new DefaultLibraryPostalAddress(ElasticsearchInterlibraryConfiguration.extractNotificationAddress(map, typename));
        List<Object> o = map.get("MediaTransport");
        if (!(o instanceof List)) {
            o = o != null ? Collections.singletonList(o) : Collections.emptyList();
        }
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (Map map2 : o) {
            if ("CONTAINER".equals(map2.get("mediaType"))) {
                list.add((CallSite)((Object)("Containertransport " + map2.get("mediaTransportType"))));
                continue;
            }
            list.add((CallSite)((Object)("Transportdienst " + map2.get("mediaType"))));
        }
        if (!list.isEmpty()) {
            address.setContainerInformation(list);
        }
        return address;
    }

    private static String extractEmail(Map<String, Object> map, String typename) {
        String email = null;
        List<Object> o = map.get("LibraryServiceExtension");
        if (!(o instanceof List)) {
            o = o != null ? Collections.singletonList(o) : Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        for (Map map2 : o) {
            String code = (String)map2.get("libraryServiceExtensionCode");
            if (!typename.equals(code)) continue;
            email = (String)map2.get("libraryServiceExtensionEmail");
        }
        return email;
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            super.close();
            this.searchClient.close();
        }
    }
}

