/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.interlibrary.elasticsearch;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.xbib.content.settings.Settings;
import org.xbib.elx.api.SearchClient;
import org.xbib.interlibrary.action.resolve.AbstractResolveService;
import org.xbib.interlibrary.action.resolve.ResolveRequest;
import org.xbib.interlibrary.action.resolve.ResolveResponse;
import org.xbib.interlibrary.api.BibliographicDescription;
import org.xbib.interlibrary.api.action.Response;
import org.xbib.interlibrary.api.service.ServiceArguments;
import org.xbib.interlibrary.common.DefaultBibliographicDescription;

public class ElasticsearchResolveService
extends AbstractResolveService {
    private static final Logger logger = Logger.getLogger(ElasticsearchResolveService.class.getName());
    private final String manifestationsIndex;
    private final String manifestationsType;
    private final String partsIndex;
    private final String partsType;
    private final String monographIndex;
    private final AtomicBoolean closed;
    private final SearchClient searchClient;

    public ElasticsearchResolveService(Settings settings, ServiceArguments arguments, SearchClient searchClient) {
        super(settings, arguments);
        this.searchClient = searchClient;
        this.manifestationsIndex = settings.get("manifestations.index", "fixm");
        this.manifestationsType = settings.get("manifestations.type", "manifestations");
        this.partsIndex = settings.get("parts.index", "fixp");
        this.partsType = settings.get("parts.type", "parts");
        this.monographIndex = settings.get("monograph.index", "aleph");
        this.closed = new AtomicBoolean(false);
    }

    public ResolveResponse execute(ResolveRequest resolveRequest) {
        this.ensureOpen();
        BibliographicDescription bibliographicDescription = resolveRequest.getBibliographicDescription();
        DefaultBibliographicDescription.Builder builder = DefaultBibliographicDescription.builder().setISBN(bibliographicDescription.getIsbn()).setISSN(bibliographicDescription.getIssn()).setYear(bibliographicDescription.getYear()).setPart(bibliographicDescription.getPart());
        String source = bibliographicDescription.getSource();
        String sourceId = bibliographicDescription.getSourceId();
        LinkedHashMap<String, String> document = new LinkedHashMap<String, String>();
        if (source == null && sourceId == null) {
            String queryIsbn;
            MatchQueryBuilder queryBuilder;
            Optional searchResponseOptional;
            if (bibliographicDescription.getIssn() != null) {
                String queryIssn = this.normalizeIdentifier(bibliographicDescription.getIssn());
                BoolQueryBuilder queryBuilder2 = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"prism:issn", (Object)queryIssn)).must((QueryBuilder)QueryBuilders.matchQuery((String)"collection", (Object)"zdb"));
                Optional searchResponseOptional2 = this.searchClient.search(arg_0 -> this.lambda$execute$0((QueryBuilder)queryBuilder2, arg_0));
                if (searchResponseOptional2.isPresent()) {
                    SearchHits searchHits = ((SearchResponse)searchResponseOptional2.get()).getHits();
                    SearchHit searchHit = searchHits.getHits()[0];
                    if (searchHits.totalHits() > 1L && logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "more than one hit for ISSN " + queryIssn + ": " + searchHits.totalHits() + " processing just first hit " + searchHit.getIndex() + "/" + searchHit.getType() + "/" + searchHit.getId());
                    }
                    document.putAll(searchHit.getSource());
                    sourceId = searchHit.getId();
                    document.put("_id", sourceId);
                    builder.setSource((String)document.get("collection"));
                    builder.setSourceId(sourceId);
                }
            } else if (bibliographicDescription.getIsbn() != null && (searchResponseOptional = this.searchClient.search(arg_0 -> this.lambda$execute$1((QueryBuilder)(queryBuilder = QueryBuilders.matchQuery((String)"prism:isbn", (Object)(queryIsbn = this.normalizeIdentifier(bibliographicDescription.getIsbn())))), arg_0))).isPresent()) {
                SearchHits searchHits = ((SearchResponse)searchResponseOptional.get()).getHits();
                SearchHit searchHit = searchHits.getHits()[0];
                if (searchHits.totalHits() > 1L && logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "more than one hit for ISBN " + queryIsbn + ": " + searchHits.totalHits() + " proceesing just first hit " + searchHit.getIndex() + "/" + searchHit.getType() + "/" + searchHit.getId());
                }
                document.putAll(searchHit.getSource());
                sourceId = searchHit.getId();
                document.put("_id", sourceId);
                builder.setSource((String)document.get("collection"));
                builder.setSourceId(sourceId);
            }
        } else if (source != null && sourceId != null) {
            String normalizedSource;
            switch (normalizedSource = source.trim().toLowerCase(Locale.ROOT)) {
                case "issn": {
                    sourceId = this.normalizeIdentifier(sourceId);
                    BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"prism:issn", (Object)sourceId)).must((QueryBuilder)QueryBuilders.matchQuery((String)"collection", (Object)"zdb"));
                    Optional searchResponseOptional = this.searchClient.search(arg_0 -> this.lambda$execute$2((QueryBuilder)queryBuilder, arg_0));
                    if (!searchResponseOptional.isPresent()) break;
                    SearchHits searchHits = ((SearchResponse)searchResponseOptional.get()).getHits();
                    SearchHit searchHit = searchHits.getHits()[0];
                    if (searchHits.totalHits() > 1L && logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "more than one hit for ISSN " + sourceId + ": " + searchHits.totalHits() + " proceesing just first hit " + searchHit.getIndex() + "/" + searchHit.getType() + "/" + searchHit.getId());
                    }
                    document.putAll(searchHit.getSource());
                    sourceId = searchHit.getId();
                    document.put("_id", sourceId);
                    builder.setSource("zdb");
                    builder.setSourceId(sourceId);
                    break;
                }
                case "isbn": {
                    sourceId = this.normalizeIdentifier(sourceId);
                    builder.setSource(normalizedSource);
                    builder.setSourceId(sourceId);
                    MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)"prism:isbn", (Object)sourceId);
                    Optional searchResponseOptional = this.searchClient.search(arg_0 -> this.lambda$execute$3((QueryBuilder)queryBuilder, arg_0));
                    if (!searchResponseOptional.isPresent()) break;
                    SearchHits searchHits = ((SearchResponse)searchResponseOptional.get()).getHits();
                    SearchHit searchHit = searchHits.getHits()[0];
                    if (searchHits.totalHits() > 1L && logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "more than one hit for ISBN " + sourceId + ": " + searchHits.totalHits() + " processing just first hit " + searchHit.getIndex() + "/" + searchHit.getType() + "/" + searchHit.getId());
                    }
                    document.putAll(searchHit.getSource());
                    sourceId = searchHit.getId();
                    document.put("_id", sourceId);
                    break;
                }
                case "hbz": {
                    SearchHits searchHits;
                    SearchHit searchHit;
                    String zdbId;
                    String normalizedSourceId = this.normalizeIdentifierHbz(sourceId);
                    builder.setSource(normalizedSource);
                    builder.setSourceId(normalizedSourceId);
                    Optional getResponseOptional = this.searchClient.get(grb -> ((GetRequestBuilder)grb.setIndex(this.manifestationsIndex)).setType(this.manifestationsType).setId(normalizedSourceId));
                    if (getResponseOptional.isPresent()) {
                        GetResponse getResponse = (GetResponse)getResponseOptional.get();
                        document.putAll(getResponse.getSource());
                        sourceId = getResponse.getId();
                        document.put("_id", sourceId);
                        if (document.get("zdb") != null) {
                            builder.setSource("zdb");
                            builder.setSourceId((String)document.get("zdb"));
                            break;
                        }
                        builder.setSource((String)document.get("collection"));
                        builder.setSourceId(sourceId);
                        break;
                    }
                    getResponseOptional = this.searchClient.get(grb -> ((GetRequestBuilder)grb.setIndex(this.partsIndex)).setType(this.partsType).setId(normalizedSourceId));
                    if (getResponseOptional.isPresent()) {
                        GetResponse getResponse = (GetResponse)getResponseOptional.get();
                        document.putAll(getResponse.getSource());
                        sourceId = getResponse.getId();
                        document.put("_id", sourceId);
                        if (document.get("zdb") != null) {
                            builder.setSource("zdb");
                            builder.setSourceId((String)document.get("zdb"));
                            break;
                        }
                        builder.setSource((String)document.get("collection"));
                        builder.setSourceId(sourceId);
                        break;
                    }
                    Optional searchResponseOptional = this.searchClient.search(srb -> srb.setIndices(new String[]{this.monographIndex}).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"RecordIdentifier.identifierForTheRecord", (Object)normalizedSourceId)).setFrom(0).setSize(1));
                    if (!searchResponseOptional.isPresent() || (zdbId = this.extractZDB((searchHit = (searchHits = ((SearchResponse)searchResponseOptional.get()).getHits()).hits()[0]).getSource())) == null) break;
                    if (logger.isLoggable(Level.INFO)) {
                        logger.log(Level.INFO, "remapping of HBZ " + sourceId + " to ZDB " + zdbId);
                    }
                    source = "zdb";
                    sourceId = zdbId;
                    builder.setSource(source);
                    builder.setSourceId(sourceId);
                    Optional getResponseOptional1 = this.searchClient.get(grb -> ((GetRequestBuilder)grb.setIndex(this.manifestationsIndex)).setType(this.manifestationsType).setId(zdbId));
                    if (getResponseOptional1.isPresent()) {
                        document.putAll(((GetResponse)getResponseOptional1.get()).getSource());
                        document.put("_id", zdbId);
                        break;
                    }
                    if (!logger.isLoggable(Level.FINE)) break;
                    logger.log(Level.FINE, () -> "document does not exist: " + this.manifestationsIndex + "/" + this.manifestationsType + "/" + zdbId);
                    break;
                }
                case "zdb": {
                    String normalizedSourceId = this.normalizeIdentifier(sourceId);
                    builder.setSource(normalizedSource);
                    builder.setSourceId(normalizedSourceId);
                    Optional getResponseOptional = this.searchClient.get(grb -> ((GetRequestBuilder)grb.setIndex(this.manifestationsIndex)).setType(this.manifestationsType).setId(normalizedSourceId));
                    if (getResponseOptional.isPresent()) {
                        GetResponse getResponse = (GetResponse)getResponseOptional.get();
                        document.putAll(getResponse.getSource());
                        sourceId = getResponse.getId();
                        document.put("_id", sourceId);
                        break;
                    }
                    if (!logger.isLoggable(Level.FINE)) break;
                    logger.log(Level.FINE, () -> "document does not exist: " + this.manifestationsIndex + "/" + this.manifestationsType + "/" + normalizedSourceId);
                    break;
                }
            }
        }
        DefaultBibliographicDescription description = builder.build();
        return new ResolveResponse(resolveRequest, Response.Status.OK, (BibliographicDescription)description, document, null);
    }

    public String getName() {
        return "elasticsearch";
    }

    public ResolveRequest validate(ResolveRequest request) {
        return request;
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.searchClient.close();
        }
    }

    private String normalizeIdentifier(String sourceId) {
        return sourceId.toLowerCase(Locale.ROOT).trim().replaceAll("\\-", "");
    }

    private String normalizeIdentifierHbz(String sourceId) {
        return sourceId.trim().replaceAll("\\-", "");
    }

    private void ensureOpen() {
        if (this.closed.get()) {
            throw new IllegalStateException("closed");
        }
    }

    private String extractZDB(Map<String, Object> map) {
        if (map.containsKey("IdentifierZDB")) {
            return (String)((Map)map.get("IdentifierZDB")).get("identifierZDB");
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    private /* synthetic */ void lambda$execute$3(QueryBuilder queryBuilder, SearchRequestBuilder srb) {
        srb.setIndices(new String[]{this.manifestationsIndex}).setSize(1).setQuery(queryBuilder);
    }

    private /* synthetic */ void lambda$execute$2(QueryBuilder queryBuilder, SearchRequestBuilder srb) {
        srb.setIndices(new String[]{this.manifestationsIndex}).setSize(1).setQuery(queryBuilder);
    }

    private /* synthetic */ void lambda$execute$1(QueryBuilder queryBuilder, SearchRequestBuilder srb) {
        srb.setIndices(new String[]{this.manifestationsIndex}).setSize(1).setQuery(queryBuilder);
    }

    private /* synthetic */ void lambda$execute$0(QueryBuilder queryBuilder, SearchRequestBuilder srb) {
        srb.setIndices(new String[]{this.manifestationsIndex}).setQuery(queryBuilder).setSize(1);
    }
}

