/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.net.bouncycastle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.xbib.net.bouncycastle.BouncyCastleCertificateProvider;

public final class SelfSignedCertificate {
    private static final Date DEFAULT_NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
    private static final Date DEFAULT_NOT_AFTER = new Date(253402300799000L);
    private static final String BEGIN_KEY = "-----BEGIN PRIVATE KEY-----";
    private static final String END_KEY = "-----END PRIVATE KEY-----";
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT = "-----END CERTIFICATE-----";
    private byte[] keyBytes;
    private byte[] certBytes;
    private X509CertificateHolder cert;
    private PrivateKey key;

    public void generate(String fqdn, SecureRandom random, int bits) throws IOException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "BC");
            keyGen.initialize(bits, random);
            KeyPair keypair = keyGen.generateKeyPair();
            this.key = keypair.getPrivate();
            X500Name name = new X500Name("CN=" + fqdn);
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keypair.getPublic().getEncoded());
            X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(name, BigInteger.valueOf(System.currentTimeMillis()), DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, name, subjectPublicKeyInfo);
            AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256WithRSAEncryption");
            AlgorithmIdentifier digestAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
            AsymmetricKeyParameter caPrivateKeyParameters = PrivateKeyFactory.createKey((byte[])this.key.getEncoded());
            ContentSigner contentSigner = new BcRSAContentSignerBuilder(sigAlgId, digestAlgId).build(caPrivateKeyParameters);
            this.cert = certificateBuilder.build(contentSigner);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(BEGIN_KEY.getBytes(StandardCharsets.US_ASCII));
            outputStream.write(10);
            this.writeEncoded(this.key.getEncoded(), outputStream);
            outputStream.write(END_KEY.getBytes(StandardCharsets.US_ASCII));
            outputStream.write(10);
            this.keyBytes = outputStream.toByteArray();
            outputStream = new ByteArrayOutputStream();
            outputStream.write(BEGIN_CERT.getBytes(StandardCharsets.US_ASCII));
            outputStream.write(10);
            this.writeEncoded(this.cert.getEncoded(), outputStream);
            outputStream.write(END_CERT.getBytes(StandardCharsets.US_ASCII));
            outputStream.write(10);
            this.certBytes = outputStream.toByteArray();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | OperatorCreationException e) {
            throw new IOException(e);
        }
    }

    public InputStream getCertificateInputStream() {
        return new ByteArrayInputStream(this.certBytes);
    }

    public InputStream getPrivateKeyInputStream() {
        return new ByteArrayInputStream(this.keyBytes);
    }

    public PrivateKey getPrivateKey() {
        return this.key;
    }

    public X509Certificate getCertificate() throws CertificateException {
        return new JcaX509CertificateConverter().setProvider(BouncyCastleCertificateProvider.BOUNCYCASTLE).getCertificate(this.cert);
    }

    public void exportPEM(OutputStream outputStream) throws IOException {
        outputStream.write(this.keyBytes);
        outputStream.write(this.certBytes);
    }

    private void writeEncoded(byte[] bytes, OutputStream outputStream) throws IOException {
        byte[] buf = new byte[64];
        byte[] base64 = Base64.encode((byte[])bytes);
        for (int i = 0; i < base64.length; i += buf.length) {
            int index;
            for (index = 0; index != buf.length && i + index < base64.length; ++index) {
                buf[index] = base64[i + index];
            }
            outputStream.write(buf, 0, index);
            outputStream.write(10);
        }
    }
}

