/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.api;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnmappableCharacterException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.xbib.net.PercentEncoder;
import org.xbib.net.PercentEncoders;
import org.xbib.net.URL;
import org.xbib.netty.http.client.api.BackOff;
import org.xbib.netty.http.client.api.ResponseListener;
import org.xbib.netty.http.client.api.UserAgent;
import org.xbib.netty.http.common.HttpAddress;
import org.xbib.netty.http.common.HttpParameters;
import org.xbib.netty.http.common.HttpResponse;
import org.xbib.netty.http.common.cookie.Cookie;

public final class Request {
    private final URL url;
    private final HttpVersion httpVersion;
    private final HttpMethod httpMethod;
    private final HttpHeaders headers;
    private final Collection<Cookie> cookies;
    private final ByteBuf content;
    private final List<InterfaceHttpData> bodyData;
    private final long timeoutInMillis;
    private final boolean followRedirect;
    private final int maxRedirects;
    private int redirectCount;
    private final boolean isBackOff;
    private final BackOff backOff;
    private CompletableFuture<Request> completableFuture;
    private ResponseListener<HttpResponse> responseListener;

    private Request(URL url, HttpVersion httpVersion, HttpMethod httpMethod, HttpHeaders headers, Collection<Cookie> cookies, ByteBuf content, List<InterfaceHttpData> bodyData, long timeoutInMillis, boolean followRedirect, int maxRedirect, int redirectCount, boolean isBackOff, BackOff backOff, ResponseListener<HttpResponse> responseListener) {
        this.url = url;
        this.httpVersion = httpVersion;
        this.httpMethod = httpMethod;
        this.headers = headers;
        this.cookies = cookies;
        this.content = content;
        this.bodyData = bodyData;
        this.timeoutInMillis = timeoutInMillis;
        this.followRedirect = followRedirect;
        this.maxRedirects = maxRedirect;
        this.redirectCount = redirectCount;
        this.isBackOff = isBackOff;
        this.backOff = backOff;
        this.responseListener = responseListener;
    }

    public URL url() {
        return this.url;
    }

    public String absolute() {
        return this.url.toExternalForm();
    }

    public String relative() {
        return this.url.relativeReference();
    }

    public HttpVersion httpVersion() {
        return this.httpVersion;
    }

    public HttpMethod httpMethod() {
        return this.httpMethod;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public Collection<Cookie> cookies() {
        return this.cookies;
    }

    public ByteBuf content() {
        return this.content;
    }

    public List<InterfaceHttpData> getBodyData() {
        return this.bodyData;
    }

    public long getTimeoutInMillis() {
        return this.timeoutInMillis;
    }

    public boolean isFollowRedirect() {
        return this.followRedirect;
    }

    public boolean isBackOff() {
        return this.isBackOff;
    }

    public BackOff getBackOff() {
        return this.backOff;
    }

    public boolean canRedirect() {
        if (!this.followRedirect) {
            return false;
        }
        if (this.redirectCount >= this.maxRedirects) {
            return false;
        }
        ++this.redirectCount;
        return true;
    }

    public void release() {
        if (this.content != null) {
            this.content.release();
        }
    }

    public String toString() {
        return "Request[url=" + this.url + ",version=" + this.httpVersion + ",method=" + this.httpMethod + ",headers=" + this.headers.entries() + ",content=" + (String)(this.content != null && this.content.readableBytes() >= 16 ? this.content.copy(0, 16).toString(StandardCharsets.UTF_8) + "..." : (this.content != null ? this.content.toString(StandardCharsets.UTF_8) : "")) + "]";
    }

    public Request setCompletableFuture(CompletableFuture<Request> completableFuture) {
        this.completableFuture = completableFuture;
        return this;
    }

    public CompletableFuture<Request> getCompletableFuture() {
        return this.completableFuture;
    }

    public void setResponseListener(ResponseListener<HttpResponse> responseListener) {
        this.responseListener = responseListener;
    }

    public void onResponse(HttpResponse httpResponse) {
        if (this.responseListener != null) {
            this.responseListener.onResponse(httpResponse);
        }
        if (this.completableFuture != null) {
            this.completableFuture.complete(this);
        }
    }

    public static Builder get() {
        return Request.builder(HttpMethod.GET);
    }

    public static Builder put() {
        return Request.builder(HttpMethod.PUT);
    }

    public static Builder post() {
        return Request.builder(HttpMethod.POST);
    }

    public static Builder delete() {
        return Request.builder(HttpMethod.DELETE);
    }

    public static Builder head() {
        return Request.builder(HttpMethod.HEAD);
    }

    public static Builder patch() {
        return Request.builder(HttpMethod.PATCH);
    }

    public static Builder trace() {
        return Request.builder(HttpMethod.TRACE);
    }

    public static Builder options() {
        return Request.builder(HttpMethod.OPTIONS);
    }

    public static Builder connect() {
        return Request.builder(HttpMethod.CONNECT);
    }

    public static Builder builder(HttpMethod httpMethod) {
        return Request.builder((ByteBufAllocator)PooledByteBufAllocator.DEFAULT, httpMethod);
    }

    public static Builder builder(HttpMethod httpMethod, Request request) {
        return Request.builder((ByteBufAllocator)PooledByteBufAllocator.DEFAULT, httpMethod).setVersion(request.httpVersion).url(request.url).setHeaders(request.headers).content(request.content).setResponseListener(request.responseListener);
    }

    public static Builder builder(ByteBufAllocator allocator, HttpMethod httpMethod) {
        return new Builder(allocator).setMethod(httpMethod);
    }

    public static class Builder {
        private static final HttpMethod DEFAULT_METHOD = HttpMethod.GET;
        private static final HttpVersion DEFAULT_HTTP_VERSION = HttpVersion.HTTP_1_1;
        private static final String DEFAULT_USER_AGENT = UserAgent.getUserAgent();
        private static final URL DEFAULT_URL = URL.from((String)"http://localhost");
        private static final boolean DEFAULT_GZIP = true;
        private static final boolean DEFAULT_KEEPALIVE = true;
        private static final boolean DEFAULT_FOLLOW_REDIRECT = true;
        private static final long DEFAULT_TIMEOUT_MILLIS = -1L;
        private static final int DEFAULT_MAX_REDIRECT = 10;
        private static final HttpVersion HTTP_2_0 = HttpVersion.valueOf((String)"HTTP/2.0");
        private static final String DEFAULT_FORM_CONTENT_TYPE = "application/x-www-form-urlencoded; charset=utf-8";
        private final ByteBufAllocator allocator;
        private final List<String> removeHeaders;
        private final Collection<Cookie> cookies;
        private PercentEncoder encoder;
        private HttpMethod httpMethod;
        private HttpHeaders headers;
        private HttpVersion httpVersion;
        private String userAgent;
        private boolean keepalive;
        private boolean gzip;
        private URL url;
        private CharSequence contentType;
        private HttpParameters uriParameters;
        private HttpParameters formParameters;
        private ByteBuf content;
        private List<InterfaceHttpData> bodyData;
        private long timeoutInMillis;
        private boolean followRedirect;
        private int maxRedirects;
        private boolean enableBackOff;
        private BackOff backOff;
        private ResponseListener<HttpResponse> responseListener;

        Builder(ByteBufAllocator allocator) {
            this.allocator = allocator;
            this.httpMethod = DEFAULT_METHOD;
            this.httpVersion = DEFAULT_HTTP_VERSION;
            this.userAgent = DEFAULT_USER_AGENT;
            this.gzip = true;
            this.keepalive = true;
            this.url = DEFAULT_URL;
            this.timeoutInMillis = -1L;
            this.followRedirect = true;
            this.maxRedirects = 10;
            this.headers = new DefaultHttpHeaders();
            this.removeHeaders = new ArrayList<String>();
            this.cookies = new HashSet<Cookie>();
            this.bodyData = new ArrayList<InterfaceHttpData>();
            this.charset(StandardCharsets.UTF_8);
        }

        public Builder charset(Charset charset) {
            this.encoder = PercentEncoders.getQueryEncoder((Charset)charset);
            this.formParameters = new HttpParameters((CharSequence)DEFAULT_FORM_CONTENT_TYPE);
            this.uriParameters = new HttpParameters((CharSequence)DEFAULT_FORM_CONTENT_TYPE);
            return this;
        }

        public Builder setMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder enableHttp1() {
            this.httpVersion = HttpVersion.HTTP_1_1;
            return this;
        }

        public Builder enableHttp2() {
            this.httpVersion = HTTP_2_0;
            return this;
        }

        public Builder setVersion(HttpVersion httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        public Builder setVersion(String httpVersion) {
            this.httpVersion = HttpVersion.valueOf((String)httpVersion);
            return this;
        }

        public Builder setTimeoutInMillis(long timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        public Builder remoteAddress(HttpAddress httpAddress) {
            this.url = URL.builder().scheme(httpAddress.isSecure() ? "https" : "http").host(httpAddress.getInetSocketAddress().getHostString()).port(Integer.valueOf(httpAddress.getInetSocketAddress().getPort())).build();
            this.httpVersion = httpAddress.getVersion();
            return this;
        }

        public Builder url(String url) {
            return this.url(URL.from((String)url));
        }

        public Builder url(URL url) {
            this.url = url;
            return this;
        }

        public Builder setHeaders(Map<String, Object> headers) {
            headers.forEach(this::addHeader);
            return this;
        }

        public Builder setHeaders(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public Builder addHeader(String name, Object value) {
            this.headers.add(name, value);
            return this;
        }

        public Builder setHeader(String name, Object value) {
            this.headers.set(name, value);
            return this;
        }

        public Builder removeHeader(String name) {
            this.removeHeaders.add(name);
            return this;
        }

        public Builder contentType(CharSequence contentType) {
            Objects.requireNonNull(contentType);
            this.contentType = contentType;
            this.addHeader(HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
            return this;
        }

        public Builder contentType(CharSequence contentType, Charset charset) {
            Objects.requireNonNull(contentType);
            Objects.requireNonNull(charset);
            this.contentType = contentType;
            this.charset(charset);
            this.addHeader(HttpHeaderNames.CONTENT_TYPE, (Object)(contentType + "; charset=" + charset.name().toLowerCase()));
            return this;
        }

        public Builder setParameters(Map<String, Object> parameters) {
            parameters.forEach(this::addParameter);
            return this;
        }

        public Builder addParameter(String name, Object value) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(value);
            Collection<Object> collection = !(value instanceof Collection) ? Collections.singletonList(value) : (Collection)value;
            String k = this.encode(this.contentType, name);
            collection.forEach(v -> this.uriParameters.addRaw(k, this.encode(this.contentType, v.toString())));
            return this;
        }

        public Builder addRawParameter(String name, String value) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(value);
            this.uriParameters.addRaw(name, value);
            return this;
        }

        public Builder addFormParameter(String name, String value) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(value);
            this.formParameters.addRaw(this.encode(this.contentType, name), this.encode(this.contentType, value));
            return this;
        }

        public Builder addRawFormParameter(String name, String value) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(value);
            this.formParameters.addRaw(name, value);
            return this;
        }

        public Builder addBasicAuthorization(String name, String password) {
            String encoding = Base64.getEncoder().encodeToString((name + ":" + password).getBytes(StandardCharsets.UTF_8));
            this.headers.add((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)("Basic " + encoding));
            return this;
        }

        public Builder addBodyData(InterfaceHttpData data) {
            this.bodyData.add(data);
            return this;
        }

        private String encode(CharSequence contentType, String value) {
            if (value == null) {
                return null;
            }
            try {
                String encodedValue = this.encoder.encode((CharSequence)value);
                if (HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.equals((Object)contentType)) {
                    encodedValue = encodedValue.replace("%20", "+");
                }
                return encodedValue;
            }
            catch (MalformedInputException | UnmappableCharacterException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public Builder addCookie(Cookie cookie) {
            this.cookies.add(cookie);
            return this;
        }

        public Builder acceptGzip(boolean gzip) {
            this.gzip = gzip;
            return this;
        }

        public Builder keepAlive(boolean keepalive) {
            this.keepalive = keepalive;
            return this;
        }

        public Builder setFollowRedirect(boolean followRedirect) {
            this.followRedirect = followRedirect;
            return this;
        }

        public Builder setMaxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return this;
        }

        public Builder enableBackOff(boolean enableBackOff) {
            this.enableBackOff = enableBackOff;
            return this;
        }

        public Builder setBackOff(BackOff backOff) {
            this.backOff = backOff;
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder text(String text) {
            ByteBuf byteBuf = ByteBufUtil.writeUtf8((ByteBufAllocator)this.allocator, (CharSequence)text);
            try {
                this.content(byteBuf, HttpHeaderValues.TEXT_PLAIN);
            }
            finally {
                byteBuf.release();
            }
            return this;
        }

        public Builder json(String json) {
            ByteBuf byteBuf = ByteBufUtil.writeUtf8((ByteBufAllocator)this.allocator, (CharSequence)json);
            try {
                this.content(byteBuf, HttpHeaderValues.APPLICATION_JSON);
            }
            finally {
                byteBuf.release();
            }
            return this;
        }

        public Builder xml(String xml) {
            this.content(xml, (CharSequence)"application/xml");
            return this;
        }

        public Builder content(ByteBuf byteBuf) {
            this.content = byteBuf;
            return this;
        }

        public Builder content(CharSequence charSequence, CharSequence contentType) {
            this.content(charSequence.toString().getBytes(HttpUtil.getCharset((CharSequence)contentType, (Charset)StandardCharsets.UTF_8)), AsciiString.of((CharSequence)contentType));
            return this;
        }

        public Builder content(CharSequence charSequence, CharSequence contentType, Charset charset) {
            this.content(charSequence.toString().getBytes(charset), AsciiString.of((CharSequence)contentType));
            return this;
        }

        public Builder content(byte[] buf, String contentType) {
            this.content(buf, AsciiString.of((CharSequence)contentType));
            return this;
        }

        public Builder content(ByteBuf body, String contentType) {
            this.content(body, AsciiString.of((CharSequence)contentType));
            return this;
        }

        public Builder setResponseListener(ResponseListener<HttpResponse> responseListener) {
            this.responseListener = responseListener;
            return this;
        }

        public Request build() {
            int length;
            DefaultHttpHeaders validatedHeaders = new DefaultHttpHeaders(true);
            validatedHeaders.set(this.headers);
            if (this.url != null) {
                URL.Builder mutator = this.url.mutator();
                this.uriParameters.forEach((k, v) -> v.forEach(vv -> mutator.queryParam(k, vv)));
                this.url = mutator.build();
                String scheme = this.url.getScheme();
                if (this.httpVersion.majorVersion() == 2) {
                    validatedHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)scheme);
                }
                validatedHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)this.url.getHostInfo());
            }
            validatedHeaders.set((CharSequence)HttpHeaderNames.DATE, (Object)DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneOffset.UTC)));
            if (this.userAgent != null) {
                validatedHeaders.set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.userAgent);
            }
            if (this.gzip) {
                validatedHeaders.set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)"gzip");
            }
            if (!this.formParameters.isEmpty()) {
                try {
                    this.content(this.formParameters.getAsQueryString(false), this.formParameters.getContentType());
                }
                catch (MalformedInputException | UnmappableCharacterException e) {
                    throw new IllegalArgumentException();
                }
            }
            int n = length = this.content != null ? this.content.readableBytes() : 0;
            if (!validatedHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && !validatedHeaders.contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) {
                if (length < 0) {
                    validatedHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"chunked");
                } else {
                    validatedHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)Long.toString(length));
                }
            }
            if (!validatedHeaders.contains((CharSequence)HttpHeaderNames.ACCEPT)) {
                validatedHeaders.set((CharSequence)HttpHeaderNames.ACCEPT, (Object)"*/*");
            }
            if (this.httpVersion.majorVersion() == 1 && !this.keepalive) {
                validatedHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
            }
            for (String headerName : this.removeHeaders) {
                validatedHeaders.remove(headerName);
            }
            return new Request(this.url, this.httpVersion, this.httpMethod, (HttpHeaders)validatedHeaders, this.cookies, this.content, this.bodyData, this.timeoutInMillis, this.followRedirect, this.maxRedirects, 0, this.enableBackOff, this.backOff, this.responseListener);
        }

        private void addHeader(AsciiString name, Object value) {
            if (!this.headers.contains((CharSequence)name)) {
                this.headers.add((CharSequence)name, value);
            }
        }

        private void content(byte[] buf, AsciiString contentType) {
            this.content(this.allocator.buffer().writeBytes(buf), contentType);
        }

        private void content(ByteBuf body, AsciiString contentType) {
            this.content = body;
            this.addHeader(HttpHeaderNames.CONTENT_LENGTH, (Object)body.readableBytes());
            this.addHeader(HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        }
    }
}

