/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.ssl.OpenSsl;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.netty.http.client.HttpClientBuilder;
import org.xbib.netty.http.client.HttpClientChannelContext;
import org.xbib.netty.http.client.HttpClientChannelContextDefaults;
import org.xbib.netty.http.client.HttpClientRequestBuilder;
import org.xbib.netty.http.client.HttpRequestBuilder;
import org.xbib.netty.http.client.HttpRequestContext;
import org.xbib.netty.http.client.internal.HttpClientChannelPoolMap;
import org.xbib.netty.http.client.listener.CookieListener;
import org.xbib.netty.http.client.listener.ExceptionListener;
import org.xbib.netty.http.client.listener.HttpHeadersListener;
import org.xbib.netty.http.client.listener.HttpPushListener;
import org.xbib.netty.http.client.listener.HttpResponseListener;
import org.xbib.netty.http.client.util.InetAddressKey;
import org.xbib.netty.http.client.util.NetworkUtils;

public final class HttpClient
implements Closeable {
    private static final Logger logger = Logger.getLogger(HttpClient.class.getName());
    private static final AtomicInteger streamId = new AtomicInteger(3);
    private static final HttpClient INSTANCE = HttpClient.builder().build();
    private final ByteBufAllocator byteBufAllocator;
    private final EventLoopGroup eventLoopGroup;
    private final HttpClientChannelPoolMap poolMap;

    HttpClient(ByteBufAllocator byteBufAllocator, EventLoopGroup eventLoopGroup, Bootstrap bootstrap, int maxConnections, HttpClientChannelContext httpClientChannelContext) {
        this.byteBufAllocator = byteBufAllocator;
        this.eventLoopGroup = eventLoopGroup;
        this.poolMap = new HttpClientChannelPoolMap(this, httpClientChannelContext, bootstrap, maxConnections);
    }

    public static HttpClient getInstance() {
        return INSTANCE;
    }

    public static HttpClientBuilder builder() {
        return new HttpClientBuilder();
    }

    public HttpClientRequestBuilder prepareRequest(HttpMethod method) {
        return new HttpClientRequestBuilder(this, method, this.byteBufAllocator, streamId.getAndAdd(2));
    }

    public HttpRequestBuilder prepareGet() {
        return this.prepareRequest(HttpMethod.GET);
    }

    public HttpRequestBuilder prepareGet(String url) {
        return this.prepareRequest(HttpMethod.GET).setURL(url);
    }

    public HttpRequestBuilder prepareHead() {
        return this.prepareRequest(HttpMethod.HEAD);
    }

    public HttpRequestBuilder prepareHead(String url) {
        return this.prepareRequest(HttpMethod.HEAD).setURL(url);
    }

    public HttpRequestBuilder preparePut() {
        return this.prepareRequest(HttpMethod.PUT);
    }

    public HttpRequestBuilder preparePut(String url) {
        return this.prepareRequest(HttpMethod.PUT).setURL(url);
    }

    public HttpRequestBuilder preparePost() {
        return this.prepareRequest(HttpMethod.POST);
    }

    public HttpRequestBuilder preparePost(String url) {
        return this.prepareRequest(HttpMethod.POST).setURL(url);
    }

    public HttpRequestBuilder prepareDelete() {
        return this.prepareRequest(HttpMethod.DELETE);
    }

    public HttpRequestBuilder prepareDelete(String url) {
        return this.prepareRequest(HttpMethod.DELETE).setURL(url);
    }

    public HttpRequestBuilder prepareOptions() {
        return this.prepareRequest(HttpMethod.OPTIONS);
    }

    public HttpRequestBuilder prepareOptions(String url) {
        return this.prepareRequest(HttpMethod.OPTIONS).setURL(url);
    }

    public HttpRequestBuilder preparePatch() {
        return this.prepareRequest(HttpMethod.PATCH);
    }

    public HttpRequestBuilder preparePatch(String url) {
        return this.prepareRequest(HttpMethod.PATCH).setURL(url);
    }

    public HttpRequestBuilder prepareTrace() {
        return this.prepareRequest(HttpMethod.TRACE);
    }

    public HttpRequestBuilder prepareTrace(String url) {
        return this.prepareRequest(HttpMethod.TRACE).setURL(url);
    }

    public HttpClientChannelPoolMap poolMap() {
        return this.poolMap;
    }

    @Override
    public void close() {
        logger.log(Level.FINE, () -> "closing pool map");
        this.poolMap.close();
        logger.log(Level.FINE, () -> "closing event loop group");
        if (!this.eventLoopGroup.isShuttingDown()) {
            this.eventLoopGroup.shutdownGracefully();
        }
        logger.log(Level.FINE, () -> "closed");
    }

    public void dispatch(HttpRequestContext httpRequestContext) {
        URI uri = httpRequestContext.getURI();
        HttpRequest httpRequest = httpRequestContext.getHttpRequest();
        if (!httpRequestContext.getCookies().isEmpty()) {
            logger.log(Level.FINE, () -> "configured cookies: " + httpRequestContext.getCookies());
            List<Cookie> cookies = httpRequestContext.matchCookies();
            if (!cookies.isEmpty()) {
                logger.log(Level.FINE, () -> "updating cookie header with matched cookies: " + cookies);
                httpRequest.headers().set((CharSequence)HttpHeaderNames.COOKIE, (Object)ClientCookieEncoder.STRICT.encode(cookies));
            }
        }
        logger.log(Level.FINE, () -> "trying URL " + uri);
        if (httpRequestContext.isExpired()) {
            httpRequestContext.fail("request expired");
        }
        if (httpRequestContext.isFailed()) {
            logger.log(Level.FINE, () -> "request is cancelled");
            return;
        }
        HttpVersion version = httpRequestContext.getHttpRequest().protocolVersion();
        boolean secure = "https".equals(uri.getScheme());
        InetAddressKey inetAddressKey = new InetAddressKey(uri.getHost(), uri.getPort(), version, secure);
        FixedChannelPool pool = (FixedChannelPool)this.poolMap.get(inetAddressKey);
        logger.log(Level.FINE, () -> "connecting to " + inetAddressKey);
        Future futureChannel = pool.acquire();
        futureChannel.addListener((GenericFutureListener)((FutureListener)future -> {
            ExceptionListener exceptionListener = httpRequestContext.getExceptionListener();
            if (future.isSuccess()) {
                Channel channel = (Channel)future.getNow();
                ChannelPromise settingsPromise = channel.newPromise();
                httpRequestContext.setSettingsPromise(settingsPromise);
                channel.attr(HttpClientChannelContextDefaults.CHANNEL_POOL_ATTRIBUTE_KEY).set((Object)pool);
                channel.attr(HttpClientChannelContextDefaults.REQUEST_CONTEXT_ATTRIBUTE_KEY).set((Object)httpRequestContext);
                HttpResponseListener httpResponseListener = httpRequestContext.getHttpResponseListener();
                channel.attr(HttpClientChannelContextDefaults.RESPONSE_LISTENER_ATTRIBUTE_KEY).set((Object)httpResponseListener);
                HttpPushListener httpPushListener = httpRequestContext.getHttpPushListener();
                channel.attr(HttpClientChannelContextDefaults.PUSH_LISTENER_ATTRIBUTE_KEY).set((Object)httpPushListener);
                HttpHeadersListener httpHeadersListener = httpRequestContext.getHttpHeadersListener();
                channel.attr(HttpClientChannelContextDefaults.HEADER_LISTENER_ATTRIBUTE_KEY).set((Object)httpHeadersListener);
                CookieListener cookieListener = httpRequestContext.getCookieListener();
                channel.attr(HttpClientChannelContextDefaults.COOKIE_LISTENER_ATTRIBUTE_KEY).set((Object)cookieListener);
                channel.attr(HttpClientChannelContextDefaults.EXCEPTION_LISTENER_ATTRIBUTE_KEY).set((Object)exceptionListener);
                if (httpRequestContext.isFailed()) {
                    logger.log(Level.FINE, () -> "detected fail, close channel");
                    future.cancel(true);
                    if (channel.isOpen()) {
                        channel.close();
                    }
                    logger.log(Level.FINE, () -> "release channel to pool");
                    pool.release(channel);
                    return;
                }
                if (httpRequest.protocolVersion().majorVersion() == 1) {
                    logger.log(Level.FINE, "HTTP1: write and flush " + httpRequest.toString());
                    channel.writeAndFlush((Object)httpRequest).addListener((GenericFutureListener)((ChannelFutureListener)future1 -> {
                        if (httpRequestContext.isFailed()) {
                            logger.log(Level.FINE, () -> "detected fail, close now");
                            future1.cancel(true);
                            if (future1.channel().isOpen()) {
                                future1.channel().close();
                            }
                        }
                    }));
                } else if (httpRequest.protocolVersion().majorVersion() == 2) {
                    logger.log(Level.FINE, () -> "waiting for HTTP/2 settings");
                    settingsPromise.await((long)httpRequestContext.getTimeout(), TimeUnit.MILLISECONDS);
                    logger.log(Level.FINE, () -> "waiting for HTTP/2 responses = " + httpRequestContext.getStreamIdPromiseMap().size());
                    int timeout = httpRequestContext.getTimeout();
                    for (Map.Entry<Integer, Map.Entry<ChannelFuture, ChannelPromise>> entry : httpRequestContext.getStreamIdPromiseMap().entrySet()) {
                        ChannelFuture channelFuture = entry.getValue().getKey();
                        if (channelFuture != null) {
                            logger.log(Level.FINE, "waiting for channel, stream ID = " + entry.getKey());
                            if (!channelFuture.awaitUninterruptibly((long)timeout, TimeUnit.MILLISECONDS)) {
                                IllegalStateException illegalStateException = new IllegalStateException("time out while waiting to write for stream id " + entry.getKey());
                                if (exceptionListener != null) {
                                    exceptionListener.onException(illegalStateException);
                                    httpRequestContext.fail(illegalStateException.getMessage());
                                    ChannelPool channelPool = (ChannelPool)channelFuture.channel().attr(HttpClientChannelContextDefaults.CHANNEL_POOL_ATTRIBUTE_KEY).get();
                                    channelPool.release(channelFuture.channel());
                                }
                                throw illegalStateException;
                            }
                            if (!channelFuture.isSuccess()) {
                                throw new RuntimeException(channelFuture.cause());
                            }
                        }
                        ChannelPromise promise = entry.getValue().getValue();
                        logger.log(Level.FINE, "waiting for promise of stream ID = " + entry.getKey());
                        if (!promise.awaitUninterruptibly((long)timeout, TimeUnit.MILLISECONDS)) {
                            IllegalStateException illegalStateException = new IllegalStateException("time out while waiting for response on stream id " + entry.getKey());
                            if (exceptionListener != null) {
                                exceptionListener.onException(illegalStateException);
                                httpRequestContext.fail(illegalStateException.getMessage());
                                if (channelFuture != null) {
                                    ChannelPool channelPool = (ChannelPool)channelFuture.channel().attr(HttpClientChannelContextDefaults.CHANNEL_POOL_ATTRIBUTE_KEY).get();
                                    channelPool.release(channelFuture.channel());
                                }
                            }
                            throw illegalStateException;
                        }
                        if (promise.isSuccess()) continue;
                        RuntimeException runtimeException = new RuntimeException(promise.cause());
                        if (exceptionListener != null) {
                            exceptionListener.onException(runtimeException);
                            httpRequestContext.fail(runtimeException.getMessage());
                            if (channelFuture != null) {
                                ChannelPool channelPool = (ChannelPool)channelFuture.channel().attr(HttpClientChannelContextDefaults.CHANNEL_POOL_ATTRIBUTE_KEY).get();
                                channelPool.release(channelFuture.channel());
                            }
                        }
                        throw runtimeException;
                    }
                }
            } else {
                if (exceptionListener != null) {
                    exceptionListener.onException(future.cause());
                }
                httpRequestContext.fail(new ConnectException("unable to connect to " + inetAddressKey));
            }
        }));
    }

    public boolean tryRedirect(Channel channel, FullHttpResponse httpResponse, HttpRequestContext httpRequestContext) throws IOException {
        String redirUrl;
        if (httpRequestContext.isFollowRedirect() && (redirUrl = this.findRedirect(httpRequestContext, (HttpResponse)httpResponse)) != null) {
            HttpMethod method;
            HttpMethod httpMethod = method = httpResponse.status().code() == 303 ? HttpMethod.GET : httpRequestContext.getHttpRequest().method();
            if (httpRequestContext.getRedirectCount().getAndIncrement() < httpRequestContext.getMaxRedirects()) {
                this.dispatchRedirect(method, URI.create(redirUrl), httpRequestContext);
            } else {
                httpRequestContext.fail("too many redirections");
                ChannelPool channelPool = (ChannelPool)channel.attr(HttpClientChannelContextDefaults.CHANNEL_POOL_ATTRIBUTE_KEY).get();
                channelPool.release(channel);
            }
            return true;
        }
        return false;
    }

    private String findRedirect(HttpRequestContext httpRequestContext, HttpResponse httpResponse) throws IOException {
        if (httpResponse == null) {
            return null;
        }
        switch (httpResponse.status().code()) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 305: 
            case 307: 
            case 308: {
                String location = URLDecoder.decode(httpResponse.headers().get((CharSequence)HttpHeaderNames.LOCATION), "UTF-8");
                if (location != null && (location.toLowerCase().startsWith("http://") || location.toLowerCase().startsWith("https://"))) {
                    logger.log(Level.FINE, "(absolute) redirect to " + location);
                    return location;
                }
                logger.log(Level.FINE, "(relative->absolute) redirect to " + location);
                return this.makeAbsolute(httpRequestContext.getURI(), location);
            }
        }
        return null;
    }

    private void dispatchRedirect(HttpMethod method, URI uri, HttpRequestContext httpRequestContext) {
        DefaultHttpRequest httpRequest;
        String uriStr;
        String string = uriStr = httpRequestContext.getHttpRequest().protocolVersion().majorVersion() == 2 ? uri.toASCIIString() : this.makeRelative(uri);
        if (method.equals((Object)httpRequestContext.getHttpRequest().method()) && httpRequestContext.getHttpRequest() instanceof DefaultFullHttpRequest) {
            DefaultFullHttpRequest defaultFullHttpRequest = (DefaultFullHttpRequest)httpRequestContext.getHttpRequest();
            FullHttpRequest fullHttpRequest = defaultFullHttpRequest.copy();
            fullHttpRequest.setUri(uriStr);
            httpRequest = fullHttpRequest;
        } else {
            httpRequest = new DefaultHttpRequest(httpRequestContext.getHttpRequest().protocolVersion(), method, uriStr);
        }
        for (Map.Entry e : httpRequestContext.getHttpRequest().headers().entries()) {
            httpRequest.headers().add((String)e.getKey(), e.getValue());
        }
        httpRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)uri.getHost());
        HttpRequestContext redirectContext = new HttpRequestContext(uri, (HttpRequest)httpRequest, httpRequestContext);
        logger.log(Level.FINE, "dispatchRedirect url = " + uri + " with new request " + httpRequest.toString());
        this.dispatch(redirectContext);
    }

    private String makeRelative(URI base) {
        String uri = base.getPath();
        if (base.getQuery() != null) {
            uri = uri + "?" + base.getQuery();
        }
        return uri;
    }

    private String makeAbsolute(URI base, String location) throws UnsupportedEncodingException {
        int defaultPort;
        String path;
        String string = path = base.getPath() == null ? "/" : URLDecoder.decode(base.getPath(), "UTF-8");
        path = location.startsWith("/") ? location : (path.endsWith("/") ? path + location : path + "/" + location);
        String scheme = base.getScheme();
        StringBuilder sb = new StringBuilder(scheme).append("://").append(base.getHost());
        int n = "http".equals(scheme) ? 80 : (defaultPort = "https".equals(scheme) ? 443 : -1);
        if (defaultPort != -1 && base.getPort() != -1 && defaultPort != base.getPort()) {
            sb.append(":").append(base.getPort());
        }
        if (path.charAt(0) != '/') {
            sb.append('/');
        }
        sb.append(path);
        return sb.toString();
    }

    static {
        NetworkUtils.extendSystemProperties();
        logger.log(Level.FINE, () -> "OpenSSL ALPN support: " + OpenSsl.isAlpnSupported());
        logger.log(Level.FINE, () -> "local host name = " + NetworkUtils.getLocalHostName("localhost"));
        logger.log(Level.FINE, NetworkUtils::displayNetworkInterfaces);
    }
}

