/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslProvider;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.TrustManagerFactory;
import org.xbib.netty.http.client.HttpClient;
import org.xbib.netty.http.client.HttpClientChannelContext;
import org.xbib.netty.http.client.HttpClientChannelContextDefaults;
import org.xbib.netty.http.client.internal.HttpClientThreadFactory;
import org.xbib.netty.http.client.util.ClientAuthMode;

public class HttpClientBuilder
implements HttpClientChannelContextDefaults {
    private ByteBufAllocator byteBufAllocator;
    private EventLoopGroup eventLoopGroup;
    private Class<? extends SocketChannel> socketChannelClass;
    private Bootstrap bootstrap;
    private int threads = 0;
    private boolean tcpNodelay = true;
    private boolean keepAlive = true;
    private boolean reuseAddr = true;
    private int tcpSendBufferSize = 65536;
    private int tcpReceiveBufferSize = 65536;
    private int maxChunkSize = 8192;
    private int maxInitialLineLength = 4096;
    private int maxHeadersSize = 8192;
    private int maxConnections = 8;
    private int maxContentLength = 0x6400000;
    private int maxCompositeBufferComponents = 1024;
    private int connectTimeoutMillis = 5000;
    private int readTimeoutMillis = 5000;
    private boolean enableGzip = true;
    private boolean installHttp2Upgrade = false;
    private SslProvider sslProvider = DEFAULT_SSL_PROVIDER;
    private Iterable<String> ciphers = DEFAULT_CIPHERS;
    private CipherSuiteFilter cipherSuiteFilter = DEFAULT_CIPHER_SUITE_FILTER;
    private TrustManagerFactory trustManagerFactory = DEFAULT_TRUST_MANAGER_FACTORY;
    private InputStream keyCertChainInputStream;
    private InputStream keyInputStream;
    private String keyPassword;
    private boolean useServerNameIdentification = true;
    private ClientAuthMode clientAuthMode = DEFAULT_SSL_CLIENT_AUTH_MODE;
    private HttpProxyHandler httpProxyHandler;
    private Socks4ProxyHandler socks4ProxyHandler;
    private Socks5ProxyHandler socks5ProxyHandler;

    public HttpClientBuilder withByteBufAllocator(ByteBufAllocator byteBufAllocator) {
        this.byteBufAllocator = byteBufAllocator;
        return this;
    }

    public HttpClientBuilder withEventLoop(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public HttpClientBuilder withChannelClass(Class<SocketChannel> socketChannelClass) {
        this.socketChannelClass = socketChannelClass;
        return this;
    }

    public HttpClientBuilder withBootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
        return this;
    }

    public HttpClientBuilder setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return this;
    }

    public HttpClientBuilder setThreadCount(int count) {
        this.threads = count;
        return this;
    }

    public HttpClientBuilder setTcpSendBufferSize(int tcpSendBufferSize) {
        this.tcpSendBufferSize = tcpSendBufferSize;
        return this;
    }

    public HttpClientBuilder setTcpReceiveBufferSize(int tcpReceiveBufferSize) {
        this.tcpReceiveBufferSize = tcpReceiveBufferSize;
        return this;
    }

    public HttpClientBuilder setTcpNodelay(boolean tcpNodelay) {
        this.tcpNodelay = tcpNodelay;
        return this;
    }

    public HttpClientBuilder setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public HttpClientBuilder setReuseAddr(boolean reuseAddr) {
        this.reuseAddr = reuseAddr;
        return this;
    }

    public HttpClientBuilder setMaxChunkSize(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    public HttpClientBuilder setMaxInitialLineLength(int maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
        return this;
    }

    public HttpClientBuilder setMaxHeadersSize(int maxHeadersSize) {
        this.maxHeadersSize = maxHeadersSize;
        return this;
    }

    public HttpClientBuilder setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this;
    }

    public HttpClientBuilder setMaxCompositeBufferComponents(int maxCompositeBufferComponents) {
        this.maxCompositeBufferComponents = maxCompositeBufferComponents;
        return this;
    }

    public HttpClientBuilder setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public HttpClientBuilder setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    public HttpClientBuilder setEnableGzip(boolean enableGzip) {
        this.enableGzip = enableGzip;
        return this;
    }

    public HttpClientBuilder setInstallHttp2Upgrade(boolean installHttp2Upgrade) {
        this.installHttp2Upgrade = installHttp2Upgrade;
        return this;
    }

    public HttpClientBuilder withSslProvider(SslProvider sslProvider) {
        this.sslProvider = sslProvider;
        return this;
    }

    public HttpClientBuilder withJdkSslProvider() {
        this.sslProvider = SslProvider.JDK;
        return this;
    }

    public HttpClientBuilder withOpenSSLSslProvider() {
        this.sslProvider = SslProvider.OPENSSL;
        return this;
    }

    public HttpClientBuilder withCiphers(Iterable<String> ciphers) {
        this.ciphers = ciphers;
        return this;
    }

    public HttpClientBuilder withCipherSuiteFilter(CipherSuiteFilter cipherSuiteFilter) {
        this.cipherSuiteFilter = cipherSuiteFilter;
        return this;
    }

    public HttpClientBuilder withTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        this.trustManagerFactory = trustManagerFactory;
        return this;
    }

    public HttpClientBuilder setKeyCert(InputStream keyCertChainInputStream, InputStream keyInputStream) {
        this.keyCertChainInputStream = keyCertChainInputStream;
        this.keyInputStream = keyInputStream;
        return this;
    }

    public HttpClientBuilder setKeyCert(InputStream keyCertChainInputStream, InputStream keyInputStream, String keyPassword) {
        this.keyCertChainInputStream = keyCertChainInputStream;
        this.keyInputStream = keyInputStream;
        this.keyPassword = keyPassword;
        return this;
    }

    public HttpClientBuilder setUseServerNameIdentification(boolean useServerNameIdentification) {
        this.useServerNameIdentification = useServerNameIdentification;
        return this;
    }

    public HttpClientBuilder setClientAuthMode(ClientAuthMode clientAuthMode) {
        this.clientAuthMode = clientAuthMode;
        return this;
    }

    public HttpClientBuilder setHttpProxyHandler(InetSocketAddress proxyAddress) {
        this.httpProxyHandler = new HttpProxyHandler((SocketAddress)proxyAddress);
        return this;
    }

    public HttpClientBuilder setHttpProxyHandler(InetSocketAddress proxyAddress, String username, String password) {
        this.httpProxyHandler = new HttpProxyHandler((SocketAddress)proxyAddress, username, password);
        return this;
    }

    public HttpClientBuilder setSocks4Proxy(InetSocketAddress proxyAddress) {
        this.socks4ProxyHandler = new Socks4ProxyHandler((SocketAddress)proxyAddress);
        return this;
    }

    public HttpClientBuilder setSocks4Proxy(InetSocketAddress proxyAddress, String username) {
        this.socks4ProxyHandler = new Socks4ProxyHandler((SocketAddress)proxyAddress, username);
        return this;
    }

    public HttpClientBuilder setSocks5Proxy(InetSocketAddress proxyAddress) {
        this.socks5ProxyHandler = new Socks5ProxyHandler((SocketAddress)proxyAddress);
        return this;
    }

    public HttpClientBuilder setSocks5Proxy(InetSocketAddress proxyAddress, String username, String password) {
        this.socks5ProxyHandler = new Socks5ProxyHandler((SocketAddress)proxyAddress, username, password);
        return this;
    }

    public HttpClient build() {
        if (this.byteBufAllocator == null) {
            this.byteBufAllocator = PooledByteBufAllocator.DEFAULT;
        }
        if (this.eventLoopGroup == null) {
            this.eventLoopGroup = new NioEventLoopGroup(this.threads, (ThreadFactory)new HttpClientThreadFactory());
        }
        if (this.socketChannelClass == null) {
            this.socketChannelClass = NioSocketChannel.class;
        }
        if (this.bootstrap == null) {
            this.bootstrap = new Bootstrap();
        }
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)this.tcpNodelay);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)this.keepAlive);
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)this.reuseAddr);
        this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.tcpSendBufferSize);
        this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.tcpReceiveBufferSize);
        this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)this.byteBufAllocator);
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeoutMillis);
        this.bootstrap.group(this.eventLoopGroup);
        this.bootstrap.channel(this.socketChannelClass);
        HttpClientChannelContext httpClientChannelContext = new HttpClientChannelContext(this.maxInitialLineLength, this.maxHeadersSize, this.maxChunkSize, this.maxContentLength, this.maxCompositeBufferComponents, this.readTimeoutMillis, this.enableGzip, this.installHttp2Upgrade, this.sslProvider, this.ciphers, this.cipherSuiteFilter, this.trustManagerFactory, this.keyCertChainInputStream, this.keyInputStream, this.keyPassword, this.useServerNameIdentification, this.clientAuthMode, this.httpProxyHandler, this.socks4ProxyHandler, this.socks5ProxyHandler);
        return new HttpClient(this.byteBufAllocator, this.eventLoopGroup, this.bootstrap, this.maxConnections, httpClientChannelContext);
    }
}

