/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.netty.http.client.HttpClient;
import org.xbib.netty.http.client.HttpRequestBuilder;
import org.xbib.netty.http.client.HttpRequestContext;
import org.xbib.netty.http.client.HttpRequestDefaults;
import org.xbib.netty.http.client.HttpRequestFuture;
import org.xbib.netty.http.client.listener.CookieListener;
import org.xbib.netty.http.client.listener.ExceptionListener;
import org.xbib.netty.http.client.listener.HttpHeadersListener;
import org.xbib.netty.http.client.listener.HttpPushListener;
import org.xbib.netty.http.client.listener.HttpResponseListener;

public class HttpClientRequestBuilder
implements HttpRequestBuilder,
HttpRequestDefaults {
    private static final Logger logger = Logger.getLogger(HttpClientRequestBuilder.class.getName());
    private static final HttpVersion HTTP_2_0 = HttpVersion.valueOf((String)"HTTP/2.0");
    private final HttpClient httpClient;
    private final ByteBufAllocator byteBufAllocator;
    private final AtomicInteger streamId;
    private final DefaultHttpHeaders headers;
    private final List<String> removeHeaders;
    private final Set<Cookie> cookies;
    private final HttpMethod httpMethod;
    private int timeout = 5000;
    private HttpVersion httpVersion = DEFAULT_HTTP_VERSION;
    private String userAgent = DEFAULT_USER_AGENT;
    private boolean gzip = true;
    private boolean followRedirect = true;
    private int maxRedirects = 10;
    private URI uri = DEFAULT_URI;
    private QueryStringEncoder queryStringEncoder;
    private ByteBuf content;
    private HttpRequest httpRequest;
    private HttpRequestFuture<String> httpRequestFuture = DEFAULT_FUTURE;
    private HttpRequestContext httpRequestContext;
    private HttpResponseListener httpResponseListener;
    private ExceptionListener exceptionListener;
    private HttpHeadersListener httpHeadersListener;
    private CookieListener cookieListener;
    private HttpPushListener httpPushListener;

    protected HttpClientRequestBuilder(HttpMethod httpMethod, ByteBufAllocator byteBufAllocator, int streamId) {
        this(null, httpMethod, byteBufAllocator, streamId);
    }

    HttpClientRequestBuilder(HttpClient httpClient, HttpMethod httpMethod, ByteBufAllocator byteBufAllocator, int streamId) {
        this.httpClient = httpClient;
        this.httpMethod = httpMethod;
        this.byteBufAllocator = byteBufAllocator;
        this.streamId = new AtomicInteger(streamId);
        this.headers = new DefaultHttpHeaders();
        this.removeHeaders = new ArrayList<String>();
        this.cookies = new HashSet<Cookie>();
    }

    public static HttpRequestBuilder builder(HttpMethod httpMethod) {
        return new HttpClientRequestBuilder(httpMethod, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, 3);
    }

    public HttpRequestBuilder withFuture(HttpRequestFuture<String> httpRequestFuture) {
        this.httpRequestFuture = httpRequestFuture;
        return this;
    }

    @Override
    public HttpRequestBuilder setHttp1() {
        this.httpVersion = HttpVersion.HTTP_1_1;
        return this;
    }

    @Override
    public HttpRequestBuilder setHttp2() {
        this.httpVersion = HTTP_2_0;
        return this;
    }

    @Override
    public HttpRequestBuilder setVersion(String httpVersion) {
        this.httpVersion = HttpVersion.valueOf((String)httpVersion);
        return this;
    }

    @Override
    public HttpRequestBuilder setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public HttpRequestBuilder setURL(String url) {
        this.uri = URI.create(url);
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.uri, StandardCharsets.UTF_8);
        this.queryStringEncoder = new QueryStringEncoder(queryStringDecoder.path());
        for (Map.Entry entry : queryStringDecoder.parameters().entrySet()) {
            for (String value : (List)entry.getValue()) {
                this.queryStringEncoder.addParam((String)entry.getKey(), value);
            }
        }
        return this;
    }

    @Override
    public HttpRequestBuilder path(String path) {
        if (this.uri != null) {
            this.setURL(this.uri.resolve(path).toString());
        } else {
            this.setURL(path);
        }
        return this;
    }

    @Override
    public HttpRequestBuilder addHeader(String name, Object value) {
        this.headers.add(name, value);
        return this;
    }

    @Override
    public HttpRequestBuilder setHeader(String name, Object value) {
        this.headers.set(name, value);
        return this;
    }

    @Override
    public HttpRequestBuilder removeHeader(String name) {
        this.removeHeaders.add(name);
        return this;
    }

    @Override
    public HttpRequestBuilder addParam(String name, String value) {
        if (this.queryStringEncoder != null) {
            this.queryStringEncoder.addParam(name, value);
        }
        return this;
    }

    @Override
    public HttpRequestBuilder addCookie(Cookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    @Override
    public HttpRequestBuilder contentType(String contentType) {
        this.addHeader(HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        return this;
    }

    @Override
    public HttpRequestBuilder acceptGzip(boolean gzip) {
        this.gzip = gzip;
        return this;
    }

    @Override
    public HttpRequestBuilder setFollowRedirect(boolean followRedirect) {
        this.followRedirect = followRedirect;
        return this;
    }

    @Override
    public HttpRequestBuilder setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
        return this;
    }

    @Override
    public HttpRequestBuilder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public HttpRequestBuilder text(String text) throws IOException {
        this.content((CharSequence)text, HttpHeaderValues.TEXT_PLAIN);
        return this;
    }

    @Override
    public HttpRequestBuilder json(String json) throws IOException {
        this.content((CharSequence)json, HttpHeaderValues.APPLICATION_JSON);
        return this;
    }

    @Override
    public HttpRequestBuilder xml(String xml) throws IOException {
        this.content((CharSequence)xml, "application/xml");
        return this;
    }

    @Override
    public HttpRequestBuilder content(CharSequence charSequence, String contentType) throws IOException {
        this.content(charSequence.toString().getBytes(CharsetUtil.UTF_8), AsciiString.of((CharSequence)contentType));
        return this;
    }

    @Override
    public HttpRequestBuilder content(byte[] buf, String contentType) throws IOException {
        this.content(buf, AsciiString.of((CharSequence)contentType));
        return this;
    }

    @Override
    public HttpRequestBuilder content(ByteBuf body, String contentType) throws IOException {
        this.content(body, AsciiString.of((CharSequence)contentType));
        return this;
    }

    @Override
    public HttpRequestBuilder onHeaders(HttpHeadersListener httpHeadersListener) {
        this.httpHeadersListener = httpHeadersListener;
        return this;
    }

    @Override
    public HttpRequestBuilder onCookie(CookieListener cookieListener) {
        this.cookieListener = cookieListener;
        return this;
    }

    @Override
    public HttpRequestBuilder onResponse(HttpResponseListener httpResponseListener) {
        this.httpResponseListener = httpResponseListener;
        return this;
    }

    @Override
    public HttpRequestBuilder onException(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
        return this;
    }

    @Override
    public HttpRequestBuilder onPushReceived(HttpPushListener httpPushListener) {
        this.httpPushListener = httpPushListener;
        return this;
    }

    @Override
    public HttpRequest build() {
        int defaultPort;
        if (this.uri == null) {
            throw new IllegalStateException("URL not set");
        }
        if (this.uri.getHost() == null) {
            throw new IllegalStateException("URL host not set: " + this.uri);
        }
        DefaultHttpRequest httpRequest = this.createHttpRequest();
        String scheme = this.uri.getScheme();
        StringBuilder sb = new StringBuilder(this.uri.getHost());
        int n = "http".equals(scheme) ? 80 : (defaultPort = "https".equals(scheme) ? 443 : -1);
        if (defaultPort != -1 && this.uri.getPort() != -1 && defaultPort != this.uri.getPort()) {
            sb.append(":").append(this.uri.getPort());
        }
        if (this.httpVersion.majorVersion() == 2) {
            httpRequest.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)scheme);
        }
        String host = sb.toString();
        httpRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)host);
        httpRequest.headers().add((CharSequence)HttpHeaderNames.DATE, (Object)DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.ofInstant(Instant.now(), ZoneId.of("GMT"))));
        if (this.userAgent != null) {
            httpRequest.headers().add((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.userAgent);
        }
        if (this.gzip) {
            httpRequest.headers().add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)"gzip");
        }
        httpRequest.headers().setAll((HttpHeaders)this.headers);
        if (!httpRequest.headers().contains((CharSequence)HttpHeaderNames.ACCEPT)) {
            httpRequest.headers().add((CharSequence)HttpHeaderNames.ACCEPT, (Object)"*/*");
        }
        if (this.httpVersion.majorVersion() == 1 && !httpRequest.headers().contains((CharSequence)HttpHeaderNames.CONNECTION)) {
            httpRequest.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        }
        for (String headerName : this.removeHeaders) {
            httpRequest.headers().remove(headerName);
        }
        return httpRequest;
    }

    @Override
    public HttpRequestContext execute() {
        return this.execute(this.httpClient);
    }

    @Override
    public HttpRequestContext execute(HttpClient httpClient) {
        if (httpClient == null) {
            return null;
        }
        if (this.httpRequest == null) {
            this.httpRequest = this.build();
        }
        if (this.httpResponseListener == null) {
            this.httpResponseListener = this.httpRequestContext;
        }
        this.httpRequestContext = new HttpRequestContext(this.uri, this.httpRequest, this.httpRequestFuture, this.streamId, this.timeout, System.currentTimeMillis(), this.followRedirect, this.maxRedirects, new AtomicInteger(0), this.httpResponseListener, this.exceptionListener, this.httpHeadersListener, this.cookieListener, this.httpPushListener);
        if (!this.cookies.isEmpty()) {
            for (Cookie cookie : this.cookies) {
                this.httpRequestContext.addCookie(cookie);
            }
        }
        httpClient.dispatch(this.httpRequestContext);
        return this.httpRequestContext;
    }

    @Override
    public <T> CompletableFuture<T> execute(Function<FullHttpResponse, T> supplier) {
        CompletableFuture completableFuture = new CompletableFuture();
        this.onResponse(response -> completableFuture.complete(supplier.apply(response)));
        this.onException(completableFuture::completeExceptionally);
        this.execute();
        return completableFuture;
    }

    private DefaultHttpRequest createHttpRequest() {
        String requestTarget = this.toOriginForm();
        logger.log(Level.FINE, () -> "origin form is " + requestTarget);
        return this.content == null ? new DefaultHttpRequest(this.httpVersion, this.httpMethod, requestTarget) : new DefaultFullHttpRequest(this.httpVersion, this.httpMethod, requestTarget, this.content);
    }

    private String toOriginForm() {
        StringBuilder sb = new StringBuilder();
        String pathAndQuery = this.queryStringEncoder.toString();
        sb.append(pathAndQuery.isEmpty() ? "/" : pathAndQuery);
        String ref = this.uri.getFragment();
        if (ref != null && !ref.isEmpty()) {
            sb.append('#').append(ref);
        }
        return sb.toString();
    }

    private void addHeader(AsciiString name, Object value) {
        this.headers.add((CharSequence)name, value);
    }

    private void content(CharSequence charSequence, AsciiString contentType) throws IOException {
        this.content(charSequence.toString().getBytes(CharsetUtil.UTF_8), contentType);
    }

    private void content(byte[] buf, AsciiString contentType) throws IOException {
        this.content(this.byteBufAllocator.buffer(buf.length).writeBytes(buf), contentType);
    }

    private void content(ByteBuf body, AsciiString contentType) throws IOException {
        this.content = body;
        this.addHeader(HttpHeaderNames.CONTENT_LENGTH, (Object)body.readableBytes());
        this.addHeader(HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
    }
}

