/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.internal.PlatformDependent;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.xbib.netty.http.client.HttpRequestDefaults;
import org.xbib.netty.http.client.HttpRequestFuture;
import org.xbib.netty.http.client.listener.CookieListener;
import org.xbib.netty.http.client.listener.ExceptionListener;
import org.xbib.netty.http.client.listener.HttpHeadersListener;
import org.xbib.netty.http.client.listener.HttpPushListener;
import org.xbib.netty.http.client.listener.HttpResponseListener;
import org.xbib.netty.http.client.util.LimitedHashSet;

public final class HttpRequestContext
implements HttpResponseListener,
HttpRequestDefaults {
    private static final Logger logger = Logger.getLogger(HttpRequestContext.class.getName());
    private final URI uri;
    private final HttpRequest httpRequest;
    private final HttpRequestFuture<String> httpRequestFuture;
    private final boolean followRedirect;
    private final int maxRedirects;
    private final AtomicInteger redirectCount;
    private final Integer timeout;
    private final Long startTime;
    private final AtomicInteger streamId;
    private final HttpResponseListener httpResponseListener;
    private final ExceptionListener exceptionListener;
    private final HttpHeadersListener httpHeadersListener;
    private final CookieListener cookieListener;
    private final HttpPushListener httpPushListener;
    private final Map<Integer, Map.Entry<ChannelFuture, ChannelPromise>> promiseMap;
    private final Map<Integer, Map.Entry<Http2Headers, ChannelPromise>> pushMap;
    private ChannelPromise settingsPromise;
    private Collection<Cookie> cookies;
    private Map<Integer, FullHttpResponse> httpResponses;
    private Long stopTime;

    HttpRequestContext(URI uri, HttpRequest httpRequest, HttpRequestFuture<String> httpRequestFuture, AtomicInteger streamId, int timeout, Long startTime, boolean followRedirect, int maxRedirects, AtomicInteger redirectCount, HttpResponseListener httpResponseListener, ExceptionListener exceptionListener, HttpHeadersListener httpHeadersListener, CookieListener cookieListener, HttpPushListener httpPushListener) {
        this.uri = uri;
        this.httpRequest = httpRequest;
        this.httpRequestFuture = httpRequestFuture;
        this.streamId = streamId;
        this.timeout = timeout;
        this.startTime = startTime;
        this.followRedirect = followRedirect;
        this.maxRedirects = maxRedirects;
        this.redirectCount = redirectCount;
        this.httpResponseListener = httpResponseListener;
        this.exceptionListener = exceptionListener;
        this.httpHeadersListener = httpHeadersListener;
        this.cookieListener = cookieListener;
        this.httpPushListener = httpPushListener;
        this.promiseMap = PlatformDependent.newConcurrentHashMap();
        this.pushMap = PlatformDependent.newConcurrentHashMap();
        this.cookies = new LimitedHashSet<Cookie>(10);
    }

    HttpRequestContext(URI uri, HttpRequest httpRequest, HttpRequestContext httpRequestContext) {
        this.uri = uri;
        this.httpRequest = httpRequest;
        this.httpRequestFuture = httpRequestContext.httpRequestFuture;
        this.streamId = httpRequestContext.streamId;
        this.timeout = httpRequestContext.timeout;
        this.startTime = httpRequestContext.startTime;
        this.followRedirect = httpRequestContext.followRedirect;
        this.maxRedirects = httpRequestContext.maxRedirects;
        this.redirectCount = httpRequestContext.redirectCount;
        this.httpResponseListener = httpRequestContext.httpResponseListener;
        this.exceptionListener = httpRequestContext.exceptionListener;
        this.httpHeadersListener = httpRequestContext.httpHeadersListener;
        this.cookieListener = httpRequestContext.cookieListener;
        this.httpPushListener = httpRequestContext.httpPushListener;
        this.promiseMap = httpRequestContext.promiseMap;
        this.pushMap = httpRequestContext.pushMap;
        this.cookies = httpRequestContext.cookies;
    }

    public URI getURI() {
        return this.uri;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponseListener getHttpResponseListener() {
        return this.httpResponseListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public HttpHeadersListener getHttpHeadersListener() {
        return this.httpHeadersListener;
    }

    public CookieListener getCookieListener() {
        return this.cookieListener;
    }

    public HttpPushListener getHttpPushListener() {
        return this.httpPushListener;
    }

    public void setSettingsPromise(ChannelPromise settingsPromise) {
        this.settingsPromise = settingsPromise;
    }

    public ChannelPromise getSettingsPromise() {
        return this.settingsPromise;
    }

    public Map<Integer, Map.Entry<ChannelFuture, ChannelPromise>> getStreamIdPromiseMap() {
        return this.promiseMap;
    }

    public void putStreamID(Integer streamId, ChannelFuture channelFuture, ChannelPromise channelPromise) {
        logger.log(Level.FINE, () -> "put stream ID " + streamId + " future = " + channelFuture);
        this.promiseMap.put(streamId, new AbstractMap.SimpleEntry<ChannelFuture, ChannelPromise>(channelFuture, channelPromise));
    }

    public Map<Integer, Map.Entry<Http2Headers, ChannelPromise>> getPushMap() {
        return this.pushMap;
    }

    public void receiveStreamID(Integer streamId, Http2Headers headers, ChannelPromise channelPromise) {
        logger.log(Level.FINE, () -> "receive stream ID " + streamId + " " + headers);
        this.pushMap.put(streamId, new AbstractMap.SimpleEntry<Http2Headers, ChannelPromise>(headers, channelPromise));
    }

    public boolean isFinished() {
        return this.promiseMap.isEmpty() && this.pushMap.isEmpty();
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public Collection<Cookie> getCookies() {
        return this.cookies;
    }

    public List<Cookie> matchCookies() {
        return this.cookies.stream().filter(this::matchCookie).collect(Collectors.toList());
    }

    private boolean matchCookie(Cookie cookie) {
        boolean pathMatch;
        boolean domainMatch;
        boolean bl = domainMatch = cookie.domain() == null || this.uri.getHost().endsWith(cookie.domain());
        if (!domainMatch) {
            return false;
        }
        boolean bl2 = pathMatch = "/".equals(cookie.path()) || this.uri.getPath().startsWith(cookie.path());
        if (!pathMatch) {
            return false;
        }
        boolean secure = "https".equals(this.uri.getScheme());
        return secure && cookie.isSecure() || !secure && !cookie.isSecure();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isSucceeded() {
        return this.httpRequestFuture.isSucceeded();
    }

    public boolean isFailed() {
        return this.httpRequestFuture.isFailed();
    }

    public boolean isFollowRedirect() {
        return this.followRedirect;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public AtomicInteger getRedirectCount() {
        return this.redirectCount;
    }

    public boolean isExpired() {
        return this.timeout != null && System.currentTimeMillis() > this.startTime + (long)this.timeout.intValue();
    }

    public long took() {
        return this.stopTime != null ? this.stopTime - this.startTime : -1L;
    }

    public long remaining() {
        return this.startTime + (long)this.timeout.intValue() - System.currentTimeMillis();
    }

    public AtomicInteger getStreamId() {
        return this.streamId;
    }

    public HttpRequestContext get() throws InterruptedException, TimeoutException, ExecutionException {
        return this.get(5000L, TimeUnit.SECONDS);
    }

    public HttpRequestContext get(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
        this.httpRequestFuture.get(timeout, timeUnit);
        this.stopTime = System.currentTimeMillis();
        return this;
    }

    public void success(String reason) {
        logger.log(Level.FINE, () -> "success because of " + reason);
        this.httpRequestFuture.success(reason);
    }

    public void fail(String reason) {
        this.fail(new IllegalStateException(reason));
    }

    public void fail(Exception exception) {
        logger.log(Level.FINE, () -> "failed because of " + exception.getMessage());
        if (this.exceptionListener != null) {
            this.exceptionListener.onException(exception);
        }
        this.httpRequestFuture.fail(exception);
    }

    @Override
    public void onResponse(FullHttpResponse fullHttpResponse) {
        this.httpResponses.put(this.streamId.get(), fullHttpResponse);
    }

    public Map<Integer, FullHttpResponse> getHttpResponses() {
        return this.httpResponses;
    }
}

